/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.pushbase.fragments;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.ContextThemeWrapper;
import androidx.annotation.Keep;
import androidx.fragment.app.DialogFragment;
import com.moengage.core.Logger;
import com.moengage.pushbase.listener.OptionSelectionListener;
import com.moengage.pushbase.model.action.RemindLaterAction;
import java.util.Calendar;
import java.util.LinkedHashMap;

@Keep
public class LaterDialogFragment
extends DialogFragment {
    private static final String TAG = "PushBase_4.2.03_LaterDialogFragment";
    private OptionSelectionListener itemSelected;

    public void setItemSelected(OptionSelectionListener itemSelected) {
        this.itemSelected = itemSelected;
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Bundle extras;
        LinkedHashMap<String, Long> optionsMap;
        block6: {
            Logger.v((String)"PushBase_4.2.03_LaterDialogFragment onCreateDialog() : onCreateDialog called.");
            optionsMap = new LinkedHashMap<String, Long>();
            extras = this.getArguments();
            if (extras != null && extras.containsKey("remindLater")) {
                try {
                    int displayTime;
                    RemindLaterAction remindLaterAction = (RemindLaterAction)extras.getParcelable("remindLater");
                    if (remindLaterAction == null) break block6;
                    if (remindLaterAction.remindAfterHours != -1) {
                        int triggerTime = remindLaterAction.remindAfterHours + Calendar.getInstance().get(11);
                        displayTime = triggerTime > 12 ? triggerTime - 12 : triggerTime;
                        String todayOption = "Today (" + displayTime + ":" + Calendar.getInstance().get(12) + (triggerTime > 11 ? "PM" : "AM") + ")";
                        Calendar c = Calendar.getInstance();
                        c.add(12, remindLaterAction.remindAfterHours * 60);
                        optionsMap.put(todayOption, c.getTimeInMillis());
                    }
                    if (remindLaterAction.remindTomorrowAt != -1) {
                        Calendar c = Calendar.getInstance();
                        c.add(5, 1);
                        c.set(11, remindLaterAction.remindTomorrowAt);
                        c.set(12, 0);
                        displayTime = remindLaterAction.remindTomorrowAt;
                        displayTime = displayTime > 12 ? displayTime - 12 : displayTime;
                        String tomorrowOption = "Tomorrow (" + displayTime + (remindLaterAction.remindTomorrowAt > 11 ? "PM" : "AM") + ")";
                        optionsMap.put(tomorrowOption, c.getTimeInMillis());
                    }
                }
                catch (Exception e) {
                    Logger.e((String)"PushBase_4.2.03_LaterDialogFragment onCreateDialog() : ", (Throwable)e);
                }
            } else {
                extras = new Bundle();
            }
        }
        extras.putBoolean("moe_re_notify", true);
        String dateTimeOption = "Pick a date and time";
        optionsMap.put(dateTimeOption, -1L);
        CharSequence[] options = new CharSequence[optionsMap.size()];
        options = optionsMap.keySet().toArray(options);
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)new ContextThemeWrapper((Context)this.getActivity(), 16973939));
        final CharSequence[] finalOptions = options;
        builder.setTitle((CharSequence)"Later").setItems(finalOptions, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                long triggerAtMillis = (Long)optionsMap.get(finalOptions[which]);
                LaterDialogFragment.this.itemSelected.onItemSelected(triggerAtMillis);
            }
        });
        return builder.create();
    }

    public void onCancel(DialogInterface dialog) {
        super.onCancel(dialog);
        this.itemSelected.onDialogCancelled();
    }
}

