/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.pushbase.activities;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.Keep;
import androidx.fragment.app.FragmentActivity;
import com.moengage.core.Logger;
import com.moengage.core.MoEConstants;
import com.moengage.core.MoEDispatcher;
import com.moengage.pushbase.MoEPushHelper;
import com.moengage.pushbase.model.action.Action;
import com.moengage.pushbase.push.ActionManager;
import com.moengage.pushbase.push.MoEngageNotificationUtils;
import com.moengage.pushbase.push.PushMessageListener;

@Keep
public class PushTracker
extends FragmentActivity {
    private static final String TAG = "PushBase_4.2.03_PushTracker";

    protected void onCreate(Bundle savedInstanceState) {
        try {
            super.onCreate(savedInstanceState);
            Logger.v((String)"PushBase_4.2.03_PushTracker onCreate() : inside Push Tracker.");
            Intent intent = this.getIntent();
            if (null == intent) {
                return;
            }
            Bundle extras = intent.getExtras();
            if (null == extras) {
                return;
            }
            boolean syncNow = false;
            if (intent.hasExtra("gcm_webUrl")) {
                syncNow = true;
            }
            PushMessageListener pushMessageListener = MoEPushHelper.getInstance().getMessageListener();
            pushMessageListener.dismissNotificationAfterClick(this.getApplicationContext(), extras);
            pushMessageListener.logNotificationClicked(this.getApplicationContext(), this.getIntent());
            MoEngageNotificationUtils.deleteImagesIfRequired(this.getApplicationContext(), extras);
            if (extras.containsKey(MoEConstants.PUSH_EXTRA_INAPP_META) || extras.containsKey(MoEConstants.PUSH_EXTRA_INAPP_LEGACY_META)) {
                MoEDispatcher.getInstance((Context)this.getApplicationContext()).showInAppFromPush(extras);
            }
            if (extras.containsKey("moe_action")) {
                this.processActionClick(extras);
            } else {
                extras.putBoolean("moe_isDefaultAction", true);
                pushMessageListener.onHandleRedirection((Activity)this, extras);
            }
            if (syncNow) {
                MoEDispatcher.getInstance((Context)this.getApplicationContext()).sendInteractionData();
            }
            this.finish();
            Logger.v((String)"PushBase_4.2.03_PushTracker onCreate() : Completed.");
        }
        catch (Exception e) {
            Logger.e((String)"PushBase_4.2.03_PushTracker onCreate() : ", (Throwable)e);
        }
    }

    private void processActionClick(Bundle extras) {
        try {
            Logger.v((String)"PushBase_4.2.03_PushTracker processActionClick() : Processing click for moe_action.");
            Parcelable[] parcelables = extras.getParcelableArray("moe_action");
            if (parcelables == null) {
                return;
            }
            ActionManager actionManager = new ActionManager();
            for (Parcelable parcelable : parcelables) {
                Action action = (Action)parcelable;
                actionManager.onActionPerformed((Activity)this, action);
            }
        }
        catch (Exception e) {
            Logger.e((String)"PushBase_4.2.03_PushTracker processActionClick() : ", (Throwable)e);
        }
    }
}

