/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.pushbase.activities;

import android.app.Activity;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.Keep;
import androidx.fragment.app.FragmentActivity;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.pushbase.MoEPushHelper;
import com.moengage.pushbase.MoEPushReceiver;
import com.moengage.pushbase.fragments.DatePickerFragment;
import com.moengage.pushbase.fragments.TimePickerFragment;
import com.moengage.pushbase.listener.DateSelectionListener;
import com.moengage.pushbase.listener.OptionSelectionListener;
import com.moengage.pushbase.listener.TimeSelectionListener;
import com.moengage.pushbase.model.action.Action;
import com.moengage.pushbase.push.ActionManager;
import com.moengage.pushbase.push.MoEngageNotificationUtils;
import com.moengage.pushbase.push.PushMessageListener;
import java.util.Calendar;

@Keep
public class PushClickDialogTracker
extends FragmentActivity
implements DateSelectionListener,
TimeSelectionListener,
OptionSelectionListener {
    private static final String TAG = "PushBase_4.2.03_PushClickDialogTracker";
    private int year;
    private int month;
    private int day;
    private Bundle extras;

    protected void onCreate(Bundle savedInstanceState) {
        try {
            super.onCreate(savedInstanceState);
            Logger.v((String)"PushBase_4.2.03_PushClickDialogTracker onCreate() :");
            Intent intent = this.getIntent();
            if (null == intent) {
                return;
            }
            this.extras = intent.getExtras();
            if (null == this.extras) {
                return;
            }
            PushMessageListener pushMessageListener = MoEPushHelper.getInstance().getMessageListener();
            pushMessageListener.dismissNotificationAfterClick(this.getApplicationContext(), this.extras);
            pushMessageListener.logNotificationClicked(this.getApplicationContext(), this.getIntent());
            MoEngageNotificationUtils.deleteImagesIfRequired(this.getApplicationContext(), this.extras);
            this.extras.putBoolean("moe_re_notify", true);
            if (this.extras.containsKey("moe_action")) {
                this.processActionClick(this.extras);
            } else {
                this.finish();
            }
        }
        catch (Exception e) {
            Logger.e((String)"PushBase_4.2.03_PushClickDialogTracker onCreate() : ", (Throwable)e);
        }
    }

    @Override
    public void onDateSelected(int year, int month, int day) {
        try {
            Logger.v((String)("PushBase_4.2.03_PushClickDialogTracker onDateSelected() : Selected date: " + year + "-" + month + "-" + day));
            this.year = year;
            this.day = day;
            this.month = month;
            TimePickerFragment newFragment = new TimePickerFragment();
            newFragment.setTimeSelectedListener(this);
            newFragment.show(this.getSupportFragmentManager(), "timePicker");
        }
        catch (Exception e) {
            Logger.e((String)"PushBase_4.2.03_PushClickDialogTracker onDateSelected() : ", (Throwable)e);
        }
    }

    @Override
    public void onTimeSelected(int hourOfDay, int minute) {
        try {
            Logger.v((String)("PushBase_4.2.03_PushClickDialogTracker onTimeSelected() : Selected time: " + hourOfDay + ":" + minute));
            Calendar c = Calendar.getInstance();
            c.set(this.year, this.month, this.day, hourOfDay, minute, 0);
            long triggerAtMillis = c.getTimeInMillis();
            Logger.v((String)("PushBase_4.2.03_PushClickDialogTracker onTimeSelected() : Alarm trigger time: " + triggerAtMillis));
            Intent laterIntent = new Intent((Context)this, MoEPushReceiver.class);
            laterIntent.putExtras(MoEUtils.deepCopy((Bundle)this.extras));
            laterIntent.setAction("MOE_ACTION_SHOW_NOTIFICATION");
            PendingIntent alarmPendingIntent = PendingIntent.getBroadcast((Context)this.getApplicationContext(), (int)((int)MoEUtils.currentMillis()), (Intent)laterIntent, (int)0x8000000);
            AlarmManager alarmManager = (AlarmManager)this.getSystemService("alarm");
            alarmManager.set(0, triggerAtMillis, alarmPendingIntent);
            this.finish();
        }
        catch (Exception e) {
            Logger.e((String)"PushBase_4.2.03_PushClickDialogTracker onTimeSelected() : ", (Throwable)e);
        }
    }

    @Override
    public void onTimeDialogCancelled() {
        Logger.v((String)"PushBase_4.2.03_PushClickDialogTracker onTimeDialogCancelled() : Dialog cancelled finishing activity.");
        this.finish();
    }

    @Override
    public void onDateDialogCancelled() {
        Logger.v((String)"PushBase_4.2.03_PushClickDialogTracker onDateDialogCancelled() : Dialog cancelled finishing activity.");
        this.finish();
    }

    private void processActionClick(Bundle extras) {
        try {
            Logger.v((String)"PushBase_4.2.03_PushClickDialogTracker processActionClick() : Processing click on action button.");
            Parcelable[] parcelables = extras.getParcelableArray("moe_action");
            if (parcelables == null) {
                this.finish();
                return;
            }
            ActionManager actionManager = new ActionManager();
            for (Parcelable parcelable : parcelables) {
                Action action = (Action)parcelable;
                actionManager.onActionPerformed((Activity)this, action);
            }
        }
        catch (Exception e) {
            Logger.e((String)"PushBase_4.2.03_PushClickDialogTracker processActionClick() : ", (Throwable)e);
        }
    }

    @Override
    public void onItemSelected(long time) {
        try {
            Logger.v((String)("PushBase_4.2.03_PushClickDialogTracker onItemSelected() : Item selected. Time: " + time));
            if (time != -1L) {
                Intent finalIntent = new Intent(this.getApplicationContext(), MoEPushReceiver.class);
                finalIntent.putExtras(MoEUtils.deepCopy((Bundle)this.extras));
                finalIntent.setAction("MOE_ACTION_SHOW_NOTIFICATION");
                PendingIntent intent = PendingIntent.getBroadcast((Context)this.getApplicationContext(), (int)123, (Intent)finalIntent, (int)0x8000000);
                AlarmManager alarmManager = (AlarmManager)this.getApplication().getSystemService("alarm");
                alarmManager.set(0, time, intent);
                this.finish();
            } else {
                DatePickerFragment newFragment = new DatePickerFragment();
                newFragment.setArguments(this.extras);
                newFragment.setDateSelectedListener(this);
                newFragment.show(this.getSupportFragmentManager(), "datePicker");
            }
        }
        catch (Exception e) {
            Logger.e((String)"PushBase_4.2.03_PushClickDialogTracker onItemSelected() : ", (Throwable)e);
        }
    }

    @Override
    public void onDialogCancelled() {
        this.finish();
    }
}

