/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.pushbase;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.core.RemoteConfig;
import com.moengage.core.internal.analytics.SourceProcessor;
import com.moengage.core.model.TrafficSource;
import com.moengage.pushbase.model.action.Action;
import com.moengage.pushbase.model.action.NavigationAction;

public class PushSourceProcessor {
    private static final String TAG = "PushBase_4.2.03_PushSourceProcessor";
    private Bundle payload;

    public PushSourceProcessor(Bundle pushPayload) {
        this.payload = pushPayload;
    }

    @Nullable
    public TrafficSource getTrafficSourceForCampaign() {
        try {
            Logger.v((String)"PushBase_4.2.03_PushSourceProcessor getTrafficSourceForCampaign() : Will to process traffic source for campaign.");
            if (this.hasAction()) {
                Logger.v((String)"PushBase_4.2.03_PushSourceProcessor getTrafficSourceForCampaign() : Will processes source from moe_action.");
                return this.getTrafficSourceFromAction();
            }
            Logger.v((String)"PushBase_4.2.03_PushSourceProcessor getTrafficSourceForCampaign() : Will process source from default action.");
            SourceProcessor processor = new SourceProcessor();
            TrafficSource source = null;
            String deepLink = this.getDeepLinkFromPayload(this.payload);
            if (!MoEUtils.isEmptyString((String)deepLink) && (source = processor.getTrafficSourceFromUrl(Uri.parse((String)deepLink), RemoteConfig.getConfig().additionalSourceIdentifiers)) != null) {
                return source;
            }
            return processor.getTrafficSourceFromExtras(this.payload, RemoteConfig.getConfig().additionalSourceIdentifiers);
        }
        catch (Exception e) {
            Logger.e((String)"PushBase_4.2.03_PushSourceProcessor getTrafficSourceForCampaign() : ", (Throwable)e);
            return null;
        }
    }

    private TrafficSource getTrafficSourceFromAction() {
        Parcelable[] parcelables = this.payload.getParcelableArray("moe_action");
        if (parcelables == null) {
            return null;
        }
        for (Parcelable parcelable : parcelables) {
            Action action = (Action)parcelable;
            if (!(action instanceof NavigationAction)) continue;
            return this.getTrafficFromNavigation((NavigationAction)action);
        }
        return null;
    }

    private TrafficSource getTrafficFromNavigation(NavigationAction action) {
        if (action.navigationType == null) {
            return null;
        }
        SourceProcessor sourceProcessor = new SourceProcessor();
        switch (action.navigationType) {
            case "deepLink": 
            case "richLanding": {
                return sourceProcessor.getTrafficSourceFromUrl(this.getUriFromAction(action), RemoteConfig.getConfig().additionalSourceIdentifiers);
            }
            case "screenName": {
                if (action.keyValuePair == null) {
                    return null;
                }
                return sourceProcessor.getTrafficSourceFromExtras(action.keyValuePair, RemoteConfig.getConfig().additionalSourceIdentifiers);
            }
        }
        return null;
    }

    private Uri getUriFromAction(NavigationAction action) {
        Uri uri = Uri.parse((String)action.navigationUrl);
        if (action.keyValuePair == null) {
            return uri;
        }
        Uri.Builder builder = uri.buildUpon();
        for (String key : action.keyValuePair.keySet()) {
            builder.appendQueryParameter(key, action.keyValuePair.getString(key));
        }
        return builder.build();
    }

    private boolean hasAction() {
        return this.payload.containsKey("moe_action");
    }

    @Nullable
    private String getDeepLinkFromPayload(Bundle payload) {
        if (payload.containsKey("moe_webUrl")) {
            return payload.getString("moe_webUrl");
        }
        if (payload.containsKey("gcm_webUrl")) {
            return payload.getString("gcm_webUrl");
        }
        return null;
    }
}

