/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.pushbase;

import android.app.TimePickerDialog;
import android.content.Context;
import android.widget.TimePicker;
import androidx.annotation.Keep;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.util.Calendar;

@Keep
public class MoETimePickerDialog
extends TimePickerDialog {
    private int minHour = -1;
    private int minMinute = -1;
    private int maxHour = 25;
    private int maxMinute = 25;
    private int currentHour = 0;
    private int currentMinute = 0;
    private Calendar calendar = Calendar.getInstance();
    private DateFormat dateFormat;

    public MoETimePickerDialog(Context context, TimePickerDialog.OnTimeSetListener callBack, int hourOfDay, int minute, boolean is24HourView) {
        super(context, callBack, hourOfDay, minute, is24HourView);
        this.currentHour = hourOfDay;
        this.currentMinute = minute;
        this.dateFormat = DateFormat.getTimeInstance(3);
        try {
            Class<?> superclass = ((Object)((Object)this)).getClass().getSuperclass();
            Field mTimePickerField = superclass.getDeclaredField("mTimePicker");
            mTimePickerField.setAccessible(true);
            TimePicker mTimePicker = (TimePicker)mTimePickerField.get((Object)this);
            mTimePicker.setOnTimeChangedListener((TimePicker.OnTimeChangedListener)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setMin(int hour, int minute) {
        this.minHour = hour;
        this.minMinute = minute;
    }

    public void setMax(int hour, int minute) {
        this.maxHour = hour;
        this.maxMinute = minute;
    }

    public void onTimeChanged(TimePicker view, int hourOfDay, int minute) {
        boolean validTime = true;
        if (hourOfDay < this.minHour || hourOfDay == this.minHour && minute < this.minMinute) {
            validTime = false;
        }
        if (hourOfDay > this.maxHour || hourOfDay == this.maxHour && minute > this.maxMinute) {
            validTime = false;
        }
        if (validTime) {
            this.currentHour = hourOfDay;
            this.currentMinute = minute;
        }
        this.updateTime(this.currentHour, this.currentMinute);
        this.updateDialogTitle(view, this.currentHour, this.currentMinute);
    }

    private void updateDialogTitle(TimePicker timePicker, int hourOfDay, int minute) {
        this.calendar.set(11, hourOfDay);
        this.calendar.set(12, minute);
        String title = this.dateFormat.format(this.calendar.getTime());
        this.setTitle(title);
    }
}

