/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.pushbase;

import android.app.NotificationManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.Keep;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.pushbase.MoEPushHelper;

@Keep
public class MoEPushReceiver
extends BroadcastReceiver {
    private static final String TAG = "PushBase_4.2.03_PushReceiver";

    public void onReceive(Context context, Intent intent) {
        try {
            Logger.v((String)"PushBase_4.2.03_PushReceiver onReceive() : Inside push receiver");
            if (intent == null || intent.getExtras() == null || MoEUtils.isEmptyString((String)intent.getAction())) {
                return;
            }
            Bundle extras = intent.getExtras();
            String action = intent.getAction();
            Logger.v((String)("PushBase_4.2.03_PushReceiver onReceive() : Action: " + action));
            MoEUtils.dumpIntentExtras((String)TAG, (Bundle)extras);
            switch (action) {
                case "MOE_ACTION_NOTIFICATION_AUTO_DISMISS": {
                    this.handleNotificationDismiss(context, extras);
                    break;
                }
                case "MOE_ACTION_SHOW_NOTIFICATION": {
                    this.handleNotification(context, extras);
                    break;
                }
                default: {
                    Logger.v((String)"PushBase_4.2.03_PushReceiver onReceive() : Not a valid action");
                    break;
                }
            }
        }
        catch (Exception e) {
            Logger.e((String)"PushBase_4.2.03_PushReceiver onReceive() : ", (Throwable)e);
        }
    }

    private void handleNotificationDismiss(Context context, Bundle extras) {
        Logger.v((String)"PushBase_4.2.03_PushReceiver handleNotificationDismiss() : Will dismiss notification");
        int notificationId = extras.getInt("MOE_ACTION_NOTIFICATION_AUTO_DISMISS", -1);
        if (notificationId > 0) {
            NotificationManager manager = (NotificationManager)context.getSystemService("notification");
            manager.cancel(notificationId);
        }
    }

    private void handleNotification(Context context, Bundle extras) {
        Logger.v((String)"PushBase_4.2.03_PushReceiver handleNotification() : Will try to show notification.");
        MoEPushHelper.getInstance().handlePushPayload(context, extras);
    }
}

