/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.pushbase;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Looper;
import androidx.annotation.NonNull;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.core.executor.ITask;
import com.moengage.core.executor.TaskManager;
import com.moengage.pushbase.push.PushMessageListener;
import com.moengage.pushbase.push.task.LogNotificationImpressionTask;
import com.moengage.pushbase.push.task.MoEPushWorkerTask;
import java.util.Map;

public class MoEPushHelper {
    private static final String TAG = "PushBase_4.2.03_MoEPushHelper";
    private static MoEPushHelper instance;
    private PushMessageListener messageListener = new PushMessageListener();

    private MoEPushHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MoEPushHelper getInstance() {
        if (instance != null) return instance;
        Class<MoEPushHelper> clazz = MoEPushHelper.class;
        synchronized (MoEPushHelper.class) {
            if (instance != null) return instance;
            instance = new MoEPushHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Deprecated
    public void handlePushPayload(@NonNull Context context, @NonNull Bundle pushPayload) {
        try {
            if (context == null || pushPayload == null) {
                Logger.w((String)"PushBase_4.2.03_MoEPushHelper handlePushPayload() : Context or Push Payload is null");
                return;
            }
            if (Looper.myLooper() == Looper.getMainLooper()) {
                TaskManager.getInstance().addTaskToQueueBeginning((ITask)new MoEPushWorkerTask(context, "SHOW_NOTIFICATION", pushPayload));
            } else {
                this.getMessageListener().onMessageReceived(context, pushPayload);
            }
        }
        catch (Exception e) {
            Logger.e((String)"PushBase_4.2.03_MoEPushHelper handlePushPayload() : ", (Throwable)e);
        }
    }

    @Deprecated
    public void handlePushPayload(@NonNull Context context, @NonNull Map<String, String> pushPayload) {
        if (context == null || pushPayload == null) {
            Logger.w((String)"PushBase_4.2.03_MoEPushHelper handlePushPayload() : Context or Push payload is null");
            return;
        }
        Bundle payloadBundle = MoEUtils.convertMapToBundle(pushPayload);
        if (payloadBundle == null) {
            return;
        }
        this.handlePushPayload(context, payloadBundle);
    }

    public PushMessageListener getMessageListener() {
        return this.messageListener;
    }

    public void setMessageListener(@NonNull PushMessageListener messageListener) {
        if (messageListener != null) {
            this.messageListener = messageListener;
        }
    }

    public boolean isFromMoEngagePlatform(@NonNull Map<String, String> pushPayload) {
        try {
            if (pushPayload == null) {
                return false;
            }
            if (!pushPayload.containsKey("push_from")) {
                return false;
            }
            return "moengage".equals(pushPayload.get("push_from"));
        }
        catch (Exception e) {
            Logger.e((String)"PushBase_4.2.03_MoEPushHelper isFromMoEngagePlatform() : ", (Throwable)e);
            return false;
        }
    }

    public boolean isFromMoEngagePlatform(@NonNull Bundle pushPayload) {
        try {
            if (pushPayload == null) {
                return false;
            }
            if (!pushPayload.containsKey("push_from")) {
                return false;
            }
            return "moengage".equals(pushPayload.getString("push_from"));
        }
        catch (Exception e) {
            Logger.e((String)"PushBase_4.2.03_MoEPushHelper isFromMoEngagePlatform() : ", (Throwable)e);
            return false;
        }
    }

    void setMessageListenerInternal(Object messageListener) {
        if (messageListener != null && messageListener instanceof PushMessageListener) {
            this.messageListener = (PushMessageListener)messageListener;
        }
    }

    public void logNotificationReceived(@NonNull Context context, @NonNull Map<String, String> notificationPayload) {
        Logger.v((String)("PushBase_4.2.03_MoEPushHelper logNotificationReceived() : Will attempt to log notification received." + notificationPayload));
        if (context == null || notificationPayload == null) {
            Logger.w((String)"PushBase_4.2.03_MoEPushHelper logNotificationReceived() : Either context is null or payload is null. Cannot track notification impression.");
            return;
        }
        if (!this.isFromMoEngagePlatform(notificationPayload)) {
            Logger.w((String)"PushBase_4.2.03_MoEPushHelper logNotificationReceived() : Notification payload not from MoEngage.");
            return;
        }
        TaskManager.getInstance().addTaskToQueue((ITask)new LogNotificationImpressionTask(context, notificationPayload));
    }

    public void logNotificationClick(@NonNull Context context, @NonNull Intent intent) {
        Logger.v((String)("PushBase_4.2.03_MoEPushHelper logNotificationClick() : Will attempt to log notification clicked." + intent));
        if (context == null || intent == null) {
            Logger.w((String)"PushBase_4.2.03_MoEPushHelper logNotificationClick() : Either instance Context or Intent is null. Cannot track notification click.");
            return;
        }
        Bundle bundle = intent.getExtras();
        if (bundle == null) {
            Logger.w((String)"PushBase_4.2.03_MoEPushHelper logNotificationClick() : Intent does not have any extras. Cannot log notification click.");
            return;
        }
        if (!this.isFromMoEngagePlatform(bundle)) {
            Logger.w((String)"PushBase_4.2.03_MoEPushHelper logNotificationClick() : Intent does not have push payload from MoEngage Platform.");
            return;
        }
        this.getMessageListener().logNotificationClicked(context, intent);
    }

    public boolean isSilentPush(@NonNull Map<String, String> pushPayload) {
        if (pushPayload == null) {
            return false;
        }
        return pushPayload.containsKey("gcm_notificationType") && "gcm_silentNotification".equals(pushPayload.get("gcm_notificationType"));
    }
}

