/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.pushbase.push.task;

import android.content.Context;
import android.os.Bundle;
import com.moe.pushlibrary.utils.MoEHelperConstants;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.pushbase.MoEPushHelper;
import com.moengage.pushbase.PushConstants;
import com.moengage.pushbase.push.MoEngageNotificationUtils;
import com.moengage.pushbase.repository.PushDAO;
import java.util.Map;

public class LogNotificationImpressionTask extends SDKTask {
  private static final String TAG = PushConstants.MODULE_TAG + "LogNotificationImpressionTask";

  private Map<String, String> payload;

  public LogNotificationImpressionTask(Context context, Map<String, String> payload) {
    super(context);
    this.payload = payload;
  }

  @Override public TaskResult execute() {
    try {
      Logger.v(TAG + " execute() : Started Execution");
      if (payload == null) return taskResult;
      Bundle payloadBundle = MoEUtils.convertMapToBundle(payload);
      if (payloadBundle == null) return taskResult;
      // add message received time
      payloadBundle.putLong(MoEHelperConstants.EXTRA_MSG_RECEIVED_TIME, MoEUtils.currentMillis());
      String campaignId = payloadBundle.getString(MoEHelperConstants.GCM_EXTRA_CAMPAIGN_ID, "");
      ;
      if (MoEUtils.isEmptyString(campaignId)) return taskResult;
      // check if notification received is already tracked.
      if (PushDAO.getInstance().doesCampaignExists(context, campaignId)) {
        Logger.v(TAG + " execute() : Impression has already been logged by this campaign. Will "
            + "not log impression again.");
        return taskResult;
      }
      // log impression event
      MoEPushHelper.getInstance().getMessageListener()
          .logCampaignImpression(context, payloadBundle);
      // save campaign id
      PushDAO.getInstance().saveCampaignId(context, campaignId);
      // write to inbox
      MoEngageNotificationUtils.addNotificationToInboxIfRequired(context, payloadBundle);
      taskResult.setIsSuccess(true);
      Logger.v(TAG + " execute() : Completed execution.");
    } catch (Exception e) {
      Logger.e(TAG + " execute() : ", e);
    }
    return taskResult;
  }

  @Override public String getTaskTag() {
    return PushConstants.TAG_NOTIFICATION_IMPRESSION_TASK;
  }

  @Override public boolean isSynchronous() {
    return false;
  }
}