/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.pushbase.push.task;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.moe.pushlibrary.utils.MoEHelperConstants;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.core.internal.analytics.AnalyticsHelper;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.pushbase.PushConstants;
import com.moengage.pushbase.PushSourceProcessor;
import com.moengage.pushbase.push.MoEngageNotificationUtils;

/**
 * @author Umang Chamaria
 * Date: 2019-07-15
 */
public class LogNotificationClickTask extends SDKTask {
  private static final String TAG = PushConstants.MODULE_TAG + "LogNotificationClickTask";

  private Intent intent;

  public LogNotificationClickTask(Context context, Intent intent) {
    super(context);
    this.intent = intent;
  }

  @Override public TaskResult execute() {
    try {
      Logger.v(TAG + " execute() : Started Execution.");
      if (intent == null) return taskResult;
      Bundle pushPayload = intent.getExtras();
      if (pushPayload == null) return taskResult;
      String campaignId = pushPayload.getString(MoEHelperConstants.GCM_EXTRA_CAMPAIGN_ID, "");
      if (MoEUtils.isEmptyString(campaignId)) return taskResult;
      PushSourceProcessor processor = new PushSourceProcessor(pushPayload);
      AnalyticsHelper.getInstance(context)
          .onNotificationClicked(context, processor.getTrafficSourceForCampaign());
      MoEngageNotificationUtils.logNotificationClick(context, intent);
      taskResult.setIsSuccess(true);
      Logger.v(TAG + " execute() : Completed Execution.");
    } catch (Exception e) {
      Logger.e(TAG + " execute() : Exception ", e);
    }
    return taskResult;
  }

  @Override public String getTaskTag() {
    return TAG_LOG_NOTIFICATION_CLICK;
  }

  @Override public boolean isSynchronous() {
    return false;
  }
}
