/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.pushbase.model.action;

import android.os.Parcel;
import android.os.Parcelable;
import com.moengage.core.Logger;
import com.moengage.pushbase.PushConstants;

/**
 * @author Umang Chamaria
 * Date: 04/03/20
 */
public class RemindLaterAction extends Action implements Parcelable {

  private static final String TAG = PushConstants.MODULE_TAG + "RemindLaterAction";

  public final int remindAfterHours;
  public final int remindTomorrowAt;

  public RemindLaterAction(String actionType,
      int remindAfterHours, int remindTomorrowAt) {
    super(actionType);
    this.remindAfterHours = remindAfterHours;
    this.remindTomorrowAt = remindTomorrowAt;
  }

  protected RemindLaterAction(Parcel in) {
    super(in.readString());
    remindAfterHours = in.readInt();
    remindTomorrowAt = in.readInt();
  }

  public static final Creator<RemindLaterAction> CREATOR = new Creator<RemindLaterAction>() {
    @Override
    public RemindLaterAction createFromParcel(Parcel in) {
      return new RemindLaterAction(in);
    }

    @Override
    public RemindLaterAction[] newArray(int size) {
      return new RemindLaterAction[size];
    }
  };

  @Override public int describeContents() {
    return 0;
  }

  @Override public void writeToParcel(Parcel dest, int flags) {
    try {
      dest.writeString(actionType);
      dest.writeInt(remindAfterHours);
      dest.writeInt(remindTomorrowAt);
    } catch (Exception e) {
      Logger.e(TAG + " writeToParcel() : ", e);
    }
  }

  @Override public String toString() {
    return "{\n" +
        " \"remindAfterHours\": " + remindAfterHours + ",\n" +
        " \"remindTomorrowAt\": " + remindTomorrowAt + ",\n" +
        " \"actionType\": \"" + actionType + "\" ,\n" +
        '}';
  }
}
