/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.pushbase.model.action;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.moengage.core.Logger;
import com.moengage.pushbase.PushConstants;

/**
 * Navigation action object.
 *
 * @author Umang Chamaria
 * Date: 27/02/20
 */
public class NavigationAction extends Action implements Parcelable {

  private static final String TAG = PushConstants.MODULE_TAG + "NavigationAction";

  /**
   * Type of navigation - Screen-name or deep-link or rich-landing.
   * {@link PushConstants#NAVIGATION_TYPE_SCREEN_NAME}
   * {@link PushConstants#NAVIGATION_TYPE_DEEP_LINK}
   * {@link PushConstants#NAVIGATION_TYPE_RICH_LANDING}
   */
  public final String navigationType;
  /**
   * Navigation string - fully qualified activity name or deep-link.
   */
  public final String navigationUrl;
  /**
   * Additional key value pair for screen-name.
   */
  public final Bundle keyValuePair;

  public NavigationAction(String actionType, String navigationType,
      String navigationUrl, Bundle keyValuePair) {
    super(actionType);
    this.navigationType = navigationType;
    this.navigationUrl = navigationUrl;
    this.keyValuePair = keyValuePair;
  }

  protected NavigationAction(Parcel in) {
    super(in.readString());
    navigationType = in.readString();
    navigationUrl = in.readString();
    keyValuePair = in.readBundle(getClass().getClassLoader());
  }

  public static final Creator<NavigationAction> CREATOR = new Creator<NavigationAction>() {
    @Override
    public NavigationAction createFromParcel(Parcel in) {
      return new NavigationAction(in);
    }

    @Override
    public NavigationAction[] newArray(int size) {
      return new NavigationAction[size];
    }
  };

  @Override public int describeContents() {
    return 0;
  }

  @Override public void writeToParcel(Parcel dest, int flags) {
    try {
      dest.writeString(actionType);
      dest.writeString(navigationType);
      dest.writeString(navigationUrl);
      dest.writeBundle(keyValuePair);
    } catch (Exception e) {
      Logger.e(TAG + " writeToParcel() : ", e);
    }
  }

  @Override public String toString() {
    return "{\n" +
        "\"navigationType\": \"" + navigationType + "\" ,\n" +
        " \"navigationUrl\": \"" + navigationUrl + "\" ,\n" +
        " \"keyValuePair\": " + keyValuePair + ",\n" +
        " \"actionType\": \"" + actionType + "\" ,\n" +
        '}';
  }
}
