/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.pushbase.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.moengage.core.Logger;
import com.moengage.pushbase.PushConstants;

/**
 * @author Umang Chamaria
 * Date: 19/03/20
 */
public class TemplateTrackingMeta implements Parcelable {

  private static final String TAG = PushConstants.MODULE_TAG + "TemplateTrackingMeta";

  public String templateName;
  public int cardId;
  public int widgetId;

  public TemplateTrackingMeta(String templateName, int cardId, int widgetId) {
    this.templateName = templateName;
    this.cardId = cardId;
    this.widgetId = widgetId;
  }

  protected TemplateTrackingMeta(Parcel in) {
    try {
      templateName = in.readString();
      cardId = in.readInt();
      widgetId = in.readInt();
    } catch (Exception e) {
      Logger.e(TAG + " TemplateTrackingMeta() : ", e);
    }
  }

  public static final Creator<TemplateTrackingMeta> CREATOR = new Creator<TemplateTrackingMeta>() {
    @Override
    public TemplateTrackingMeta createFromParcel(Parcel in) {
      return new TemplateTrackingMeta(in);
    }

    @Override
    public TemplateTrackingMeta[] newArray(int size) {
      return new TemplateTrackingMeta[size];
    }
  };

  @Override public int describeContents() {
    return 0;
  }

  @Override public void writeToParcel(Parcel dest, int flags) {
    try {
      dest.writeString(templateName);
      dest.writeInt(cardId);
      dest.writeInt(widgetId);
    } catch (Exception e) {
      Logger.e(TAG + " writeToParcel() : ", e);
    }
  }

  @Override public String toString() {
    return "{\n" +
        "\"templateName\": \"" + templateName + "\" ,\n" +
        " \"cardId\": " + cardId + ",\n" +
        " \"widgetId\": " + widgetId + ",\n" +
        '}';
  }
}
