/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.pushbase.model;

import android.os.Bundle;
import androidx.annotation.Nullable;
import com.moengage.core.SdkConfig;
import com.moengage.pushbase.PushConstants;
import java.util.List;

/**
 * @author Umang Chamaria
 * Date: 24/12/19
 */
public class NotificationPayload {

  public NotificationPayload(Bundle payloadBundle) {
    this.payload = payloadBundle;
  }

  public String notificationType;
  /**
   * Notification Text
   */
  public NotificationText text;
  /**
   * Url of the image to be shown in the notification.
   */
  public String imageUrl;
  /**
   * Channel to which notification should be posted.
   */
  public String channelId;
  /**
   * Deep-link/Activity to be opened on notification click.
   */
  public String defaultAction;
  /**
   * Time at which notification should be deleted from inbox.
   * Epoch value.
   */
  public long inboxExpiry;
  /**
   * Unique identifier for each campaign.
   */
  public String campaignId;
  /**
   * List of Action buttons
   */
  @Nullable public List<ActionButton> actionButtonList;
  /**
   * Enable sdk logs if required.
   */
  public boolean enableDebugLogs;
  /**
   * Payload received from FCM in bundle format.
   */
  public Bundle payload;
  /**
   * Time at which the notification should be cleared if not done already.
   */
  public long autoDismissTime = -1;
  /**
   * If true notification is dismissed on click.
   */
  public boolean shouldDismissOnClick = true;
  /**
   * If true notification is pushed to inbox only and not shown in the drawer.
   */
  public boolean pushToInbox;
  /**
   * If true do not write to inbox.
   */
  public boolean shouldIgnoreInbox;
  /**
   * Tag for the specific campaign.
   */
  public String campaignTag = PushConstants.DEFAULT_NOTIFICATION_TAG;
  /**
   * If true payload has push template.
   */
  public boolean isRichPush;
  /**
   * If true notification will not be cleared on swiping.
   */
  public boolean isPersistent;
  /**
   * If true, the incoming notification does not override the existing notification(if any)
   */
  public boolean shouldShowMultipleNotification =
      SdkConfig.getConfig().pushConfig.shouldShowMultiplePushInDrawer;
  /**
   * Notification large icon url
   */
  @Nullable public String largeIconUrl;
  /**
   * Notification tone
   */
  @Nullable public String sound;

  @Override public String toString() {
    return "{\n" +
        "\"notificationType\": \"" + notificationType + "\" ,\n" +
        " \"text\": " + text + ",\n" +
        " \"imageUrl\": \"" + imageUrl + "\" ,\n" +
        " \"channelId\": \"" + channelId + "\" ,\n" +
        " \"defaultAction\": \"" + defaultAction + "\" ,\n" +
        " \"inboxExpiry\": " + inboxExpiry + ",\n" +
        " \"campaignId\": \"" + campaignId + "\" ,\n" +
        " \"actionButtonList\": " + actionButtonList + ",\n" +
        " \"enableDebugLogs\": " + enableDebugLogs + ",\n" +
        " \"payload\": " + payload + ",\n" +
        " \"autoDismissTime\": " + autoDismissTime + ",\n" +
        " \"shouldDismissOnClick\": " + shouldDismissOnClick + ",\n" +
        " \"pushToInbox\": " + pushToInbox + ",\n" +
        " \"shouldIgnoreInbox\": " + shouldIgnoreInbox + ",\n" +
        " \"campaignTag\": \"" + campaignTag + "\" ,\n" +
        " \"isRichPush\": " + isRichPush + ",\n" +
        " \"isPersistent\": " + isPersistent + ",\n" +
        " \"shouldShowMultipleNotification\": " + shouldShowMultipleNotification + ",\n" +
        " \"largeIconUrl\": \"" + largeIconUrl + "\" ,\n" +
        " \"sound\": \"" + sound + "\" ,\n" +
        '}';
  }
}
