/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 * All rights reserved.
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.pushbase.fragments;

import android.app.Dialog;
import android.app.TimePickerDialog;
import android.content.DialogInterface;
import android.os.Bundle;
import androidx.annotation.Keep;
import androidx.fragment.app.DialogFragment;
import androidx.appcompat.view.ContextThemeWrapper;
import android.text.format.DateFormat;
import android.widget.TimePicker;
import com.moengage.core.Logger;
import com.moengage.pushbase.MoETimePickerDialog;
import com.moengage.pushbase.PushConstants;
import com.moengage.pushbase.listener.TimeSelectionListener;
import java.util.Calendar;

/**
 * Dialog Fragment to show TimePickerDialog
 *
 * @author MoEngage (prashant@moengage.com)
 * @version 1.0
 */
@Keep
public class TimePickerFragment extends DialogFragment
    implements TimePickerDialog.OnTimeSetListener {

  private static final String TAG = PushConstants.MODULE_TAG + "TimePickerFragment";

  private TimeSelectionListener timeSelectedListener;

  public void setTimeSelectedListener(TimeSelectionListener listener) {
    this.timeSelectedListener = listener;
  }

  @Override public Dialog onCreateDialog(Bundle savedInstanceState) {

    // Use the current time as the default values for the picker
    final Calendar c = Calendar.getInstance();

    // Create a new instance of TimePickerDialog and return it
    MoETimePickerDialog timePickerDialog = new MoETimePickerDialog(
        new ContextThemeWrapper(getActivity(), android.R.style.Theme_Holo_Light), this,
        c.get(Calendar.HOUR), c.get(Calendar.MINUTE), DateFormat.is24HourFormat(getActivity()));
    timePickerDialog.setMin(c.get(Calendar.HOUR), c.get(Calendar.MINUTE));
    return timePickerDialog;
  }

  @Override public void onTimeSet(TimePicker view, int hourOfDay, int minute) {
    Logger.v(TAG + " onTimeSet() : Time set by user.");
    timeSelectedListener.onTimeSelected(hourOfDay, minute);
  }

  @Override public void onCancel(DialogInterface dialog) {
    Logger.v(TAG + " onCancel() : Dialog cancelled.");
    super.onCancel(dialog);
    timeSelectedListener.onTimeDialogCancelled();
  }

  @Override public void onDismiss(DialogInterface dialog) {
    Logger.v(TAG + " onDismiss() : Dialog dismissed.");
    super.onDismiss(dialog);
  }
}