/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.pushbase;

/**
 * @author Umang Chamaria
 */

public interface PushConstants {

  String PUSH_PAYLOAD_EXTRA = "update_geo_fences";

  /**
   * Associated with the GCM Payload. The URL to open for a
   */
  String MOE_WEB_URL = "moe_webUrl";

  /**
   * Key to enable MoEngage logs via push notification
   */
  String ENABLE_DEBUG_LOGS = "moe_enable_logs";
  /**
   * Key to expire notification. This is used for SDK version 7713 and above.
   */
  String MOE_NOTIFICATION_EXPIRY = "inbox_expiry";

  String PUSH_PAYLOAD_ATTR_NOTIFICATION_CHANNEL_ID = "moe_channel_id";

  // fallback channel constants
  String NOTIFICATION_FALLBACK_CHANNEL_ID = "moe_default_channel";

  String NOTIFICATION_FALLBACK_CHANNEL_NAME = "General";

  String DEFAULT_NOTIFICATION_TAG = "general";

  String ATTRIBUTE_FROM_APP_OPEN = "from_appOpen";

  String ATTRIBUTE_PUSH_SOURCE = "source";

  String ATTRIBUTE_MOE_PUSH_SOURCE = "moe_push_source";

  String ATTRIBUTE_VALUE_RECEIVED_FROM = "remote_inbox";

  String FROM_ACTION_MANAGER = "is_from_action_button";

  String ATTRIBUTE_CUSTOM_ACTION = "custom_payload";

  String NOTIFICATION_RICH_CHANNEL_ID = "moe_rich_content";

  String NOTIFICATION_RICH_CHANNEL_NAME = "Rich Notification";

  String PAYLOAD_EXTRA_SERVER_SYNC = "moe_sync";

  String PAYLOAD_EXTRA_TYPE = "type";

  String PAYLOAD_EXTRA_SYNC_TYPE_CONFIG = "config";

  String PAYLOAD_EXTRA_SYNC_TYPE_REPORT_ADD = "data";

  String TAG_NOTIFICATION_IMPRESSION_TASK = "LOG_NOTIFICATION_IMPRESSION";

  String MODULE_TAG = "PushBase_" + BuildConfig.MOENGAGE_PUSH_BASE_VERSION + "_";

  String WRITE_TO_INBOX_TASK_TAG = "WRITE_TO_INBOX_TASK";
  String PAYLOAD_ATTRIBUTE_MOE_FEATURES = "moeFeatures";

  String PAYLOAD_ATTRIBUTE_RICH_PUSH = "richPush";
  // action types
  String ACTION_NAVIGATE = "navigate";
  String ACTION_TRACK_ATTR = "track";
  String ACTION_SHARE = "share";
  String ACTION_CALL = "call";
  String ACTION_COPY = "copy";
  String ACTION_SNOOZE = "snooze";
  String ACTION_REMIND_ME_LATER = "remindLater";
  String ACTION_CUSTOM = "custom";
  String ACTION_DISMISS = "dismiss";
  String ACTION_COUPON = "coupon";
  // navigation type, do not change the variable names for navigation types. Exposed to the clients.
  String NAVIGATION_TYPE_SCREEN_NAME = "screenName";
  String NAVIGATION_TYPE_DEEP_LINK = "deepLink";
  String NAVIGATION_TYPE_RICH_LANDING = "richLanding";
  // event tracking type
  String TRACK_TYPE_EVENT = "event";
  String TRACK_TYPE_USER_ATTRIBUTE = "userAttribute";

  String ACTION = "moe_action";
  String WIDGET_ID = "widget_id";
  String CARD_ID = "card_id";
  String TEMPLATE_NAME = "template_name";
  String TEMPLATE_META = "moe_template_meta";

  String REAL_TIME_TRIGGER_IDENTIFIER = "DTSDK";
  String REAL_TIME_TRIGGER_OFFLINE_IDENTIFIER = "shownOffline";

  String ACTION_NOTIFICATION_DISMISS = "MOE_ACTION_NOTIFICATION_AUTO_DISMISS";
  String ACTION_SHOW_NOTIFICATION = "MOE_ACTION_SHOW_NOTIFICATION";

  String KEY_RE_NOTIFY = "moe_re_notify";
  // notification content
  String NOTIFICATION_TITLE = "title";
  String NOTIFICATION_MESSAGE = "body";
  String NOTIFICATION_SUMMARY = "summary";

  int NOTIFICATION_CLEARED_REQUEST_ID = 501;
  String NOTIFICATION_TYPE_SILENT = "gcm_silentNotification";
  // 90days validity
  long DEFAULT_INBOX_TTL = 7776000L;
  String MOE_NOTIFICATION_ID = "MOE_NOTIFICATION_ID";

  String IS_DEFAULT_ACTION = "moe_isDefaultAction";
  String NAV_ACTION = "moe_navAction";
}
