/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 * All rights reserved.
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.pushbase;

import android.app.TimePickerDialog;
import android.content.Context;
import androidx.annotation.Keep;
import android.widget.TimePicker;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.util.Calendar;

/**
 * This is a custom TimePickerDialog with min and max time
 *
 * @author MoEngage (prashant@moengage.com)
 * @version 1.0
 */
@Keep
public class MoETimePickerDialog extends TimePickerDialog {
  private int minHour = -1;
  private int minMinute = -1;

  private int maxHour = 25;
  private int maxMinute = 25;
  private int currentHour = 0;
  private int currentMinute = 0;

  private Calendar calendar = Calendar.getInstance();
  private DateFormat dateFormat;

  public MoETimePickerDialog(Context context, OnTimeSetListener callBack, int hourOfDay, int minute,
      boolean is24HourView) {
    super(context, callBack, hourOfDay, minute, is24HourView);
    currentHour = hourOfDay;
    currentMinute = minute;
    dateFormat = DateFormat.getTimeInstance(DateFormat.SHORT);

    try {
      Class<?> superclass = getClass().getSuperclass();
      Field mTimePickerField = superclass.getDeclaredField("mTimePicker");
      mTimePickerField.setAccessible(true);
      TimePicker mTimePicker = (TimePicker) mTimePickerField.get(this);
      mTimePicker.setOnTimeChangedListener(this);
    } catch (Exception e) {
    }
  }

  public void setMin(int hour, int minute) {
    minHour = hour;
    minMinute = minute;
  }

  public void setMax(int hour, int minute) {
    maxHour = hour;
    maxMinute = minute;
  }

  @Override public void onTimeChanged(TimePicker view, int hourOfDay, int minute) {

    boolean validTime = true;
    if (hourOfDay < minHour || (hourOfDay == minHour && minute < minMinute)) {
      validTime = false;
    }

    if (hourOfDay > maxHour || (hourOfDay == maxHour && minute > maxMinute)) {
      validTime = false;
    }

    if (validTime) {
      currentHour = hourOfDay;
      currentMinute = minute;
    }

    updateTime(currentHour, currentMinute);
    updateDialogTitle(view, currentHour, currentMinute);
  }

  private void updateDialogTitle(TimePicker timePicker, int hourOfDay, int minute) {
    calendar.set(Calendar.HOUR_OF_DAY, hourOfDay);
    calendar.set(Calendar.MINUTE, minute);
    String title = dateFormat.format(calendar.getTime());
    setTitle(title);
  }
}
