/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.pushbase;

import android.app.NotificationManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.Keep;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;

@Keep
public class MoEPushReceiver extends BroadcastReceiver {
  private static final String TAG = PushConstants.MODULE_TAG + "PushReceiver";

  @Override
  public void onReceive(Context context, Intent intent) {
    try {
      Logger.v(TAG + " onReceive() : Inside push receiver");
      if (intent == null || intent.getExtras() == null || MoEUtils.isEmptyString(
          intent.getAction())) {
        return;
      }
      Bundle extras = intent.getExtras();
      String action = intent.getAction();
      Logger.v(TAG + " onReceive() : Action: " + action);
      MoEUtils.dumpIntentExtras(TAG, extras);
      switch (action) {
        case PushConstants.ACTION_NOTIFICATION_DISMISS:
          handleNotificationDismiss(context, extras);
          break;
        case PushConstants.ACTION_SHOW_NOTIFICATION:
          handleNotification(context, extras);
          break;
        default:
          Logger.v(TAG + " onReceive() : Not a valid action");
      }
    } catch (Exception e) {
      Logger.e(TAG + " onReceive() : ", e);
    }
  }

  private void handleNotificationDismiss(Context context, Bundle extras) {
    Logger.v(TAG + " handleNotificationDismiss() : Will dismiss notification");
    int notificationId = extras.getInt(PushConstants.ACTION_NOTIFICATION_DISMISS, -1);
    if (notificationId > 0) {
      NotificationManager manager =
          (NotificationManager) context.getSystemService(Context.NOTIFICATION_SERVICE);
      manager.cancel(notificationId);
    }
  }

  private void handleNotification(Context context, Bundle extras) {
    Logger.v(TAG + " handleNotification() : Will try to show notification.");
    MoEPushHelper.getInstance().handlePushPayload(context, extras);
  }
}
