/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.pushbase.push;

import android.app.Activity;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.NotificationCompat;
import android.support.v4.app.NotificationManagerCompat;
import android.support.v4.app.TaskStackBuilder;
import android.text.TextUtils;
import android.widget.RemoteViews;
import com.moe.pushlibrary.MoEHelper;
import com.moe.pushlibrary.providers.MoEDataContract;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.location.GeoManager;
import com.moengage.push.PushManager;
import com.moengage.pushbase.R;
import com.moengage.pushbase.activities.PushTracker;
import com.moengage.pushbase.push.MoENotificationChannel;
import com.moengage.pushbase.push.MoEPushCallBacks;
import com.moengage.pushbase.push.MoEPushWorker;
import com.moengage.pushbase.push.MoEngageNotificationUtils;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class PushMessageListener {
    private final Object lock = new Object();
    private boolean isNotificationRequiredCalled = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onMessagereceived(Context context, Bundle extras) {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (ConfigurationProvider.getInstance((Context)context).isPushNotificationOptedOut()) {
                    Logger.e((String)"PushMessageListener onMessagereceived() : push notification opted out cannot show push");
                    return;
                }
                if (null == extras || null == context) {
                    return;
                }
                MoEHelperUtils.dumpIntentExtras((Bundle)extras);
                if (MoEngageNotificationUtils.isFromMoEngagePlatform(extras)) {
                    this.logNotificationState(context);
                    if (MoEngageNotificationUtils.hasNotificationExpired(extras)) {
                        Logger.i((String)"Campaign expired, will not be shown");
                        this.logCampaignImpression(context, extras);
                    } else {
                        ConfigurationProvider provider = ConfigurationProvider.getInstance((Context)context);
                        String campaignId = MoEngageNotificationUtils.getCampaignIdIfAny(extras);
                        if (this.isDuplicateCampaign(context, campaignId, provider) && !MoEngageNotificationUtils.isReNotification(extras)) {
                            return;
                        }
                        this.saveCampaignId(context, provider, campaignId);
                        extras.putLong("MOE_MSG_RECEIVED_TIME", System.currentTimeMillis());
                        if (this.isNotificationRequired(context, extras)) {
                            Logger.i((String)"PushMessageListener: onMessageReceived Will try to show notification");
                            MoEPushCallBacks.getInstance().onPushReceived(extras);
                            this.enableLogsIfRequired(context, extras);
                            NotificationCompat.Builder builder = this.onCreateNotification(context, extras, provider);
                            Intent finalIntent = this.getRedirectIntent(context);
                            extras.putAll(MoEngageNotificationUtils.getMoEngageExtras(extras));
                            finalIntent.putExtras(extras);
                            boolean updateExisting = MoEngageNotificationUtils.getNotificationDisplayType(extras, context) == 1;
                            int notificationId = MoEngageNotificationUtils.isCarouselNotification(extras) && MoEngageNotificationUtils.getNotificationIdIfAny(extras) != -1 ? MoEngageNotificationUtils.getNotificationIdIfAny(extras) : this.getNotificationId(context, provider, updateExisting);
                            MoEngageNotificationUtils.setNotificationId(finalIntent, notificationId);
                            MoEngageNotificationUtils.setNotificationAutoDismissIfAny(context, notificationId, extras);
                            MoEngageNotificationUtils.setNotificationClearedCallback(context, builder, notificationId, extras);
                            PendingIntent contentIntent = MoEngageNotificationUtils.getContentIntent(context, finalIntent, updateExisting, notificationId);
                            MoEngageNotificationUtils.setActionButtonIfPresentAndSupported(context, extras, builder, finalIntent, notificationId);
                            builder.setContentIntent(contentIntent);
                            Notification notification = builder.build();
                            this.customizeNotification(notification, context, extras);
                            if (MoEngageNotificationUtils.isCarouselNotification(extras)) {
                                this.createCarouselNotification(notification, context, finalIntent, extras, notificationId);
                            }
                            if (!this.isNotificationRequiredCalled) {
                                throw new IllegalStateException("super.isNotificationRequired(context, extras) not called.");
                            }
                            NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
                            notificationManager.notify(notificationId, notification);
                        } else if (!MoEngageNotificationUtils.isSilentPush(extras)) {
                            this.onNotificationNotRequired(context, extras);
                        }
                        this.isNotificationRequiredCalled = false;
                        if (!(MoEngageNotificationUtils.isSilentPush(extras) || TextUtils.isEmpty((CharSequence)MoEngageNotificationUtils.getCampaignIdIfAny(extras)) || MoEngageNotificationUtils.isReNotification(extras))) {
                            if (!MoEngageNotificationUtils.isSkipNotificationCenter(extras)) {
                                this.addToMoEngageInbox(context, extras);
                            }
                            this.logCampaignImpression(context, extras);
                            this.onPostNotificationReceived(context, extras);
                        }
                    }
                } else {
                    this.onNonMoEngageMessageReceived(context, extras);
                }
            }
            catch (Exception e) {
                Logger.f((String)"PushMessageListener:onMessageReceived", (Throwable)e);
            }
        }
    }

    private void enableLogsIfRequired(Context context, Bundle extras) {
        String logState;
        if (extras != null && extras.containsKey("moe_enable_logs") && !TextUtils.isEmpty((CharSequence)(logState = extras.getString("moe_enable_logs")))) {
            boolean logStateToSet = false;
            switch (logState) {
                case "true": {
                    logStateToSet = true;
                    break;
                }
                case "false": {
                    logStateToSet = false;
                }
            }
            ConfigurationProvider.getInstance((Context)context).setDebugLogStatus(logStateToSet);
            Logger.setLogLevel((int)5);
            Logger.enableDebugLog((Context)context);
        }
    }

    private void saveCampaignId(Context context, ConfigurationProvider provider, String campaignId) {
        try {
            provider.setLastPushCampaignId(campaignId);
            ContentValues values = new ContentValues();
            values.put("campaign_id", campaignId);
            values.put("ttl", Long.valueOf(System.currentTimeMillis() + provider.getCampaignIdTTL()));
            context.getContentResolver().insert(MoEDataContract.CampaignListEntity.getContentUri((Context)context), values);
        }
        catch (Exception e) {
            Logger.f((String)"PushMessageListener saveCampaignId() ", (Throwable)e);
        }
    }

    protected void onPostNotificationReceived(Context context, Bundle extras) {
    }

    public void onNonMoEngageMessageReceived(Context context, Bundle extras) {
    }

    public void onNotificationNotRequired(Context context, Bundle extras) {
    }

    public boolean isNotificationRequired(Context context, Bundle extras) {
        this.isNotificationRequiredCalled = true;
        if (MoEngageNotificationUtils.isSilentPush(extras)) {
            GeoManager.LocationHandler locationHandler;
            if ((MoEHelperUtils.hasPermission((Context)context, (String)"android.permission.ACCESS_FINE_LOCATION") || MoEHelperUtils.hasPermission((Context)context, (String)"android.permission.ACCESS_COARSE_LOCATION")) && this.shouldMakeGeoFenceCall(extras) && (locationHandler = GeoManager.getInstance().getHandler(context)) != null) {
                locationHandler.updateFenceAndLocation(context);
            }
            return false;
        }
        if (!TextUtils.isEmpty((CharSequence)MoEngageNotificationUtils.getCampaignIdIfAny(extras))) {
            return !MoEngageNotificationUtils.isPushToInbox(extras);
        }
        return false;
    }

    public NotificationCompat.Builder onCreateNotification(Context context, Bundle extras, ConfigurationProvider provider) {
        String channelId = MoENotificationChannel.getInstance().getNotificationChannelId(context, extras);
        if (TextUtils.isEmpty((CharSequence)channelId) || !MoENotificationChannel.getInstance().isChannelExists(context, channelId)) {
            Logger.e((String)"PushMessageListener: onCreateNotification() Did not find channel id setting using Fallback channel");
            MoENotificationChannel.getInstance().createFallbackNotificationChanelIfRequired(context);
            channelId = "moe_default_channel";
        }
        NotificationCompat.Builder builder = new NotificationCompat.Builder(context, channelId);
        builder.setAutoCancel(MoEngageNotificationUtils.isAutoCancelEnabled(extras));
        MoEngageNotificationUtils.setSubTextIfAny(extras, builder);
        MoEngageNotificationUtils.setContentIfPresent(extras, builder);
        MoEngageNotificationUtils.setTitleIfPresent(extras, builder);
        MoEngageNotificationUtils.setCategoryIfPresentAndSupported(extras, builder);
        MoEngageNotificationUtils.setSmallIcon(context, builder, provider);
        MoEngageNotificationUtils.setColorOrLargeIconIfPresentAndSupported(context, extras, builder, provider);
        MoEngageNotificationUtils.setNotificationPriorityIfPresentAndSupported(extras, builder);
        MoEngageNotificationUtils.setTickerTextIfPresent(extras, builder);
        this.setNotificationSound(context, extras, builder, provider);
        MoEngageNotificationUtils.setVisibilityIfPresentAndSupported(extras, builder);
        MoEngageNotificationUtils.setNotificationStyle(context, extras, builder);
        return builder;
    }

    public Intent getRedirectIntent(Context context) {
        Intent pushTrackerIntent = new Intent(context, PushTracker.class);
        pushTrackerIntent.setAction("" + System.currentTimeMillis());
        pushTrackerIntent.setFlags(0x10000000);
        return pushTrackerIntent;
    }

    public final void logCampaignImpression(Context context, Bundle extras) {
        MoEngageNotificationUtils.logNotificationImpression(context, extras);
    }

    public final int getNotificationId(Context context, ConfigurationProvider configProvider, boolean update) {
        return MoEngageNotificationUtils.getNotificationId(context, configProvider, update);
    }

    public final void addToMoEngageInbox(Context context, Bundle extras) {
        Logger.v((String)"PushMessagingListener: addToMoEngageInbox: ");
        String msgDetails = MoEngageNotificationUtils.convertBundletoJSONString(extras);
        ContentValues values = new ContentValues();
        if (null != msgDetails) {
            values.put("msg", msgDetails);
        }
        long gTime = extras.getLong("MOE_MSG_RECEIVED_TIME");
        values.put("gtime", Long.valueOf(gTime));
        values.put("msgclicked", Integer.valueOf(0));
        values.put("msgttl", Long.valueOf(MoEngageNotificationUtils.getNotificationTTL(extras, gTime)));
        String msgTags = MoEngageNotificationUtils.getMessageTagsIfAny(extras);
        if (TextUtils.isEmpty((CharSequence)msgTags)) {
            values.put("msg_tag", "general");
        } else {
            values.put("msg_tag", msgTags);
        }
        Uri newRecord = context.getContentResolver().insert(MoEDataContract.MessageEntity.getContentUri((Context)context), values);
        if (null != newRecord) {
            Logger.v((String)("PushMessagingListener: added new record with entry: " + newRecord));
        } else {
            Logger.f((String)"PushMessagingListener: FAILED to add new record with entry: ");
        }
    }

    public void setNotificationSound(Context context, Bundle extras, NotificationCompat.Builder builder, ConfigurationProvider provider) {
        MoEngageNotificationUtils.setSoundIfPresentAndSupported(context, extras, builder, provider);
    }

    public void customizeNotification(Notification notification, Context context, Bundle extras) {
        int ledColor;
        boolean vibrate = true;
        if (Build.VERSION.SDK_INT <= 18 && !MoEHelperUtils.hasPermission((Context)context, (String)"android.permission.VIBRATE")) {
            vibrate = false;
        }
        if (vibrate && !MoEngageNotificationUtils.isVibrationDisabled(extras)) {
            notification.defaults |= 2;
        }
        if (-1 != (ledColor = MoEngageNotificationUtils.getNotificationLedLightColor(extras))) {
            notification.flags |= 1;
            notification.ledARGB = ledColor;
        } else {
            notification.defaults = 4;
        }
    }

    private boolean isDuplicateCampaign(Context context, String currentCampaignId, ConfigurationProvider provider) {
        if (TextUtils.isEmpty((CharSequence)currentCampaignId)) {
            return false;
        }
        String lastCampaignId = provider.getLastPushCampaignId();
        if (currentCampaignId.equals(lastCampaignId)) {
            Logger.e((String)("PushMessagingListener:isDuplicateCampaign-->Last campaign ID and current campaign ID is same : " + currentCampaignId));
            return true;
        }
        return this.isMessageShown(context, currentCampaignId);
    }

    private boolean isNotTheIntendedRecipient(Context context, Bundle extras, ConfigurationProvider provider) {
        String recipientId = MoEngageNotificationUtils.getRecipientUserId(extras);
        if (TextUtils.isEmpty((CharSequence)recipientId)) {
            return false;
        }
        String thisUser = provider.getCurrentUserId();
        return !recipientId.equals(thisUser);
    }

    public void onHandleRedirection(Activity activity, Bundle extras) {
        Logger.v((String)"PushMessageListener: onHandleRedirection()");
        Intent launcherIntent = MoEHelperUtils.getLauncherActivityIntent((Context)activity);
        try {
            String notificationType = extras.getString("gcm_notificationType");
            if (!TextUtils.isEmpty((CharSequence)notificationType) && "gcm_webNotification".equals(notificationType)) {
                Uri finalLink = null;
                if (PushManager.getInstance().isMoEngageExtrasOptedOut() || extras.containsKey("optOutOfExtras")) {
                    String url;
                    if (extras.containsKey("moe_webUrl") && !TextUtils.isEmpty((CharSequence)(url = extras.getString("moe_webUrl")))) {
                        finalLink = Uri.parse((String)url);
                    }
                } else {
                    Uri link = Uri.parse((String)extras.getString("gcm_webUrl"));
                    Uri.Builder builder = link.buildUpon();
                    builder.appendQueryParameter("nav_provier", "moengage");
                    builder.appendQueryParameter("nav_source", "notification");
                    builder.appendQueryParameter("FROM_BACKGROUND", "" + !MoEHelper.isAppInForeground());
                    extras.remove("gcm_webNotification");
                    extras.remove("gcm_notificationType");
                    MoEngageNotificationUtils.setMoEngageExtrastoUri(extras, builder);
                    finalLink = builder.build();
                }
                if (!MoEPushCallBacks.getInstance().onPushNavigationAction(null, extras, finalLink)) {
                    Logger.v((String)"PushMessagingListener:onHandleRedirection-->Web notification");
                    if (finalLink == null) {
                        return;
                    }
                    Logger.v((String)("PushMessagingListener:onHandleRedirection : Final URI : " + finalLink.toString()));
                    Intent redirectIntent = new Intent("android.intent.action.VIEW", finalLink);
                    redirectIntent.addFlags(this.getIntentFlags(extras));
                    activity.startActivity(redirectIntent);
                }
                return;
            }
            String activityName = extras.getString("gcm_activityName");
            Intent redirectIntent = !TextUtils.isEmpty((CharSequence)activityName) ? new Intent((Context)activity, Class.forName(activityName)) : launcherIntent;
            extras.putBoolean("FROM_BACKGROUND", !MoEHelper.isAppInForeground());
            extras.putString("nav_provier", "moengage");
            extras.putString("nav_source", "notification");
            redirectIntent.putExtras(extras);
            redirectIntent.addFlags(this.getIntentFlags(extras));
            if (!MoEPushCallBacks.getInstance().onPushNavigationAction(activityName, extras, null)) {
                if (!PushManager.getInstance().isBackStackBuilderOptedOut(activity.getApplicationContext())) {
                    TaskStackBuilder builder = TaskStackBuilder.create((Context)activity);
                    builder.addNextIntentWithParentStack(redirectIntent).startActivities();
                } else {
                    activity.startActivity(redirectIntent);
                }
            }
            return;
        }
        catch (ClassNotFoundException e) {
            Logger.f((String)"PushMessagingListener:onHandleRedirection--> Activity not found ", (Throwable)e);
        }
        catch (Exception e) {
            Logger.f((String)"PushMessagingListener:onHandleRedirection--> generic exception ", (Throwable)e);
        }
        activity.startActivity(launcherIntent);
    }

    public final void logNotificationClicked(Context context, Intent intent) {
        MoEngageNotificationUtils.logNotificationClick(context, intent);
    }

    public final void dismissNotificationAfterClick(Context context, Bundle extras) {
        int notificationId = MoEngageNotificationUtils.getNotificationIdIfAny(extras);
        if (MoEngageNotificationUtils.isAutoCancelEnabled(extras) && -1 != notificationId) {
            NotificationManager manager = (NotificationManager)context.getSystemService("notification");
            manager.cancel(notificationId);
        }
    }

    public int getIntentFlags(Bundle extras) {
        return 0x30000000;
    }

    private void createCarouselNotification(Notification notification, Context context, Intent finalIntent, Bundle extras, int notificationId) {
        if (Build.VERSION.SDK_INT >= 16) {
            Logger.v((String)"PushMessageListener : createCarouselNotification");
            try {
                JSONObject carouselObject = MoEngageNotificationUtils.getCarouselObject(extras);
                if (carouselObject == null) {
                    return;
                }
                JSONArray imagesArray = MoEngageNotificationUtils.getImagesArray(carouselObject);
                if (imagesArray == null) {
                    return;
                }
                RemoteViews rv = new RemoteViews(context.getPackageName(), R.layout.carousel_custom);
                String title = MoEngageNotificationUtils.getCarouselTitle(carouselObject, extras);
                String text = MoEngageNotificationUtils.getCarouselText(carouselObject, extras);
                String subText = MoEngageNotificationUtils.getCarouselSubText(carouselObject, extras);
                int smallNotificationIconResourceId = MoEngageNotificationUtils.getCarouselSmallNotificationIcon(context);
                int largeNotificationIconResourceId = MoEngageNotificationUtils.getCarouselLargeNotificationIcon(context);
                rv.setTextViewText(R.id.title, (CharSequence)title);
                rv.setTextViewText(R.id.time, (CharSequence)MoEngageNotificationUtils.getTime());
                rv.setTextViewText(R.id.text2, (CharSequence)text);
                boolean hasThreeLines = false;
                if (subText != null) {
                    hasThreeLines = true;
                    rv.setViewVisibility(R.id.text, 0);
                    rv.setTextViewText(R.id.text, (CharSequence)subText);
                    rv.setImageViewResource(R.id.profile_badge_line3, smallNotificationIconResourceId);
                    rv.setViewVisibility(R.id.profile_badge_line3, 0);
                } else {
                    rv.setImageViewResource(R.id.profile_badge_line2, smallNotificationIconResourceId);
                    rv.setViewVisibility(R.id.profile_badge_line2, 0);
                    rv.setViewVisibility(R.id.line3, 8);
                    float regularTextSize = context.getResources().getDimensionPixelSize(R.dimen.notification_text_size);
                    rv.setTextViewTextSize(R.id.text2, 0, regularTextSize);
                }
                rv.setImageViewResource(R.id.icon, largeNotificationIconResourceId);
                rv.setViewPadding(R.id.line1, 0, MoEngageNotificationUtils.calculateTopPadding(context, hasThreeLines), 0, 0);
                if (carouselObject.has("carousel_autostart") && carouselObject.getBoolean("carousel_autostart")) {
                    if (!this.createAnimatedCarouselNotification(context, extras, rv, finalIntent, imagesArray, carouselObject)) {
                        return;
                    }
                } else {
                    int idx = extras.getInt("img_idx", 0);
                    Logger.v((String)("PushMessageListener : createCarouselNotification idx" + idx));
                    String campaignId = MoEngageNotificationUtils.getCampaignIdIfAny(extras);
                    String fileName = campaignId + imagesArray.getJSONObject(idx).getString("id");
                    Bitmap bmp = MoEngageNotificationUtils.loadImageFromStorage(context, fileName);
                    if (bmp == null) {
                        MoEngageNotificationUtils.fetchAndSaveImages(context, imagesArray, campaignId);
                        bmp = MoEngageNotificationUtils.loadImageFromStorage(context, fileName);
                        if (bmp == null) {
                            return;
                        }
                    }
                    rv.setImageViewBitmap(R.id.big_picture, bmp);
                    rv.setOnClickPendingIntent(R.id.big_picture, MoEngageNotificationUtils.getImagePendingIntent(context, finalIntent, idx, imagesArray));
                    Intent navIntent = new Intent(context, MoEPushWorker.class);
                    navIntent.setAction("DEAL_WITH_CAROUSEL");
                    navIntent.putExtras(extras);
                    navIntent.putExtra("MOE_NOTIFICATION_ID", notificationId);
                    rv.setOnClickPendingIntent(R.id.next_btn, MoEngageNotificationUtils.getNavPendingIntent(context, navIntent, "m_next", notificationId, idx));
                    rv.setOnClickPendingIntent(R.id.prev_btn, MoEngageNotificationUtils.getNavPendingIntent(context, navIntent, "m_prev", 2 * notificationId, idx));
                }
                MoEngageNotificationUtils.addCarouselActionButton(context, rv, extras, finalIntent, notificationId);
                if (MoEngageNotificationUtils.isReNotification(extras)) {
                    MoEngageNotificationUtils.disableSoundAndVibration(notification);
                }
                notification.bigContentView = rv;
            }
            catch (Exception e) {
                Logger.f((String)("PushMessageListener : createCarouselNotification : Exception occurred " + e));
            }
        }
    }

    private boolean createAnimatedCarouselNotification(Context context, Bundle extras, RemoteViews rv, Intent finalIntent, JSONArray imagesArray, JSONObject carouselObject) {
        try {
            String direction = "right_to_left";
            int imagesCount = imagesArray.length();
            if (imagesCount < 3) {
                Logger.v((String)"PushMessageListener : createAnimatedCarouselNotification : Can't show animated carousel. Images count is less than 3");
                return false;
            }
            String campaignId = MoEngageNotificationUtils.getCampaignIdIfAny(extras);
            MoEngageNotificationUtils.fetchAndSaveImages(context, imagesArray, campaignId);
            if (carouselObject.has("anim_direction")) {
                switch (direction = carouselObject.getString("anim_direction")) {
                    case "left_to_right": {
                        rv.setViewVisibility(R.id.flipper_layout_left_to_right, 0);
                        break;
                    }
                    case "right_to_left": {
                        rv.setViewVisibility(R.id.flipper_layout_right_to_left, 0);
                    }
                }
            } else {
                rv.setViewVisibility(R.id.flipper_layout_right_to_left, 0);
            }
            for (int idx = 0; idx < imagesCount; ++idx) {
                String fileName = campaignId + imagesArray.getJSONObject(idx).getString("id");
                Bitmap bmp = MoEngageNotificationUtils.loadImageFromStorage(context, fileName);
                if (bmp == null) {
                    Logger.v((String)"PushMessageListener : createAnimatedCarouselNotification : One of the images is null rolling back to narrow style");
                    MoEngageNotificationUtils.deleteImagesFromInternal(context, campaignId);
                    return false;
                }
                int viewFlipperImageId = MoEngageNotificationUtils.getViewFlipperImageId(idx, direction);
                rv.setImageViewBitmap(viewFlipperImageId, bmp);
                rv.setViewVisibility(viewFlipperImageId, 0);
                rv.setOnClickPendingIntent(viewFlipperImageId, MoEngageNotificationUtils.getImagePendingIntent(context, finalIntent, idx, imagesArray));
            }
            rv.setViewVisibility(R.id.next_btn, 8);
            rv.setViewVisibility(R.id.prev_btn, 8);
            return true;
        }
        catch (Exception e) {
            Logger.f((String)("PushMessageListener : createAnimatedCarouselNotification : Exception occurred " + e));
            return false;
        }
    }

    public final void onMessagereceived(Context context, Map<String, String> extras) {
        Bundle bundle = MoEUtils.convertMapToBundle(extras);
        if (bundle != null) {
            this.onMessagereceived(context, bundle);
        }
    }

    private boolean shouldMakeGeoFenceCall(Bundle bundle) {
        if (bundle.containsKey("update_geo_fences")) {
            return bundle.getString("update_geo_fences").equals("true");
        }
        return true;
    }

    private void logNotificationState(Context context) {
        try {
            MoEHelper.getInstance((Context)context).setUserAttribute("PUSH_PREFERENCE_ANDROID", NotificationManagerCompat.from((Context)context).areNotificationsEnabled());
        }
        catch (Exception e) {
            Logger.f((String)"PushMessageListener: logNotificationState: ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isMessageShown(Context context, String campaignId) {
        try (Cursor cursor = null;){
            cursor = context.getContentResolver().query(MoEDataContract.CampaignListEntity.getContentUri((Context)context), null, null, null, null);
            if (cursor != null && cursor.moveToFirst()) {
                do {
                    String savedCampaignId;
                    if (TextUtils.isEmpty((CharSequence)(savedCampaignId = cursor.getString(cursor.getColumnIndex("campaign_id")))) || !savedCampaignId.equals(campaignId)) continue;
                    Logger.e((String)("PushMessageListener isDuplicateMessage() : Campaign already shown : " + campaignId));
                    boolean bl = true;
                    return bl;
                } while (cursor.moveToNext());
            }
        }
        return false;
    }
}

