/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.pushbase.push;

import android.app.Activity;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.TaskStackBuilder;
import android.text.TextUtils;
import com.moe.pushlibrary.MoEHelper;
import com.moe.pushlibrary.PayloadBuilder;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.core.ActionManagerBase;
import com.moengage.core.Logger;
import com.moengage.core.MoEDispatcher;
import com.moengage.push.PushManager;
import com.moengage.pushbase.fragments.LaterDialogFragment;
import com.moengage.pushbase.push.MoEPushCallBacks;
import com.moengage.pushbase.push.MoEPushWorker;
import java.util.Calendar;
import org.json.JSONException;
import org.json.JSONObject;

public class PushActionManager
extends ActionManagerBase {
    public static boolean dialogShown = false;
    private static PushActionManager _INSTANCE;
    private IActionHandler actionHandlers;
    Context context;

    public static PushActionManager getInstance() {
        if (null == _INSTANCE) {
            _INSTANCE = new PushActionManager();
        }
        return _INSTANCE;
    }

    public void registerActionHandler(IActionHandler actionHandler) {
        this.actionHandlers = actionHandler;
    }

    private PushActionManager() {
    }

    public boolean onActionPerformed(Activity context, String tag, JSONObject actionObject) {
        this.context = context.getApplicationContext();
        try {
            switch (tag) {
                case "m_nav": {
                    this.handleActionNavigation(context, actionObject);
                    break;
                }
                case "m_track": {
                    this.handleActionTrackEvent((Context)context, actionObject);
                    break;
                }
                case "m_share": {
                    this.handleActionShare(context, actionObject);
                    break;
                }
                case "m_call": {
                    this.handleActionCall(context, actionObject);
                    break;
                }
                case "m_copy": {
                    this.handleActionCopy(context, actionObject);
                    break;
                }
                case "m_set": {
                    this.handleActionSetAttribute((Context)context, actionObject);
                    break;
                }
                case "m_inapp": {
                    this.handleActionOpenInApp(context, actionObject);
                    break;
                }
                case "m_remind_exact": {
                    this.handleActionRemindExact(context, actionObject);
                    break;
                }
                case "m_remind_inexact": {
                    this.handleActionRemindInExact(context, actionObject);
                    break;
                }
                default: {
                    if (this.actionHandlers != null) {
                        this.actionHandlers.onActionPerformed((Context)context, tag, actionObject);
                    } else {
                        Logger.e((String)("Not a valid action" + tag));
                    }
                    return false;
                }
            }
        }
        catch (Exception e) {
            Logger.f((String)("PushActionManager : exception occurred while performing notification action," + e.getMessage()));
        }
        return true;
    }

    private void handleActionOpenInApp(Activity context, JSONObject actionObject) throws JSONException {
        String campaignId;
        if (actionObject.has("moe_inapp_cid") && !TextUtils.isEmpty((CharSequence)(campaignId = actionObject.getString("moe_inapp_cid")))) {
            MoEDispatcher.getInstance((Context)context).checkAndShowLinkedInApp(campaignId);
        }
    }

    private void handleActionSetAttribute(Context context, JSONObject actionObject) {
        Object value = null;
        String userAttribute = null;
        String dataType = null;
        try {
            if (actionObject.has("set")) {
                userAttribute = actionObject.getString("set");
            }
            if (actionObject.has("value_type") && actionObject.has("value") && !TextUtils.isEmpty((CharSequence)userAttribute)) {
                switch (dataType = actionObject.getString("value_type")) {
                    case "int": {
                        MoEHelper.getInstance((Context)context).setUserAttribute(userAttribute, actionObject.getInt("value"));
                        break;
                    }
                    case "double": {
                        MoEHelper.getInstance((Context)context).setUserAttribute(userAttribute, actionObject.getDouble("value"));
                        break;
                    }
                    case "String": {
                        MoEHelper.getInstance((Context)context).setUserAttribute(userAttribute, actionObject.getString("value"));
                        break;
                    }
                    case "boolean": {
                        MoEHelper.getInstance((Context)context).setUserAttribute(userAttribute, actionObject.getBoolean("value"));
                        break;
                    }
                    case "long": {
                        MoEHelper.getInstance((Context)context).setUserAttribute(userAttribute, actionObject.getLong("value"));
                    }
                }
            } else if (actionObject.has("value") && !TextUtils.isEmpty((CharSequence)userAttribute)) {
                JSONObject userAttrJSON = new JSONObject();
                userAttrJSON.put(userAttribute.trim(), (Object)actionObject.getString("value"));
                MoEDispatcher.getInstance((Context)context).setCustomUserAttribute(userAttrJSON);
            }
        }
        catch (Exception e) {
            Logger.f((String)"PushActionManager : handleActionSetAttribute ", (Throwable)e);
        }
    }

    private void handleActionTrackEvent(Context context, JSONObject actionObject) {
        Logger.v((String)"PushActionManager$handleActionTrackEvent(): action_track");
        if (actionObject.has("track")) {
            String eventToTrack = null;
            String eventValue = null;
            try {
                eventToTrack = actionObject.getString("track");
                PayloadBuilder builder = new PayloadBuilder();
                if (actionObject.has("valueOf")) {
                    eventValue = actionObject.getString("valueOf");
                }
                if (!TextUtils.isEmpty(eventValue)) {
                    builder.putAttrString("valueOf", eventValue);
                }
                MoEHelper.getInstance((Context)context).trackEvent(eventToTrack, builder.build());
            }
            catch (Exception e) {
                Logger.f((String)"PushActionManger : handleActionTrackEvent()", (Throwable)e);
            }
        }
    }

    private void handleActionRemindExact(Activity context, JSONObject actionObject) throws Exception {
        Logger.v((String)"PushActionManager$handleActionRemindExact()");
        Intent intent = context.getIntent();
        if (null == intent) {
            Logger.v((String)"PushActionManager$handleActionRemindExact() Intent is null");
            return;
        }
        Bundle extras = intent.getExtras();
        if (null == extras) {
            Logger.v((String)"PushActionManager$handleActionRemindExact() Extras is null");
            return;
        }
        extras.remove("action_tag");
        extras.remove("action_payload");
        extras.putBoolean("re_notify", true);
        Intent laterIntent = new Intent((Context)context, MoEPushWorker.class);
        laterIntent.putExtras(extras);
        laterIntent.setAction("DEAL_WITH_NOTIFICATION");
        int _id = (int)System.currentTimeMillis();
        PendingIntent alarmPendingIntent = PendingIntent.getService((Context)context, (int)_id, (Intent)laterIntent, (int)0x8000000);
        int snoozeValue = this.getSnoozeVal(actionObject, "value");
        if (snoozeValue > 0) {
            Calendar c = Calendar.getInstance();
            c.add(11, snoozeValue);
            long triggerAtMillis = c.getTimeInMillis();
            AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
            alarmManager.set(0, triggerAtMillis, alarmPendingIntent);
            Logger.v((String)("PushActionManager$handleActionRemindExact(): Reminder set at :" + c.getTime()));
        }
    }

    private void handleActionRemindInExact(Activity context, JSONObject actionObject) throws Exception {
        Logger.v((String)"PushActionManager$handleActionRemindInExact() : action_remind_inexact ");
        Intent intent = context.getIntent();
        if (null == intent) {
            Logger.v((String)"PushActionManager$handleActionRemindInExact() Intent is null");
            return;
        }
        Bundle extras = intent.getExtras();
        if (null == extras) {
            Logger.v((String)"PushActionManager$handleActionRemindInExact() Extras is null");
            return;
        }
        dialogShown = true;
        extras.remove("action_tag");
        extras.remove("action_payload");
        int snoozeTime = this.getSnoozeVal(actionObject, "value_snooze");
        int hourToday = this.getSnoozeVal(actionObject, "value_today");
        int hourTomorrow = this.getSnoozeVal(actionObject, "value_tomorrow");
        hourToday = hourToday + Calendar.getInstance().get(11) < 25 ? hourToday : -1;
        extras.putInt("value_snooze", snoozeTime);
        extras.putInt("value_today", hourToday);
        extras.putInt("value_tomorrow", hourTomorrow);
        LaterDialogFragment dialogFragment = new LaterDialogFragment();
        dialogFragment.setArguments(extras);
        dialogFragment.show(((FragmentActivity)context).getSupportFragmentManager(), "laterDialog");
    }

    private int getSnoozeVal(JSONObject actionObject, String snoozeKey) throws Exception {
        return actionObject.has(snoozeKey) ? Integer.parseInt(actionObject.getString(snoozeKey).trim()) : -1;
    }

    public static boolean isDialogShown() {
        return dialogShown;
    }

    protected void handleActionNavigation(Activity context, JSONObject actionObject) throws JSONException, ClassNotFoundException {
        Uri.Builder builder;
        Logger.v((String)"PushActionManager$handleActionNavigation");
        String screenName = null;
        Uri uri = null;
        Bundle bundle = null;
        if (actionObject.has("screen")) {
            screenName = actionObject.getString("screen");
            JSONObject extras = null;
            if (actionObject.has("extras")) {
                extras = actionObject.getJSONObject("extras");
            }
            bundle = MoEHelperUtils.convertJSONObjecttoBundle(extras);
        } else if (actionObject.has("uri")) {
            Uri link = Uri.parse((String)actionObject.getString("uri"));
            builder = link.buildUpon();
            uri = builder.build();
        }
        if (!MoEPushCallBacks.getInstance().onPushNavigationAction(screenName, bundle, uri)) {
            if (!TextUtils.isEmpty((CharSequence)screenName)) {
                Intent intent = new Intent((Context)context, Class.forName(screenName));
                if (bundle != null) {
                    intent.putExtras(bundle);
                }
                if (!PushManager.getInstance().isBackStackBuilderOptedOut((Context)context)) {
                    builder = TaskStackBuilder.create((Context)context);
                    builder.addNextIntentWithParentStack(intent).startActivities();
                } else {
                    context.startActivity(intent);
                }
            } else if (uri != null) {
                Intent redirectIntent = new Intent("android.intent.action.VIEW", uri);
                context.startActivity(redirectIntent);
            }
        }
    }

    public static interface IActionHandler {
        public boolean onActionPerformed(Context var1, String var2, JSONObject var3);
    }
}

