/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.pushbase.push;

import android.R;
import android.app.AlarmManager;
import android.app.Notification;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.support.annotation.Nullable;
import android.support.v4.app.NotificationCompat;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import android.widget.RemoteViews;
import com.moe.pushlibrary.MoEHelper;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.MoEEventManager;
import com.moengage.core.MoEUtils;
import com.moengage.pushbase.R;
import com.moengage.pushbase.activities.SnoozeTracker;
import com.moengage.pushbase.push.MoEPushWorker;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class MoEngageNotificationUtils {
    private static final String EXTRA_KEY_NOTIFICATIONID = "MOE_NOTIFICATION_ID";
    private static final String NOTIFICATION_TONE_DISABLED = "gcm_sound_disabled";
    private static final String NOTIFICATION_TONE = "gcm_tone";
    private static final String NOTIFICATION_TONE_SYSTEM = "gcm_tone_system";
    private static final String NOTIFICATION_DISP_TYPE_SINGLE = "gcm_show_single";
    private static final String NOTIFICATION_DISP_TYPE_MULTIPLE = "gcm_show_multi";
    private static final String NOTIFICATION_PUBLIC_VERSION = "gcm_pub_v";
    private static final String NOTIFICATION_CATEGORY = "gcm_category";
    private static final String NOTIFICATION_TICKER = "gcm_ticker";
    private static final String NOTIFICATION_LED_LIGHT_COLOR = "gcm_led";
    private static final String NOTIFICATION_SUB_TEXT = "gcm_subtext";
    private static final String NOTIFICATION_DISABLE_AUTO_CANCEL = "gcm_dnc";
    private static final String NOTIFICATION_DISABLE_VIBRATION = "gcm_no_vib";
    private static final String NOTIFICATION_PRIVACY = "gcm_privacy";
    private static final String NOTIFICATION_PRIORITY = "gcm_priority";
    private static final String NOTIFICATION_LARGE_ICON = "gcm_l_ic";
    private static final String NOTIFICATION_ACTION_BUTTONS = "gcm_actions";
    private static final String NOTIFICATION_TITLE = "gcm_title";
    private static final String NOTIFICATION_CONTENT = "gcm_alert";
    private static final String NOTIFICATION_ACTION = "gcm_action_title";
    private static final String NOTIFICATION_ACTIVITY_NAME = "gcm_activityName";
    private static final String NOTIFICATION_SILENT_NOTIFICATION = "gcm_silentNotification";
    private static final String NOTIFICATION_CONTENT_TYPE = "gcm_notificationType";
    private static final String NOTIFICATION_WEB_URL = "gcm_webUrl";
    private static final String NOTIFICATION_CAMPAIGN_ID = "gcm_campaign_id";
    private static final String NOTIFICATION_GEO_ID = "gcm_geo_id";
    private static final String NOTIFICATION_COUPON_CODE = "gcm_coupon_code";
    private static final String NOTIFICATION_IMAGE_URL = "gcm_image_url";
    private static final String NOTIFICATION_MSG_TAG = "gcm_msg_tag";
    private static final String GCM_ACTION_NAME = "name";
    private static final String GCM_ACTION_ICON = "ic";
    private static final String GCM_ACTION_DEEPLINK = "dl";
    private static final String GCM_ACTION_CLASSNAME = "cls";
    private static final String GCM_ACTION_EXTRAS = "ex";
    private static final String GCM_ACTION_LINK = "lk";
    private static String MSG_TTL = "gcm_msgttl";
    private static String MSG_AUTODISMISS = "gcm_dismiss";
    private static final String DIRECT_PUSH_INBOX = "gcm_push2inbox";
    private static final long DEFAULT_TTL = 7776000000L;
    private static final String RECIPIENT_USER_ID = "unique_id";
    private static final int FIXED_HEIGHT_DP = 192;
    private static final int REQ_CLEARED = 501;
    private static String GCM_MESSAGE_IGNORE = "gcm_message_ignore";
    private static final String GCM_CAROUSEL_NOTIFICATION = "gcm_carousel";
    private static final String NOTIFICATION_CUSTOM_IMAGES = "gcm_images";
    private static final String SEPARATOR = "%26";
    private static final String ASSIGN = "%3D";
    private static final String KEY_MOENGAGE_EXTRAS = "moextras";

    private MoEngageNotificationUtils() {
    }

    public static boolean isFromMoEngagePlatform(Intent intent) {
        Bundle extras = intent.getExtras();
        return MoEngageNotificationUtils.isFromMoEngagePlatform(extras);
    }

    public static boolean isFromMoEngagePlatform(Bundle extras) {
        try {
            if (null == extras) {
                Logger.e((String)"MoEngageNotificationUtils:No Intent extra available");
            } else if (extras.containsKey("push_from") && extras.getString("push_from").equals("moengage")) {
                return true;
            }
        }
        catch (Exception e) {
            Logger.f((String)"MoEngageNotificationUtils: isFromMoEngagePlatform ", (Throwable)e);
        }
        return false;
    }

    public static boolean isSilentPush(Bundle extras) {
        String notificationType = extras.getString(NOTIFICATION_CONTENT_TYPE);
        return !TextUtils.isEmpty((CharSequence)notificationType) && notificationType.equals(NOTIFICATION_SILENT_NOTIFICATION);
    }

    public static boolean isPushToInbox(Bundle extras) {
        return extras.containsKey(DIRECT_PUSH_INBOX);
    }

    public static void stripMoEngageExtras(Bundle extras) {
        extras.remove("MOE_MSG_RECEIVED_TIME");
        extras.remove("NOTIFICATION_RECEIVED_MOE");
        extras.remove(NOTIFICATION_CAMPAIGN_ID);
        extras.remove("push_from");
        extras.remove(NOTIFICATION_ACTIVITY_NAME);
        extras.remove(NOTIFICATION_GEO_ID);
        extras.remove("gcm_uniqueId");
    }

    public static boolean isMoEngageCampaign(Bundle extras) {
        if (extras == null || !extras.containsKey(NOTIFICATION_CAMPAIGN_ID)) {
            Logger.e((String)"MoEngageNotificationUtils:isAMoEngageCampaign--> no campaign ID so skipping to show notification");
            return false;
        }
        return true;
    }

    public static void setNotificationId(Intent finalIntent, int notificationId) {
        finalIntent.putExtra(EXTRA_KEY_NOTIFICATIONID, notificationId);
    }

    public static int getNotificationIdIfAny(Bundle extras) {
        if (extras.containsKey(EXTRA_KEY_NOTIFICATIONID)) {
            return extras.getInt(EXTRA_KEY_NOTIFICATIONID);
        }
        return -1;
    }

    public static String getCampaignIdIfAny(Bundle extras) {
        if (extras.containsKey(NOTIFICATION_CAMPAIGN_ID)) {
            return extras.getString(NOTIFICATION_CAMPAIGN_ID);
        }
        return null;
    }

    public static String getNotificationTypeIfAny(Bundle extras) {
        return extras.getString(NOTIFICATION_CONTENT_TYPE);
    }

    public static String getNotificationTitleIfAny(Bundle extras) {
        return extras.getString(NOTIFICATION_TITLE);
    }

    public static void setTitleIfPresent(Bundle extras, NotificationCompat.Builder builder) {
        builder.setContentTitle((CharSequence)MoEngageNotificationUtils.getNotificationTitleIfAny(extras));
    }

    public static String getNotificationContentTextIfAny(Bundle extras) {
        return extras.getString(NOTIFICATION_CONTENT);
    }

    public static void setContentIfPresent(Bundle extras, NotificationCompat.Builder builder) {
        builder.setContentText((CharSequence)MoEngageNotificationUtils.getNotificationContentTextIfAny(extras));
    }

    public static String getNotificationSubTextIfAny(Bundle extras) {
        return extras.getString(NOTIFICATION_SUB_TEXT);
    }

    public static void setSubTextIfAny(Bundle extras, NotificationCompat.Builder builder) {
        builder.setSubText((CharSequence)MoEngageNotificationUtils.getNotificationSubTextIfAny(extras));
    }

    public static void setNotificationPriorityIfPresentAndSupported(Bundle extras, NotificationCompat.Builder builder) {
        if (Build.VERSION.SDK_INT >= 16) {
            try {
                if (extras.containsKey(NOTIFICATION_PRIORITY)) {
                    int notificationPriority = Integer.parseInt(extras.getString(NOTIFICATION_PRIORITY));
                    if (notificationPriority >= -2 && notificationPriority <= 2) {
                        builder.setPriority(notificationPriority);
                    } else {
                        builder.setPriority(0);
                    }
                }
            }
            catch (Exception e) {
                Logger.f((String)"MoEngageNotificationUtils: setNotificationPriorityIfPresentAndSupported", (Throwable)e);
            }
        }
    }

    public static void setSmallIcon(Context context, NotificationCompat.Builder notificationBuilder, ConfigurationProvider configProvider) {
        try {
            int smallNotificationIconResourceId = 0;
            smallNotificationIconResourceId = Build.VERSION.SDK_INT < 21 ? configProvider.getNotificationLargeIconIfAny() : configProvider.getNotificationSmallIcon();
            if (smallNotificationIconResourceId != -1) {
                notificationBuilder.setSmallIcon(smallNotificationIconResourceId);
            }
        }
        catch (Exception e) {
            Logger.f((String)"MoEngageNotificationUtils: setSmallIcon", (Throwable)e);
        }
    }

    public static void setColorOrLargeIconIfPresentAndSupported(Context context, Bundle extras, NotificationCompat.Builder builder, ConfigurationProvider provider) {
        if (Build.VERSION.SDK_INT >= 21) {
            try {
                int largeIcon = provider.getNotificationLargeIconIfAny();
                Bitmap bmpLargeIcon = null;
                int color = provider.getNotificationColor();
                if (color != -1) {
                    builder.setColor(context.getResources().getColor(color));
                }
                if (provider.isNotificationLargeIconOptedOut()) {
                    return;
                }
                if (extras.containsKey(NOTIFICATION_LARGE_ICON)) {
                    String nLrgIcon = extras.getString(NOTIFICATION_LARGE_ICON);
                    if (TextUtils.isEmpty((CharSequence)nLrgIcon) && largeIcon != -1) {
                        bmpLargeIcon = BitmapFactory.decodeResource((Resources)context.getResources(), (int)largeIcon, null);
                    } else {
                        bmpLargeIcon = MoEHelperUtils.downloadImageBitmap((String)nLrgIcon);
                        if (bmpLargeIcon == null && largeIcon != -1) {
                            bmpLargeIcon = BitmapFactory.decodeResource((Resources)context.getResources(), (int)largeIcon, null);
                        }
                    }
                } else if (largeIcon != -1) {
                    bmpLargeIcon = BitmapFactory.decodeResource((Resources)context.getResources(), (int)largeIcon, null);
                }
                if (bmpLargeIcon != null) {
                    builder.setLargeIcon(bmpLargeIcon);
                }
            }
            catch (Exception e) {
                Logger.f((String)"MoEngageNotificationUtils: setColorOrLargeIconIfPresentAndSupported", (Throwable)e);
            }
        }
    }

    public static void setSoundIfPresentAndSupported(Context context, Bundle extras, NotificationCompat.Builder builder, ConfigurationProvider configProvider) {
        if (!configProvider.isNotificationSoundEnabled()) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 11) {
            try {
                boolean playSound = true;
                Uri toneUri = null;
                String notificationTone = configProvider.getNotificationToneIfAny();
                toneUri = null != notificationTone ? Uri.parse((String)("android.resource://" + context.getPackageName() + "/raw/" + notificationTone)) : Settings.System.DEFAULT_NOTIFICATION_URI;
                if (extras.containsKey(NOTIFICATION_TONE_DISABLED)) {
                    playSound = false;
                } else if (extras.containsKey(NOTIFICATION_TONE_SYSTEM)) {
                    toneUri = Settings.System.DEFAULT_NOTIFICATION_URI;
                } else if (extras.containsKey(NOTIFICATION_TONE)) {
                    notificationTone = extras.getString(NOTIFICATION_TONE);
                    if (!TextUtils.isEmpty((CharSequence)notificationTone)) {
                        toneUri = Uri.parse((String)("android.resource://" + context.getPackageName() + "/raw/" + notificationTone));
                    } else {
                        Logger.v((String)"Notification tone is not required");
                    }
                }
                if (playSound && null != toneUri) {
                    builder.setSound(toneUri);
                }
            }
            catch (Exception e) {
                Logger.f((String)"MoEngageNotificationUtils: setSoundIfPresentAndSupported", (Throwable)e);
            }
        }
    }

    public static void setVisibilityIfPresentAndSupported(Bundle extras, NotificationCompat.Builder builder) {
        if (Build.VERSION.SDK_INT >= 21) {
            try {
                if (extras.containsKey(NOTIFICATION_PRIVACY)) {
                    builder.setVisibility(Integer.parseInt(extras.getString(NOTIFICATION_PRIVACY)));
                }
            }
            catch (Exception e) {
                Logger.f((String)"MoEngageNotificationUtils: setVisibilityIfPresentAndSupported", (Throwable)e);
            }
        }
    }

    public static void setTickerTextIfPresent(Bundle extras, NotificationCompat.Builder builder) {
        if (Build.VERSION.SDK_INT >= 11) {
            try {
                if (extras.containsKey(NOTIFICATION_TICKER)) {
                    builder.setTicker(extras.getCharSequence(NOTIFICATION_TICKER));
                }
            }
            catch (Exception e) {
                Logger.f((String)"MoEngageNotificationUtils: setTickerTextIfPresent", (Throwable)e);
            }
        }
    }

    public static void setCategoryIfPresentAndSupported(Bundle extras, NotificationCompat.Builder builder) {
        if (Build.VERSION.SDK_INT >= 21) {
            try {
                if (extras.containsKey(NOTIFICATION_CATEGORY)) {
                    builder.setCategory(extras.getString(NOTIFICATION_CATEGORY));
                }
            }
            catch (Exception e) {
                Logger.f((String)"MoEngageNotificationUtils: setCategoryIfPresentAndSupported", (Throwable)e);
            }
        }
    }

    public static int getNotificationDisplayType(Bundle extras, Context context) {
        int type = ConfigurationProvider.getInstance((Context)context).getNotificationDisplayType();
        if (MoEngageNotificationUtils.isShowOnlyOneNotification(extras)) {
            type = 1;
        } else if (MoEngageNotificationUtils.isShowMultipleNotification(extras)) {
            type = 2;
        }
        return type;
    }

    public static boolean isImageNotification(Bundle extras) {
        return extras.containsKey(NOTIFICATION_IMAGE_URL);
    }

    public static Bitmap scaleBitmapToDeviceSpecs(Bitmap imageBitmap, Context context) {
        if (imageBitmap == null) {
            Logger.e((String)"MoEngageNotificationUtils: scaleBitmapToDeviceSpecs");
            return null;
        }
        if (imageBitmap.getWidth() > imageBitmap.getHeight()) {
            WindowManager windowManager = (WindowManager)context.getSystemService("window");
            DisplayMetrics displayMetrics = new DisplayMetrics();
            windowManager.getDefaultDisplay().getMetrics(displayMetrics);
            int heightPixels = MoEHelperUtils.getPxFromDp((int)displayMetrics.densityDpi, (int)192);
            int widthPixels = 2 * heightPixels;
            if (widthPixels > displayMetrics.widthPixels) {
                widthPixels = displayMetrics.widthPixels;
            }
            if (Build.MANUFACTURER.equals("OPPO")) {
                widthPixels -= MoEHelperUtils.getPxFromDp((int)displayMetrics.densityDpi, (int)16);
            }
            try {
                imageBitmap = Bitmap.createScaledBitmap((Bitmap)imageBitmap, (int)widthPixels, (int)heightPixels, (boolean)true);
            }
            catch (OutOfMemoryError e1) {
                Logger.f((String)"MoEngageNotificationUtils: scaleBitmapToDeviceSpecs", (Throwable)e1);
            }
            catch (Exception e) {
                Logger.f((String)"MoEngageNotificationUtils: scaleBitmapToDeviceSpecs", (Throwable)e);
            }
        }
        return imageBitmap;
    }

    public static boolean isAutoCancelEnabled(Bundle extras) {
        return !extras.containsKey(NOTIFICATION_DISABLE_AUTO_CANCEL);
    }

    public static String convertBundletoJSONString(Bundle newBundle) {
        Set keys = newBundle.keySet();
        JSONObject jsonObject = new JSONObject();
        for (String key : keys) {
            try {
                jsonObject.put(key, newBundle.get(key));
            }
            catch (Exception e) {
                Logger.f((String)"MoEngageNotificationUtils: convertBundletoJSONString", (Throwable)e);
            }
        }
        return jsonObject.toString();
    }

    public static String getNotificationCouponCode(Bundle extras) {
        return extras.getString(NOTIFICATION_COUPON_CODE);
    }

    public static boolean hasCouponCode(Bundle extras) {
        return extras.containsKey(NOTIFICATION_COUPON_CODE);
    }

    public static boolean isVibrationDisabled(Bundle extras) {
        return extras.containsKey(NOTIFICATION_DISABLE_VIBRATION);
    }

    public static int getNotificationLedLightColor(Bundle extras) {
        try {
            return Integer.parseInt(extras.getString(NOTIFICATION_LED_LIGHT_COLOR));
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static boolean isShowOnlyOneNotification(Bundle extras) {
        return extras.containsKey(NOTIFICATION_DISP_TYPE_SINGLE);
    }

    public static boolean isShowMultipleNotification(Bundle extras) {
        return extras.containsKey(NOTIFICATION_DISP_TYPE_MULTIPLE);
    }

    public static boolean isPublicVersionAvailable(Bundle extras) {
        return extras.containsKey(NOTIFICATION_PUBLIC_VERSION);
    }

    public static void setActionButtonIfPresentAndSupported(Context context, Bundle extras, NotificationCompat.Builder builder, Intent redirectIntent, int notificationId) {
        block12: {
            if (Build.VERSION.SDK_INT >= 16) {
                try {
                    PendingIntent finalIntent = null;
                    boolean updateExisting = MoEngageNotificationUtils.getNotificationDisplayType(extras, context) == 1;
                    JSONArray actions = MoEngageNotificationUtils.getActions(extras);
                    if (null == actions) {
                        if (extras.containsKey(NOTIFICATION_ACTION)) {
                            finalIntent = MoEngageNotificationUtils.getContentIntent(context, redirectIntent, updateExisting, notificationId);
                            builder.addAction(0, (CharSequence)extras.getString(NOTIFICATION_ACTION), finalIntent);
                        }
                        break block12;
                    }
                    int btnCount = actions.length();
                    for (int i = 0; i < btnCount; ++i) {
                        String actionIcon;
                        Intent actionIntent = null;
                        JSONObject actionObject = actions.getJSONObject(i);
                        Logger.v((String)("MoEngageNotificationUtils : action button: " + actionObject.toString()));
                        String actionTag = actionObject.getString("action_tag");
                        String actionMessage = actionObject.getString("action_title");
                        String string = actionIcon = actionObject.has("action_icon") ? actionObject.getString("action_icon") : null;
                        if (actionTag.equals("m_remind_exact") || actionTag.equals("m_remind_inexact")) {
                            actionIntent = MoEngageNotificationUtils.getIntentForSnooze(context);
                            actionIntent.putExtras(redirectIntent.getExtras());
                        } else {
                            actionIntent = redirectIntent;
                        }
                        actionIntent.putExtra("action_tag", actionTag);
                        actionIntent.putExtra("action_payload", actionObject.toString());
                        actionIntent.putExtra("action_id", actionObject.getString("action_id"));
                        int actionIntentId = notificationId + (i + 1) * 1000;
                        finalIntent = PendingIntent.getActivity((Context)context, (int)actionIntentId, (Intent)actionIntent, (int)0x8000000);
                        int imageResource = 0;
                        if (!TextUtils.isEmpty((CharSequence)actionIcon)) {
                            try {
                                imageResource = context.getResources().getIdentifier(actionIcon, "drawable", context.getPackageName());
                                if (imageResource == 0) {
                                    imageResource = R.drawable.class.getField(actionIcon).getInt(null);
                                }
                            }
                            catch (Exception e) {
                                Logger.f((String)"MoEngageNotificationUtils: setActionButtonIfPresentAndSupported", (Throwable)e);
                            }
                        }
                        if (extras.containsKey("re_notify") && actionTag.equals("m_remind_inexact")) continue;
                        builder.addAction(imageResource, (CharSequence)actionMessage, finalIntent);
                    }
                }
                catch (Exception e) {
                    Logger.f((String)"MoEngageNotificationUtils: setActionButtonIfPresentAndSupported", (Throwable)e);
                }
            }
        }
    }

    public static final PendingIntent getContentIntent(Context context, Intent finalIntent, boolean update, int notificationId) {
        return PendingIntent.getActivity((Context)context, (int)notificationId, (Intent)finalIntent, (int)0x8000000);
    }

    public static JSONArray getActions(Bundle extras) {
        String actions = extras.getString(NOTIFICATION_ACTION_BUTTONS);
        if (TextUtils.isEmpty((CharSequence)actions)) {
            return null;
        }
        try {
            return new JSONArray(actions);
        }
        catch (Exception e) {
            Logger.f((String)"MoEngageNotificationUtils: getActions", (Throwable)e);
            return null;
        }
    }

    public static String getRedirectActivityNameIfAny(Bundle extras) {
        if (extras.containsKey(NOTIFICATION_ACTIVITY_NAME)) {
            return extras.getString(NOTIFICATION_ACTIVITY_NAME);
        }
        return null;
    }

    public static String getDeeplinkURIStringIfAny(Bundle extras) {
        if (extras.containsKey(NOTIFICATION_WEB_URL)) {
            return extras.getString(NOTIFICATION_WEB_URL);
        }
        return null;
    }

    public static String getCampaignGeoIDIfAny(Bundle extras) {
        if (extras.containsKey(NOTIFICATION_GEO_ID)) {
            return extras.getString(NOTIFICATION_GEO_ID);
        }
        return null;
    }

    public static long getNotificationTTL(Bundle extras, long receivedTime) {
        if (extras.containsKey("inbox_expiry")) {
            return Long.parseLong(extras.getString("inbox_expiry")) * 1000L;
        }
        if (extras.containsKey(MSG_TTL)) {
            return MoEngageNotificationUtils.convertTimeToLong(extras.getString(MSG_TTL));
        }
        return receivedTime + 7776000000L;
    }

    public static String getMessageTagsIfAny(Bundle extras) {
        if (extras.containsKey(NOTIFICATION_MSG_TAG)) {
            return extras.getString(NOTIFICATION_MSG_TAG);
        }
        return null;
    }

    public static int getNotificationId(Context context, ConfigurationProvider provider, boolean update) {
        if (update) {
            return provider.getNotificationId();
        }
        int id2 = provider.getNotificationId();
        provider.updateNotificationId(++id2);
        return id2;
    }

    public static void setNotificationStyle(Context context, Bundle extras, NotificationCompat.Builder builder) {
        if (MoEngageNotificationUtils.isImageNotification(extras)) {
            Bitmap new_bitmap;
            String summary = MoEngageNotificationUtils.getNotificationSubTextIfAny(extras);
            if (TextUtils.isEmpty((CharSequence)summary)) {
                summary = MoEngageNotificationUtils.getNotificationContentTextIfAny(extras);
            }
            if (null == (new_bitmap = MoEHelperUtils.downloadImageBitmap((String)extras.getString(NOTIFICATION_IMAGE_URL)))) {
                builder.setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)(MoEngageNotificationUtils.getNotificationContentTextIfAny(extras) + " ")));
            } else {
                new_bitmap = MoEngageNotificationUtils.scaleBitmapToDeviceSpecs(new_bitmap, context);
                if (Build.VERSION.SDK_INT < 24) {
                    builder.setStyle((NotificationCompat.Style)new NotificationCompat.BigPictureStyle().bigPicture(new_bitmap).setSummaryText((CharSequence)summary));
                } else {
                    builder.setStyle((NotificationCompat.Style)new NotificationCompat.BigPictureStyle().bigPicture(new_bitmap).setSummaryText((CharSequence)MoEngageNotificationUtils.getNotificationContentTextIfAny(extras)));
                }
            }
        } else {
            builder.setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)(MoEngageNotificationUtils.getNotificationContentTextIfAny(extras) + " ")));
        }
    }

    public static String getRecipientUserId(Bundle extras) {
        return extras.getString(RECIPIENT_USER_ID);
    }

    public static void setNotificationAutoDismissIfAny(Context context, int notificationId, Bundle extras) {
        long notificationExpiryTime = MoEngageNotificationUtils.getNotificationExpiryTime(extras);
        if (notificationExpiryTime != -1L) {
            Logger.v((String)("MoEngageNotificationUtils: setNotificationAutoDismissIfAny: setting an auto dismiss after: " + notificationExpiryTime));
            Intent finalIntent = new Intent(context, MoEPushWorker.class);
            finalIntent.putExtra("DEAL_WITH_NOTI_AUTODISMISS", notificationId);
            finalIntent.setAction("DEAL_WITH_NOTI_AUTODISMISS");
            PendingIntent intent = PendingIntent.getService((Context)context, (int)notificationId, (Intent)finalIntent, (int)0x8000000);
            AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
            alarmManager.set(0, notificationExpiryTime, intent);
        }
    }

    public static void setNotificationClearedCallback(Context context, NotificationCompat.Builder builder, int notificationId, Bundle extras) {
        Intent finalIntent = new Intent(context, MoEPushWorker.class);
        finalIntent.putExtras(extras);
        finalIntent.setAction("DEAL_WITH_NOTIFICATION_CLEARED");
        PendingIntent intent = PendingIntent.getService((Context)context, (int)(notificationId | 0x1F5), (Intent)finalIntent, (int)0x8000000);
        builder.setDeleteIntent(intent);
    }

    public static Bundle getMoEngageExtras(Bundle gcmIntentExtra) {
        Bundle moengageExtras = new Bundle();
        moengageExtras.putString("NOTIFICATION_RECEIVED_MOE", "true");
        moengageExtras.putString(NOTIFICATION_CAMPAIGN_ID, MoEngageNotificationUtils.getCampaignIdIfAny(gcmIntentExtra));
        moengageExtras.putString("push_from", "moengage");
        moengageExtras.putString(NOTIFICATION_ACTIVITY_NAME, gcmIntentExtra.getString(NOTIFICATION_ACTIVITY_NAME));
        moengageExtras.putString(NOTIFICATION_GEO_ID, gcmIntentExtra.getString(NOTIFICATION_GEO_ID));
        moengageExtras.putString("gcm_uniqueId", gcmIntentExtra.getString("gcm_uniqueId"));
        return moengageExtras;
    }

    public static void setMoEngageExtrastoUri(Bundle extras, Uri.Builder uriBuilder) {
        try {
            if (null == extras || extras.isEmpty()) {
                return;
            }
            StringBuilder builder = new StringBuilder();
            Set keySet = extras.keySet();
            int length = keySet.size();
            for (String key : keySet) {
                --length;
                if (TextUtils.isEmpty((CharSequence)key) || NOTIFICATION_WEB_URL.equals(key)) continue;
                builder.append(key);
                builder.append(ASSIGN);
                builder.append(extras.get(key));
                if (length <= 0) continue;
                builder.append(SEPARATOR);
            }
            uriBuilder.appendQueryParameter(KEY_MOENGAGE_EXTRAS, builder.toString());
        }
        catch (Exception e) {
            Logger.f((String)"MoEHelperUtils: getMoEngageExtrasAsUriParam :", (Throwable)e);
        }
    }

    public static void setMoEngageExtrasToBundleIfAny(Intent intent) {
        try {
            String extras;
            if (null == intent) {
                return;
            }
            Uri data = intent.getData();
            if (null == data) {
                return;
            }
            Bundle bundle = intent.getExtras();
            if (null == bundle) {
                bundle = new Bundle();
            }
            if (TextUtils.isEmpty((CharSequence)(extras = data.getQueryParameter(KEY_MOENGAGE_EXTRAS)))) {
                return;
            }
            if (extras.contains(SEPARATOR)) {
                String[] keySet;
                for (String kv : keySet = extras.split(SEPARATOR)) {
                    String[] kvSplit = MoEngageNotificationUtils.splitKVPairs(kv);
                    if (kvSplit.length != 2) continue;
                    bundle.putString(kvSplit[0], kvSplit[1]);
                }
            } else {
                String[] kvSplit = MoEngageNotificationUtils.splitKVPairs(extras);
                bundle.putString(kvSplit[0], kvSplit[1]);
            }
            intent.putExtras(bundle);
        }
        catch (Exception e) {
            Logger.f((String)"MoEHelperUtils: getMoEngageExtrasAsUriParam :", (Throwable)e);
        }
    }

    private static String[] splitKVPairs(String kv) {
        return kv.split(ASSIGN);
    }

    public static boolean hasNotificationExpired(Bundle extras) {
        boolean result;
        long notificationEndTime = MoEngageNotificationUtils.getNotificationExpiryTime(extras);
        if (notificationEndTime == -1L) {
            Logger.v((String)"MoEngageNotificationUtils#hasNotificationExpired : Notification does not have an expiry time");
            return false;
        }
        long currentSystemTime = System.currentTimeMillis();
        boolean bl = result = currentSystemTime > notificationEndTime;
        if (result) {
            Logger.v((String)"MoEngageNotificationUtils#hasNotificationExpired : received notification has expired");
            extras.putBoolean("gcm_campaign_expired", true);
        } else {
            Logger.v((String)"MoEngageNotificationUtils#hasNotificationExpired : received notification has not expired");
        }
        return result;
    }

    public static long getNotificationExpiryTime(Bundle extras) {
        String notificationDismissTime = extras.containsKey(MSG_AUTODISMISS) ? extras.getString(MSG_AUTODISMISS) : null;
        return MoEngageNotificationUtils.convertTimeToLong(notificationDismissTime);
    }

    private static long convertTimeToLong(String time) {
        try {
            if (!TextUtils.isEmpty((CharSequence)time)) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                dateFormat.setTimeZone(TimeZone.getDefault());
                Date date = dateFormat.parse(time);
                return date.getTime();
            }
        }
        catch (ParseException e) {
            Logger.f((String)("MoEngageNotificationUtils$hasNotificationExpired : exception while parsing date " + e.getMessage()));
        }
        catch (Exception e) {
            Logger.f((String)("MoEngageNotificationUtils$hasNotificationExpired : exception while parsing date " + e.getMessage()));
        }
        return -1L;
    }

    public static boolean isSkipNotificationCenter(Bundle extras) {
        String trueValue = "true";
        if (extras.containsKey(GCM_MESSAGE_IGNORE)) {
            return trueValue.equalsIgnoreCase(extras.getString(GCM_MESSAGE_IGNORE).trim());
        }
        return false;
    }

    public static boolean isCarouselNotification(Bundle extras) {
        return extras.containsKey(GCM_CAROUSEL_NOTIFICATION);
    }

    public static String getCarouselTitle(JSONObject carouselObject, Bundle extras) {
        return MoEngageNotificationUtils.getVal(carouselObject, extras, NOTIFICATION_TITLE);
    }

    public static String getCarouselText(JSONObject carouselObject, Bundle extras) {
        return MoEngageNotificationUtils.getVal(carouselObject, extras, NOTIFICATION_CONTENT);
    }

    public static String getCarouselSubText(JSONObject carouselObject, Bundle extras) {
        return MoEngageNotificationUtils.getVal(carouselObject, extras, NOTIFICATION_SUB_TEXT);
    }

    private static String getVal(JSONObject jsonObject, Bundle extras, String key) {
        try {
            return jsonObject.has(key) ? jsonObject.getString(key) : extras.getString(key);
        }
        catch (Exception e) {
            Logger.f((String)("MoEngageNotificationUtils : getVal : Exception Occurred" + e));
            return extras.getString(key);
        }
    }

    public static int getCarouselSmallNotificationIcon(Context context) {
        try {
            return ConfigurationProvider.getInstance((Context)context).getNotificationSmallIcon();
        }
        catch (Exception e) {
            Logger.f((String)"MoEngageNotificationUtils$getCarouselSmallNotificationIcon", (Throwable)e);
            return 0;
        }
    }

    public static int getCarouselLargeNotificationIcon(Context context) {
        try {
            return ConfigurationProvider.getInstance((Context)context).getNotificationLargeIconIfAny();
        }
        catch (Exception e) {
            Logger.f((String)"MoEngageNotificationUtils$getCarouselLargeNotificationIcon", (Throwable)e);
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveToInternalStorage(Context context, String fileName, Bitmap bitmapImage) {
        if (context == null || fileName == null || bitmapImage == null) {
            Logger.v((String)"MoEngageNotificationUtils$saveToInternalStorage : context/fileName/bitmapImage is null");
        }
        FileOutputStream fos = null;
        try {
            fos = context.openFileOutput(fileName, 0);
            bitmapImage.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fos);
        }
        catch (Exception e) {
            Logger.f((String)"MoEngageNotificationUtils$saveToInternalStorage: Exception occurred ", (Throwable)e);
        }
        finally {
            try {
                fos.close();
            }
            catch (IOException e) {
                Logger.f((String)"MoEngageNotificationUtils$saveToInternalStorage: Exception occurred ", (Throwable)e);
            }
            catch (Exception e) {
                Logger.f((String)"MoEngageNotificationUtils$saveToInternalStorage: Exception occurred ", (Throwable)e);
            }
        }
    }

    public static Bitmap loadImageFromStorage(Context context, String fileName) {
        if (context == null || fileName == null) {
            Logger.v((String)"MoEngageNotificationUtils$loadImageFromStorage : context/fileName is null");
            return null;
        }
        try {
            File file = context.getFileStreamPath(fileName);
            if (file.exists()) {
                FileInputStream inputStream = context.openFileInput(fileName);
                Bitmap b = BitmapFactory.decodeStream((InputStream)inputStream);
                return b;
            }
        }
        catch (FileNotFoundException e) {
            Logger.f((String)"MoEngageNotificationUtils$loadImageFromStorage: Exception occurred ", (Throwable)e);
        }
        catch (Exception e) {
            Logger.f((String)"MoEngageNotificationUtils$loadImageFromStorage: Exception occurred ", (Throwable)e);
        }
        return null;
    }

    public static JSONArray getImagesArray(JSONObject carouselObject) {
        try {
            return carouselObject.getJSONArray(NOTIFICATION_CUSTOM_IMAGES);
        }
        catch (Exception e) {
            Logger.f((String)"MoEngageNotificationUtils$getImagesArray : Exception Occurred", (Throwable)e);
            return null;
        }
    }

    public static void fetchAndSaveImages(Context context, JSONArray images, String campaignID) {
        try {
            if (null != images && context != null) {
                int imgCount = images.length();
                for (int i = 0; i < imgCount; ++i) {
                    JSONObject imageObject = images.getJSONObject(i);
                    Logger.v((String)("MoEngageNotificationUtils$fetchAndSaveImages : carousel images: " + imageObject.toString()));
                    String fileName = campaignID + imageObject.getString("id");
                    String url = imageObject.getString("url");
                    Bitmap bmp = MoEHelperUtils.downloadImageBitmap((String)url);
                    if (bmp != null) {
                        bmp = MoEngageNotificationUtils.scaleBitmapToDeviceSpecs(bmp, context);
                        Logger.v((String)("MoEngageNotificationUtils$fetchAndSaveImages : save bitmap for " + fileName + " and url: " + url));
                        MoEngageNotificationUtils.saveToInternalStorage(context, fileName, bmp);
                        continue;
                    }
                    Logger.v((String)("MoEngageNotificationUtils$fetchAndSaveImages : Failed to download image for " + url));
                }
            }
        }
        catch (Exception e) {
            Logger.f((String)"MoEngageNotificationUtils$fetchAndSaveImages : Exception Occurred ", (Throwable)e);
        }
    }

    public static PendingIntent getImagePendingIntent(Context context, Intent actionIntent, int idx, JSONArray imagesArray) {
        try {
            JSONObject imageObject = imagesArray.getJSONObject(idx);
            actionIntent.putExtra("action_tag", "m_nav");
            actionIntent.putExtra("id", imageObject.getString("id"));
            actionIntent.putExtra("action_payload", imageObject.toString());
            return PendingIntent.getActivity((Context)context, (int)idx, (Intent)actionIntent, (int)0x8000000);
        }
        catch (Exception e) {
            Logger.f((String)"MoEngageNotificationUtils$getImagePendingIntent : Exception Occurred ", (Throwable)e);
            return null;
        }
    }

    public static int getNextImageIndex(Bundle extras) {
        try {
            int currImgIndex;
            JSONArray imagesArray = MoEngageNotificationUtils.getImagesArray(MoEngageNotificationUtils.getCarouselObject(extras));
            int n = currImgIndex = extras.containsKey("img_idx") ? extras.getInt("img_idx") : 0;
            if (extras.containsKey("m_next")) {
                int prevImgIndex;
                if (extras.getBoolean("m_next")) {
                    int nextImgIndex;
                    if ((nextImgIndex = ++currImgIndex) == imagesArray.length()) {
                        nextImgIndex = 0;
                    }
                    return nextImgIndex;
                }
                if ((prevImgIndex = --currImgIndex) == -1) {
                    prevImgIndex = imagesArray.length() - 1;
                }
                return prevImgIndex;
            }
        }
        catch (Exception e) {
            Logger.f((String)("MoEngageNotificationUtils$getNextImageFileName : Exception Occured" + e));
        }
        return 0;
    }

    @Nullable
    public static JSONObject getCarouselObject(Bundle extras) {
        String carousel = extras.getString(GCM_CAROUSEL_NOTIFICATION);
        if (TextUtils.isEmpty((CharSequence)carousel)) {
            return null;
        }
        try {
            return new JSONObject(carousel);
        }
        catch (Exception e) {
            Logger.f((String)"MoEngageNotificationUtils$getCarouselObject", (Throwable)e);
            return null;
        }
    }

    public static PendingIntent getNavPendingIntent(Context context, Intent actionIntent, String actionTag, int requestCode, int idx) {
        actionIntent.putExtra("action_tag", actionTag);
        actionIntent.putExtra(actionTag, true);
        actionIntent.putExtra("img_idx", idx);
        return PendingIntent.getService((Context)context, (int)requestCode, (Intent)actionIntent, (int)0x8000000);
    }

    public static void deleteImagesFromInternal(Context context, String campaignId) {
        if (context == null) {
            Logger.v((String)"MoEngageNotificationUtils$deleteImagesFromInternal context is null");
            return;
        }
        try {
            String[] image_files;
            for (String fileName : image_files = context.fileList()) {
                if (!fileName.contains(campaignId)) continue;
                context.deleteFile(fileName);
            }
        }
        catch (Exception e) {
            Logger.f((String)("MoEngageNotificationUtils$deleteImagesFromInternal Exception ocurred" + e));
        }
    }

    public static boolean isReNotification(Bundle extras) {
        return extras.containsKey("re_notify");
    }

    public static void addCarouselActionButton(Context context, RemoteViews rv, Bundle extras, Intent redirectIntent, int notificationId) {
        block10: {
            try {
                JSONArray actions = MoEngageNotificationUtils.getActions(extras);
                if (actions == null) break block10;
                PendingIntent finalIntent = null;
                int maxBtnCount = actions.length() <= 3 ? actions.length() : 3;
                for (int i = 0; i < maxBtnCount; ++i) {
                    String actionIcon;
                    Intent actionIntent = null;
                    JSONObject actionObject = actions.getJSONObject(i);
                    Logger.v((String)("MoEngageNotificationUtils$addCarouselActionButton: " + actionObject.toString()));
                    String actionTag = actionObject.getString("action_tag");
                    String actionMessage = actionObject.getString("action_title");
                    String string = actionIcon = actionObject.has("action_icon") ? actionObject.getString("action_icon") : null;
                    if (actionTag.equals("m_remind_exact") || actionTag.equals("m_remind_inexact")) {
                        actionIntent = MoEngageNotificationUtils.getIntentForSnooze(context);
                        actionIntent.putExtras(redirectIntent.getExtras());
                    } else {
                        actionIntent = redirectIntent;
                    }
                    actionIntent.putExtra("action_tag", actionTag);
                    actionIntent.putExtra("action_payload", actionObject.toString());
                    actionIntent.putExtra("action_id", actionObject.getString("action_id"));
                    finalIntent = PendingIntent.getActivity((Context)context, (int)(notificationId * (i + 100)), (Intent)actionIntent, (int)0x8000000);
                    int buttonId = MoEngageNotificationUtils.getCarouselActionButtonId(i);
                    if (buttonId == -1) {
                        return;
                    }
                    int imageResource = 0;
                    if (!TextUtils.isEmpty((CharSequence)actionIcon)) {
                        try {
                            imageResource = context.getResources().getIdentifier(actionIcon, "drawable", context.getPackageName());
                            if (imageResource == 0) {
                                imageResource = R.drawable.class.getField(actionIcon).getInt(null);
                            }
                        }
                        catch (Exception e) {
                            Logger.d((String)"MoEngageNotificationUtils$addCarouselActionButton", (Throwable)e);
                        }
                    }
                    rv.setTextViewText(buttonId, (CharSequence)actionMessage);
                    rv.setOnClickPendingIntent(buttonId, finalIntent);
                    rv.setViewVisibility(buttonId, 0);
                    rv.setTextViewCompoundDrawablesRelative(buttonId, imageResource, 0, 0, 0);
                }
            }
            catch (Exception e) {
                Logger.f((String)"MoEngageNotificationUtils$addCarouselActionButton : Exception", (Throwable)e);
            }
        }
    }

    private static int getCarouselActionButtonId(int id2) {
        int viewId = -1;
        switch (id2) {
            case 0: {
                viewId = R.id.action1;
                break;
            }
            case 1: {
                viewId = R.id.action2;
                break;
            }
            case 2: {
                viewId = R.id.action3;
                break;
            }
            default: {
                Logger.e((String)("MoEngageNotificationUtils$getCarouselActionButtionId Invalid Id " + id2));
                viewId = -1;
            }
        }
        return viewId;
    }

    public static int calculateTopPadding(Context context, boolean hasThreeLines) {
        return context.getResources().getDimensionPixelSize(hasThreeLines ? R.dimen.notification_top_pad_narrow : R.dimen.notification_top_pad);
    }

    public static String getTime() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("kk:mm");
        return sdf.format(calendar.getTime());
    }

    public static void disableSoundAndVibration(Notification notification) {
        notification.sound = null;
        notification.vibrate = null;
    }

    public static int getViewFlipperImageId(int id2, String direction) {
        int viewId = -1;
        switch (direction) {
            case "left_to_right": {
                viewId = MoEngageNotificationUtils.getViewIdForLeftToRight(id2);
                break;
            }
            case "right_to_left": {
                viewId = MoEngageNotificationUtils.getViewIdForRightToLeft(id2);
                break;
            }
            default: {
                Logger.e((String)("MoEngageNotificationUtils$getViewFlipperImageId Invalid Id " + id2));
                viewId = -1;
            }
        }
        return viewId;
    }

    private static int getViewIdForLeftToRight(int id2) {
        int viewId = -1;
        switch (id2) {
            case 0: {
                viewId = R.id.flip_picture1_lr;
                break;
            }
            case 1: {
                viewId = R.id.flip_picture2_lr;
                break;
            }
            case 2: {
                viewId = R.id.flip_picture3_lr;
                break;
            }
            default: {
                Logger.e((String)("MoEngageNotificationUtils$getViewIdForLeftToRight Invalid Id " + id2));
                viewId = -1;
            }
        }
        return viewId;
    }

    private static int getViewIdForRightToLeft(int id2) {
        int viewId = -1;
        switch (id2) {
            case 0: {
                viewId = R.id.flip_picture1_rl;
                break;
            }
            case 1: {
                viewId = R.id.flip_picture2_rl;
                break;
            }
            case 2: {
                viewId = R.id.flip_picture3_rl;
                break;
            }
            default: {
                Logger.e((String)("MoEngageNotificationUtils$getViewIdForRightToLeft Invalid Id " + id2));
                viewId = -1;
            }
        }
        return viewId;
    }

    public static final Intent getIntentForSnooze(Context context) {
        Intent snoozeTrackerIntent = new Intent(context, SnoozeTracker.class);
        snoozeTrackerIntent.setFlags(0x10008000);
        return snoozeTrackerIntent;
    }

    public static boolean isFromMoEngagePlatform(Map<String, String> extras) {
        try {
            if (null == extras) {
                Logger.e((String)"MoEngageNotificationUtils:No Intent extra available");
            } else if (extras.containsKey("push_from")) {
                String confirmationValue = extras.get("push_from");
                return confirmationValue.equals("moengage");
            }
        }
        catch (Exception e) {
            Logger.f((String)"MoEngageNotificationUtils: isFromMoEngagePlatform ", (Throwable)e);
        }
        return false;
    }

    public static boolean isFromMoEngagePlatform(String payload) {
        try {
            JSONObject jsonPayload = new JSONObject(payload);
            Bundle bundlePayload = MoEUtils.jsonToBundle((JSONObject)jsonPayload);
            if (bundlePayload != null) {
                return MoEngageNotificationUtils.isFromMoEngagePlatform(bundlePayload);
            }
        }
        catch (Exception e) {
            Logger.f((String)"MoEngageNotificationUtils: isFromMoEngagePlatform ", (Throwable)e);
        }
        return false;
    }

    public static final void logNotificationImpression(Context context, Bundle extras) {
        try {
            JSONObject campaignAttributes;
            String uniqueId;
            String geoId;
            if (!MoEngageNotificationUtils.isFromMoEngagePlatform(extras)) {
                return;
            }
            if (!extras.containsKey(NOTIFICATION_CAMPAIGN_ID)) {
                return;
            }
            JSONObject newJson = new JSONObject();
            String campaignId = extras.getString(NOTIFICATION_CAMPAIGN_ID);
            if (campaignId != null && campaignId.contains("DTSDK")) {
                campaignId = campaignId.substring(0, campaignId.indexOf("DTSDK"));
                extras.putString(NOTIFICATION_CAMPAIGN_ID, campaignId);
            }
            newJson.put(NOTIFICATION_CAMPAIGN_ID, (Object)extras.getString(NOTIFICATION_CAMPAIGN_ID));
            if (extras.containsKey(NOTIFICATION_GEO_ID) && !TextUtils.isEmpty((CharSequence)(geoId = extras.getString(NOTIFICATION_GEO_ID)))) {
                newJson.put(NOTIFICATION_GEO_ID, (Object)geoId);
            }
            if (extras.containsKey("gcm_uniqueId") && !TextUtils.isEmpty((CharSequence)(uniqueId = extras.getString("gcm_uniqueId")))) {
                newJson.put("gcm_uniqueId", (Object)uniqueId);
            }
            if (extras.containsKey("gcm_campaign_expired")) {
                newJson.put("gcm_campaign_expired", true);
            }
            if (extras.containsKey("received_from")) {
                newJson.put("source", (Object)extras.getString("received_from"));
            }
            if (extras.containsKey("from_appOpen")) {
                newJson.put("from_appOpen", extras.getBoolean("from_appOpen"));
            }
            if (extras.containsKey("push_server")) {
                newJson.put("push_server", (Object)extras.getString("push_server"));
            }
            if (extras.containsKey("moe_cid_attr") && (campaignAttributes = new JSONObject(extras.getString("moe_cid_attr"))) != null) {
                Iterator keys = campaignAttributes.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    String value = campaignAttributes.getString(key);
                    newJson.put(key, (Object)value);
                }
            }
            if (extras.containsKey("shownOffline")) {
                newJson.put("shownOffline", true);
                extras.remove("shownOffline");
            }
            MoEEventManager.getInstance((Context)context).trackEvent("NOTIFICATION_RECEIVED_MOE", newJson);
        }
        catch (Exception e) {
            Logger.f((String)"PushMessageListener:trackNotification", (Throwable)e);
        }
    }

    public static final void logNotificationClick(Context context, Intent intent) {
        try {
            if (null == intent) {
                return;
            }
            Bundle extras = intent.getExtras();
            if (extras == null) {
                return;
            }
            if (!MoEngageNotificationUtils.isFromMoEngagePlatform(extras)) {
                return;
            }
            boolean fromInbox = MoEHelperUtils.isFromInbox((Bundle)extras);
            if (extras.containsKey("NOTIFICATION_RECEIVED_MOE") && !fromInbox) {
                String geoId = null;
                String uniqueId = null;
                if (extras.containsKey(NOTIFICATION_GEO_ID)) {
                    geoId = extras.getString(NOTIFICATION_GEO_ID);
                    uniqueId = extras.getString("gcm_uniqueId");
                }
                try {
                    JSONObject newJSON = new JSONObject();
                    String campaignId = extras.getString(NOTIFICATION_CAMPAIGN_ID);
                    if (campaignId != null && campaignId.contains("DTSDK")) {
                        campaignId = campaignId.substring(0, campaignId.indexOf("DTSDK"));
                        extras.putString(NOTIFICATION_CAMPAIGN_ID, campaignId);
                    }
                    newJSON.put(NOTIFICATION_CAMPAIGN_ID, (Object)campaignId);
                    if (geoId != null) {
                        newJSON.put(NOTIFICATION_GEO_ID, (Object)geoId);
                    }
                    if (uniqueId != null) {
                        newJSON.put("gcm_uniqueId", (Object)uniqueId);
                    }
                    if (extras.containsKey("action_id")) {
                        newJSON.put("gcm_action_id", (Object)extras.getString("action_id"));
                    }
                    if (extras.containsKey("received_from")) {
                        newJSON.put("source", (Object)extras.getString("received_from"));
                        extras.remove("received_from");
                    }
                    if (extras.containsKey("from_appOpen")) {
                        newJSON.put("from_appOpen", extras.getBoolean("from_appOpen"));
                        extras.remove("from_appOpen");
                    }
                    if (extras.containsKey("shownOffline")) {
                        newJSON.put("shownOffline", true);
                        extras.remove("shownOffline");
                    }
                    if (extras.containsKey("push_server")) {
                        newJSON.put("push_server", (Object)extras.getString("push_server"));
                    }
                    if (extras.containsKey("moe_cid_attr")) {
                        JSONObject campaignAttributes = new JSONObject(extras.getString("moe_cid_attr"));
                        if (campaignAttributes != null) {
                            Iterator keys = campaignAttributes.keys();
                            while (keys.hasNext()) {
                                String key = (String)keys.next();
                                String value = campaignAttributes.getString(key);
                                newJSON.put(key, (Object)value);
                            }
                        }
                        intent.removeExtra("moe_cid_attr");
                    }
                    MoEEventManager.getInstance((Context)context).trackEvent("NOTIFICATION_CLICKED_MOE", newJSON);
                    if (extras.containsKey("MOE_MSG_RECEIVED_TIME")) {
                        MoEHelper.getInstance((Context)context).trackNotificationClickedByTime(extras.getLong("MOE_MSG_RECEIVED_TIME"));
                    }
                    intent.removeExtra("NOTIFICATION_RECEIVED_MOE");
                }
                catch (JSONException e) {
                    Logger.f((String)"PushMessageListener:logNotificationClicked", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            Logger.f((String)"PushMessageListener:logNotificationClicked", (Throwable)e);
        }
    }
}

