/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.pushbase.push;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.push.PushManager;
import com.moengage.pushbase.PushUtils;

public class MoEPushWorkerTask
extends SDKTask {
    private String workerTaskType;
    private Bundle extras;

    public MoEPushWorkerTask(Context context, @NonNull String workerTaskType, @Nullable Bundle extras) {
        super(context);
        this.workerTaskType = workerTaskType;
        this.extras = extras;
    }

    public TaskResult execute() {
        try {
            Logger.v((String)"MoEPushWorkerTask: executing task");
            if (TextUtils.isEmpty((CharSequence)this.workerTaskType)) {
                return null;
            }
            Logger.v((String)("MoEPushWorkerTask: executing " + this.workerTaskType));
            switch (this.workerTaskType) {
                case "MOE_REG_REFRESH": {
                    ConfigurationProvider.getInstance((Context)this.mContext).setGCMToken("");
                    this.registerForPush();
                    break;
                }
                case "REG_ON_APP_OPEN": {
                    this.handlePushRegistrationOnAppOpen();
                    break;
                }
                case "SHOW_NOTIFICATION": {
                    PushManager.PushHandler pushHandler = PushManager.getInstance().getPushHandler();
                    if (pushHandler == null) break;
                    pushHandler.handlePushPayload(this.mContext, this.extras);
                    break;
                }
                case "MOE_REG_REQ": {
                    this.registerForPush();
                }
            }
            Logger.v((String)"MoEPushWorkerTask: completed task");
        }
        catch (Exception e) {
            Logger.e((String)"MoEPushWorkerTask: execute() ", (Throwable)e);
        }
        return null;
    }

    public String getTaskTag() {
        return "MOE_PUSH_WORKER_TASK";
    }

    public boolean isSynchronous() {
        return false;
    }

    private void registerForPush() {
        if (!PushUtils.shouldRegisterForPush(this.mContext)) {
            return;
        }
        PushManager.PushHandler pushHandler = PushManager.getInstance().getPushHandler();
        if (pushHandler != null) {
            String token = pushHandler.registerForPushToken(this.mContext);
            Logger.v((String)("MoEPushWorkerTask registerForPush(): registerForPush " + token));
        }
    }

    private void handlePushRegistrationOnAppOpen() {
        PushManager.PushHandler pushHandler;
        if (PushUtils.shouldRegisterForPush(this.mContext) && (pushHandler = PushManager.getInstance().getPushHandler()) != null) {
            pushHandler.getPushToken(this.mContext);
        }
    }
}

