/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.pushbase.push;

import android.app.IntentService;
import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.content.WakefulBroadcastReceiver;
import android.text.TextUtils;
import com.moe.pushlibrary.MoEHelper;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.MoEEventManager;
import com.moengage.push.PushManager;
import com.moengage.pushbase.PushUtils;
import com.moengage.pushbase.push.MoEPushCallBacks;
import com.moengage.pushbase.push.MoEngageNotificationUtils;
import com.moengage.pushbase.push.PushMessageListener;
import org.json.JSONException;
import org.json.JSONObject;

public class MoEPushWorker
extends IntentService {
    private final int NAVIGATION_DIRECTION_RIGHT = 1;
    private final int NAVIGATION_DIRECTION_LEFT = -1;
    public static final String NOTIFICATION_DISMISS = "DEAL_WITH_NOTI_AUTODISMISS";
    public static final String EXTRA_SERVICE_CAROUSEL = "DEAL_WITH_CAROUSEL";
    public static final String EXTRA_SERVICE_NOTIFY = "DEAL_WITH_NOTIFICATION";
    public static final String NOTIFICATION_CLEARED = "DEAL_WITH_NOTIFICATION_CLEARED";
    public static final String TRACK_NOTIFICATION_RECEIVED = "DEAL_WITH_NOTIFI_TRACKING";
    public static final String SHOW_NOTIFICATION = "SHOW_NOTIFICATION";
    public static final String PUSH_REG_FALLBACK = "PUSH_REG_FALLBACK";

    public MoEPushWorker() {
        super("RegistrationIntentService");
    }

    protected void onHandleIntent(Intent intent) {
        try {
            String intentAction;
            if (null == intent || TextUtils.isEmpty((CharSequence)intent.getAction())) {
                return;
            }
            MoEHelperUtils.dumpIntentExtras((Intent)intent);
            Logger.v((String)"MoEPushWorker#onHandleIntent");
            switch (intentAction = intent.getAction()) {
                case "MOE_REG_REQ": {
                    this.handlePushRegistration(intent);
                    break;
                }
                case "MOE_DEL_TOK": {
                    this.handlePushTokenDeletion(intent);
                    break;
                }
                case "DEAL_WITH_CAROUSEL": {
                    this.handleCarousel(intent);
                    break;
                }
                case "DEAL_WITH_NOTIFICATION": {
                    this.handleNotification(intent);
                    break;
                }
                case "DEAL_WITH_NOTIFICATION_CLEARED": {
                    this.handleNotificationCleared(intent);
                    break;
                }
                case "DEAL_WITH_NOTI_AUTODISMISS": {
                    this.handleNotificationDismiss(intent);
                    break;
                }
                case "DEAL_WITH_NOTIFI_TRACKING": {
                    this.handleNotificationReceived(intent);
                    break;
                }
                case "SHOW_NOTIFICATION": {
                    this.handleShowNotification(intent);
                    break;
                }
                case "PUSH_REG_FALLBACK": {
                    this.handlePushRegistrationFallback();
                }
            }
        }
        catch (Exception e) {
            Logger.f((String)"MoEPushWorker#onHandleIntent: Handle payload", (Throwable)e);
        }
    }

    private void handleShowNotification(Intent intent) {
        Logger.v((String)"MoEPushWorker#onHandleIntent: handleShowNotification");
        PushManager.PushHandler pushHandler = PushManager.getInstance().getPushHandler();
        if (pushHandler != null) {
            pushHandler.handlePushPayload(this.getApplicationContext(), intent.getExtras());
            WakefulBroadcastReceiver.completeWakefulIntent((Intent)intent);
        }
    }

    private void handleNotificationReceived(Intent intent) {
        Logger.v((String)"MoEPushWorker#onHandleIntent: handleNotificationReceived");
        Bundle extras = intent.getExtras();
        this.tryToShowNotification(extras);
        MoEHelper.getInstance((Context)this.getApplicationContext()).syncInteractionDataNow();
    }

    private void handleNotificationDismiss(Intent intent) {
        Logger.v((String)"MoEPushWorker#onHandleIntent: handleNotificationDismiss");
        Bundle extras = intent.getExtras();
        int notificationId = extras.getInt(NOTIFICATION_DISMISS);
        if (notificationId != 0) {
            NotificationManager manager = (NotificationManager)this.getSystemService("notification");
            manager.cancel(notificationId);
        }
    }

    private void handleNotificationCleared(Intent intent) throws JSONException {
        Logger.v((String)"MoEPushWorker#onHandleIntent: handleNotificationCleared");
        Bundle extras = intent.getExtras();
        if (extras == null) {
            return;
        }
        JSONObject newJson = new JSONObject();
        newJson.put("gcm_campaign_id", (Object)MoEngageNotificationUtils.getCampaignIdIfAny(extras));
        MoEEventManager.getInstance((Context)this.getApplicationContext()).trackEvent("NOTIFICATION_CLEARED_MOE", newJson);
        MoEPushCallBacks.getInstance().onPushCleared(extras);
        MoEHelper.getInstance((Context)this.getApplicationContext()).syncInteractionDataNow();
        MoEngageNotificationUtils.deleteImagesFromInternal((Context)this, MoEngageNotificationUtils.getCampaignIdIfAny(extras));
    }

    private void handleNotification(Intent intent) {
        Logger.v((String)"MoEPushWorker#onHandleIntent: handleNotification");
        Bundle extras = intent.getExtras();
        if (extras == null) {
            Logger.f((String)"MoEPushWorker$handleNotification bundle is null");
            return;
        }
        this.tryToShowNotification(extras);
    }

    private void handleCarousel(Intent intent) {
        Logger.v((String)"MoEPushWorker#onHandleIntent: handleCarousel");
        Bundle extras = intent.getExtras();
        if (extras.containsKey("action_tag")) {
            String actionTag = extras.getString("action_tag");
            try {
                if (!TextUtils.isEmpty((CharSequence)actionTag) && actionTag.equals("m_next")) {
                    this.recreateCarouselNotification(extras, 1);
                } else if (!TextUtils.isEmpty((CharSequence)actionTag) && actionTag.equals("m_prev")) {
                    this.recreateCarouselNotification(extras, -1);
                }
            }
            catch (Exception e) {
                Logger.f((String)("MoEWorker$handleCarouselNav Exception occurred," + e.getMessage()));
            }
        }
    }

    private void handlePushTokenDeletion(Intent intent) {
        Logger.v((String)"MoEPushWorker#onHandleIntent: GCM Token Deletion request");
        Bundle extras = intent.getExtras();
        String senderId = null;
        if (extras.containsKey("SENDER_ID")) {
            senderId = extras.getString("SENDER_ID");
        }
        PushManager.getInstance().getPushHandler().deleteToken(this.getApplicationContext(), senderId);
    }

    private void handlePushRegistration(Intent intent) {
        Logger.v((String)"MoEPushWorker#onHandleIntent: Registration request");
        if (!PushUtils.shouldRegisterForPush(this.getApplicationContext())) {
            return;
        }
        ConfigurationProvider provider = ConfigurationProvider.getInstance((Context)this.getApplicationContext());
        if (intent.hasExtra("registration_id")) {
            PushManager.getInstance().refreshTokenInternal(this.getApplicationContext(), intent.getStringExtra("registration_id"), "MoE");
        } else {
            this.registerForPush();
        }
    }

    private void registerForPush() {
        String token = PushManager.getInstance().getPushHandler().registerForPushToken(this.getApplicationContext());
        Logger.v((String)("MoEPushWorker#onHandleIntent: registerForPush " + token));
    }

    private void recreateCarouselNotification(Bundle extras, int navDir) {
        Logger.v((String)"MoEPushWorker#onHandleIntent: recreateCarouselNotification");
        try {
            if (navDir == 1) {
                extras.putBoolean("m_next", true);
            } else {
                extras.putBoolean("m_next", false);
            }
            int idx = MoEngageNotificationUtils.getNextImageIndex(extras);
            Logger.v((String)("MoEWorker$recreateCarouselNotification idx" + idx));
            extras.remove("action_tag");
            extras.remove("action_payload");
            extras.remove("m_next");
            extras.remove("m_prev");
            extras.putBoolean("re_notify", true);
            extras.putInt("img_idx", idx);
            this.tryToShowNotification(extras);
        }
        catch (Exception e) {
            Logger.f((String)("MoEWorker$recreateCarouselNotification Exception ocurred " + e));
        }
    }

    private void tryToShowNotification(Bundle extras) {
        PushManager.PushHandler pushHandler = PushManager.getInstance().getPushHandler();
        PushMessageListener pushMessageListener = (PushMessageListener)pushHandler.getMessageListener();
        pushMessageListener.onMessagereceived(this.getApplicationContext(), extras);
    }

    private void handlePushRegistrationFallback() {
        Logger.v((String)"MoEPushWorker#onHandleIntent: handlePushRegistrationFallback");
        ConfigurationProvider provider = ConfigurationProvider.getInstance((Context)this.getApplicationContext());
        if (PushUtils.shouldRegisterForPush(this.getApplicationContext()) && TextUtils.isEmpty((CharSequence)provider.getGCMToken())) {
            this.registerForPush();
        }
    }
}

