/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.pushbase.push;

import android.annotation.TargetApi;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.moengage.core.Logger;
import org.json.JSONObject;

@TargetApi(value=26)
class MoENotificationChannel {
    private static MoENotificationChannel _INSTANCE = null;

    private MoENotificationChannel() {
    }

    public static MoENotificationChannel getInstance() {
        if (_INSTANCE == null) {
            _INSTANCE = new MoENotificationChannel();
        }
        return _INSTANCE;
    }

    @Nullable
    private String createNotificationChannel(Context context, Bundle pushPayload) {
        try {
            String notificationChannelString;
            if (pushPayload == null) {
                return null;
            }
            if (pushPayload.containsKey("moe_create_channel") && !TextUtils.isEmpty((CharSequence)(notificationChannelString = pushPayload.getString("moe_create_channel")))) {
                int visibility;
                JSONObject notificationChannelAttributes = new JSONObject(notificationChannelString);
                String name = null;
                String channelId = null;
                int importance = -999;
                if (notificationChannelAttributes.has("name")) {
                    name = notificationChannelAttributes.getString("name");
                }
                if (notificationChannelAttributes.has("channel_id")) {
                    channelId = notificationChannelAttributes.getString("channel_id");
                }
                if (notificationChannelAttributes.has("importance")) {
                    importance = notificationChannelAttributes.getInt("importance");
                }
                if (TextUtils.isEmpty((CharSequence)name) || TextUtils.isEmpty((CharSequence)channelId) || importance == -999) {
                    Logger.e((String)"Either name or channel id or importance is missing cannot create notification channel");
                    return null;
                }
                if (!this.isImportanceValid(importance)) {
                    Logger.e((String)"MoENotificationChannel:createNotificationChannel : importance not valid cannot create notification channel");
                    return null;
                }
                NotificationChannel channel = new NotificationChannel(channelId, (CharSequence)name, importance);
                if (notificationChannelAttributes.has("enable_light")) {
                    channel.enableLights(notificationChannelAttributes.getBoolean("enable_light"));
                }
                if (notificationChannelAttributes.has("enable_vibration")) {
                    channel.enableVibration(notificationChannelAttributes.getBoolean("enable_vibration"));
                }
                if (notificationChannelAttributes.has("bypass_dnd")) {
                    channel.setBypassDnd(notificationChannelAttributes.getBoolean("bypass_dnd"));
                }
                if (notificationChannelAttributes.has("description")) {
                    channel.setDescription(notificationChannelAttributes.getString("description"));
                }
                if (notificationChannelAttributes.has("group")) {
                    channel.setGroup(notificationChannelAttributes.getString("group"));
                }
                if (notificationChannelAttributes.has("light_color")) {
                    channel.setLightColor(Color.parseColor((String)notificationChannelAttributes.getString("light_color")));
                }
                if (notificationChannelAttributes.has("visibility") && this.isVisibilityValid(visibility = notificationChannelAttributes.getInt("visibility"))) {
                    channel.setLockscreenVisibility(visibility);
                }
                if (notificationChannelAttributes.has("show_badge")) {
                    channel.setShowBadge(notificationChannelAttributes.getBoolean("show_badge"));
                }
                if (notificationChannelAttributes.has("sound")) {
                    // empty if block
                }
                if (notificationChannelAttributes.has("vibration_pattern")) {
                    // empty if block
                }
                NotificationManager manager = (NotificationManager)context.getSystemService("notification");
                manager.createNotificationChannel(channel);
                return channel.getId();
            }
        }
        catch (Exception e) {
            Logger.f((String)"MoEngageNotificationUtils: createNotificationChannel: ", (Throwable)e);
        }
        return null;
    }

    private boolean isImportanceValid(int importance) {
        return importance == 3 || importance == 4 || importance == 2 || importance == 5 || importance == 1 || importance == 0 || importance == -1000;
    }

    private boolean isVisibilityValid(int visibility) {
        return visibility == 0 || visibility == 1 || visibility == -1;
    }

    String getNotificationChannelId(Context context, Bundle pushPayload) {
        if (pushPayload.containsKey("moe_channel_id")) {
            return pushPayload.getString("moe_channel_id");
        }
        return null;
    }

    void createFallbackNotificationChanelIfRequired(Context context) {
        if (Build.VERSION.SDK_INT >= 26 && !this.isChannelExists(context, "moe_default_channel")) {
            Logger.v((String)"MoENotificationChannel: createFallbackNotificationChanelIfRequired() creating default channel");
            NotificationManager manager = (NotificationManager)context.getSystemService("notification");
            NotificationChannel channel = new NotificationChannel("moe_default_channel", (CharSequence)"General", 3);
            manager.createNotificationChannel(channel);
        }
    }

    boolean isChannelExists(Context context, String channelID) {
        if (Build.VERSION.SDK_INT < 26) {
            return true;
        }
        NotificationManager manager = (NotificationManager)context.getSystemService("notification");
        return manager.getNotificationChannel(channelID) != null;
    }
}

