/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.pushbase.fragments;

import android.app.AlarmManager;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentActivity;
import android.view.ContextThemeWrapper;
import com.moengage.core.Logger;
import com.moengage.pushbase.fragments.DatePickerFragment;
import com.moengage.pushbase.push.MoEPushWorker;
import com.moengage.pushbase.push.PushActionManager;
import java.util.Calendar;

public class LaterDialogFragment
extends DialogFragment {
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        long[] snoozeArray;
        CharSequence[] options;
        Calendar c;
        final Bundle extras = this.getArguments();
        if (extras == null) {
            this.dismiss();
            Logger.v((String)"LaterDialogFragment$onCreateDialog : Extras is null");
        }
        int snoozeTime = this.getAndRemoveSnoozeExtra(extras, "value_snooze");
        int hourToday = this.getAndRemoveSnoozeExtra(extras, "value_today");
        int hourTomorrow = this.getAndRemoveSnoozeExtra(extras, "value_tomorrow");
        extras.putBoolean("re_notify", true);
        Intent laterIntent = new Intent((Context)this.getActivity(), MoEPushWorker.class);
        laterIntent.setAction("DEAL_WITH_NOTIFICATION");
        laterIntent.putExtras(extras);
        int _id = (int)System.currentTimeMillis();
        final PendingIntent alarmPendingIntent = PendingIntent.getService((Context)this.getActivity(), (int)_id, (Intent)laterIntent, (int)0x8000000);
        String snoozeOption = "Remind in " + snoozeTime + " hour";
        int displayTime = hourToday + Calendar.getInstance().get(11);
        String suffix = "AM";
        if (hourToday != -1 && displayTime > 11) {
            suffix = "PM";
        }
        displayTime = displayTime > 12 ? displayTime - 12 : displayTime;
        int displayMinutes = Calendar.getInstance().get(12);
        String todayOption = null;
        todayOption = displayMinutes < 10 ? "Today (" + displayTime + ":0" + displayMinutes + suffix + ")" : "Today (" + displayTime + ":" + displayMinutes + suffix + ")";
        suffix = "AM";
        if (hourTomorrow != -1 && hourTomorrow > 11) {
            suffix = "PM";
        }
        displayTime = (displayTime = hourTomorrow) > 12 ? displayTime - 12 : displayTime;
        String tomorrowOption = "Tomorrow (" + displayTime + suffix + ")";
        long triggerAtMillisSnoozeTime = -1L;
        long triggerAtMillisHourToday = -1L;
        long triggerAtMillisHourTomorrow = -1L;
        if (snoozeTime != -1) {
            c = Calendar.getInstance();
            c.add(11, snoozeTime);
            triggerAtMillisSnoozeTime = c.getTimeInMillis();
        }
        if (hourToday != -1) {
            c = Calendar.getInstance();
            c.add(12, hourToday * 60);
            triggerAtMillisHourToday = c.getTimeInMillis();
        }
        if (hourTomorrow != -1) {
            c = Calendar.getInstance();
            c.add(5, 1);
            c.set(11, hourTomorrow);
            c.set(12, 0);
            triggerAtMillisHourTomorrow = c.getTimeInMillis();
        }
        String dateTimeOption = "Pick a date and time";
        if (snoozeTime != -1 && hourToday != -1 && hourTomorrow != -1) {
            options = new CharSequence[]{snoozeOption, todayOption, tomorrowOption, dateTimeOption};
            snoozeArray = new long[]{triggerAtMillisSnoozeTime, triggerAtMillisHourToday, triggerAtMillisHourTomorrow, -1L};
        } else if (snoozeTime == -1 && hourToday != -1 && hourTomorrow != -1) {
            options = new CharSequence[]{todayOption, tomorrowOption, dateTimeOption};
            snoozeArray = new long[]{triggerAtMillisHourToday, triggerAtMillisHourTomorrow, -1L};
        } else if (snoozeTime != -1 && hourToday == -1 && hourTomorrow != -1) {
            options = new CharSequence[]{snoozeOption, tomorrowOption, dateTimeOption};
            snoozeArray = new long[]{triggerAtMillisSnoozeTime, triggerAtMillisHourTomorrow, -1L};
        } else if (snoozeTime != -1 && hourToday != -1 && hourTomorrow == -1) {
            options = new CharSequence[]{snoozeOption, todayOption, dateTimeOption};
            snoozeArray = new long[]{triggerAtMillisSnoozeTime, triggerAtMillisHourToday, -1L};
        } else if (snoozeTime != -1 && hourToday == -1 && hourTomorrow == -1) {
            options = new CharSequence[]{snoozeOption, dateTimeOption};
            snoozeArray = new long[]{triggerAtMillisSnoozeTime, -1L};
        } else if (snoozeTime == -1 && hourToday != -1 && hourTomorrow == -1) {
            options = new CharSequence[]{todayOption, dateTimeOption};
            snoozeArray = new long[]{triggerAtMillisHourToday, -1L};
        } else if (snoozeTime == -1 && hourToday == -1 && hourTomorrow != -1) {
            options = new CharSequence[]{tomorrowOption, dateTimeOption};
            snoozeArray = new long[]{triggerAtMillisHourTomorrow, -1L};
        } else {
            Calendar c2 = Calendar.getInstance();
            c2.add(11, 1);
            triggerAtMillisSnoozeTime = c2.getTimeInMillis();
            snoozeOption = "Remind in an hour";
            options = new CharSequence[]{snoozeOption, dateTimeOption};
            snoozeArray = new long[]{triggerAtMillisSnoozeTime, -1L};
        }
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)new ContextThemeWrapper((Context)this.getActivity(), 16973939));
        builder.setTitle((CharSequence)"Later").setItems(options, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                long triggerAtMillis = snoozeArray[which];
                if (triggerAtMillis != -1L) {
                    FragmentActivity fragmentActivity = LaterDialogFragment.this.getActivity();
                    LaterDialogFragment.this.getActivity();
                    AlarmManager alarmManager = (AlarmManager)fragmentActivity.getSystemService("alarm");
                    alarmManager.set(0, triggerAtMillis, alarmPendingIntent);
                    Calendar c = Calendar.getInstance();
                    c.setTimeInMillis(triggerAtMillis);
                    Logger.v((String)("LaterDialogFragment : Reminder set at :" + c.getTime()));
                } else {
                    DatePickerFragment newFragment = new DatePickerFragment();
                    newFragment.setArguments(extras);
                    newFragment.show(LaterDialogFragment.this.getActivity().getSupportFragmentManager(), "datePicker");
                }
            }
        });
        return builder.create();
    }

    public void onDismiss(DialogInterface dialogInterface) {
        super.onDismiss(dialogInterface);
        if (!DatePickerFragment.isDateDialogShown()) {
            if (this.getActivity() != null) {
                this.getActivity().finish();
            }
            Logger.v((String)"LaterDialogFragment$onDismiss : PushTracker:Completed");
        }
        PushActionManager.dialogShown = false;
    }

    private int getAndRemoveSnoozeExtra(Bundle extras, String key) {
        int snoozeVal = extras.getInt(key);
        extras.remove(key);
        return snoozeVal;
    }
}

