/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.pushbase.activities;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.text.TextUtils;
import com.moe.pushlibrary.MoEHelper;
import com.moengage.core.Logger;
import com.moengage.core.MoEDispatcher;
import com.moengage.push.PushManager;
import com.moengage.pushbase.push.MoEPushCallBacks;
import com.moengage.pushbase.push.MoEngageNotificationUtils;
import com.moengage.pushbase.push.PushActionManager;
import com.moengage.pushbase.push.PushMessageListener;
import org.json.JSONObject;

public class PushTracker
extends FragmentActivity {
    protected void onCreate(Bundle savedInstanceState) {
        String campaignId;
        super.onCreate(savedInstanceState);
        Logger.v((String)"PushTracker:Reached ");
        Intent intent = this.getIntent();
        if (null == intent) {
            return;
        }
        Bundle extras = intent.getExtras();
        if (null == extras) {
            return;
        }
        boolean syncNow = false;
        if (intent.hasExtra("gcm_webUrl")) {
            syncNow = true;
        }
        PushManager.PushHandler pushHandler = PushManager.getInstance().getPushHandler();
        PushMessageListener pushMessageListener = (PushMessageListener)pushHandler.getMessageListener();
        pushMessageListener.dismissNotificationAfterClick(this.getApplicationContext(), extras);
        pushMessageListener.logNotificationClicked(this.getApplicationContext(), this.getIntent());
        MoEngageNotificationUtils.deleteImagesFromInternal((Context)this, MoEngageNotificationUtils.getCampaignIdIfAny(extras));
        MoEPushCallBacks.getInstance().onPushClicked(extras);
        if (extras.containsKey("moe_inapp_cid") && !TextUtils.isEmpty((CharSequence)(campaignId = extras.getString("moe_inapp_cid")))) {
            MoEDispatcher.getInstance((Context)this.getApplicationContext()).checkAndShowLinkedInApp(campaignId);
        }
        if (extras.containsKey("action_tag")) {
            Logger.v((String)"PushTracker: Redirecting to ActionMapper");
            String actionTag = extras.getString("action_tag");
            String actionPayload = extras.getString("action_payload");
            JSONObject actionObject = null;
            try {
                actionObject = new JSONObject(actionPayload);
                PushActionManager.getInstance().onActionPerformed((Activity)this, actionTag, actionObject);
            }
            catch (Exception e) {
                Logger.f((String)("PushTracker: error converting string to JSON," + e.getMessage()));
            }
        } else {
            extras.remove("NOTIFICATION_RECEIVED_MOE");
            extras.remove("gcm_campaign_id");
            if (extras.containsKey("moe_cid_attr")) {
                extras.remove("moe_cid_attr");
            }
            pushMessageListener.onHandleRedirection((Activity)this, extras);
        }
        if (syncNow) {
            MoEHelper.getInstance((Context)this.getApplicationContext()).syncInteractionDataNow();
        }
        this.finish();
        Logger.v((String)"PushTracker:Completed");
    }
}

