/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.pushbase;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.core.executor.ITask;
import com.moengage.core.executor.TaskProcessor;
import com.moengage.pushbase.push.MoEPushWorker;
import com.moengage.pushbase.push.MoEPushWorkerTask;

public final class PushUtils {
    private PushUtils() {
    }

    public static void scheduleDeviceRegistrationCall(Context context) {
        if (context == null) {
            Logger.e((String)"PushUtils:Context is null device cannot register for push");
            return;
        }
        if (!PushUtils.shouldRegisterForPush(context)) {
            return;
        }
        Logger.v((String)"PushUtils :: scheduleDeviceRegistrationCall: ");
        if (ConfigurationProvider.getInstance((Context)context).isDeviceRegistered()) {
            return;
        }
        if (MoEUtils.isRegistrationScheduled((Context)context)) {
            return;
        }
        int backOff = MoEUtils.getCurrentExponentialCounter((Context)context);
        if (backOff >= 512) {
            MoEUtils.saveCurrentExponentialCounter((Context)context, (int)1);
            Logger.e((String)"PushUtils:registration failed miserably so skipping it for now");
            MoEUtils.setRegistrationScheduled((Context)context, (boolean)false);
            return;
        }
        MoEUtils.saveCurrentExponentialCounter((Context)context, (int)(backOff * 2));
        PushUtils.schedulePushRegistration(context, backOff, "MOE_REG_REQ");
        MoEUtils.setRegistrationScheduled((Context)context, (boolean)true);
    }

    public static void schedulePushRegistration(Context context, int backOff, String action) {
        Intent registrationIntent = new Intent(context, MoEPushWorker.class);
        registrationIntent.setAction(action);
        PendingIntent pendingOps = PendingIntent.getService((Context)context, (int)0, (Intent)registrationIntent, (int)0x10000000);
        AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
        alarmManager.set(0, (long)(backOff * 1000), pendingOps);
    }

    public static void offLoadTaskToWorker(@NonNull Context context, @NonNull String action) {
        try {
            if (context == null) {
                Logger.e((String)"PushUtils :Context is null cannot call MoEPushWorker");
                return;
            }
            TaskProcessor.getInstance().addTask((ITask)new MoEPushWorkerTask(context, action, null));
        }
        catch (Exception e) {
            Logger.f((String)"PushUtils: offLoadTaskToWorker() ", (Throwable)e);
        }
    }

    public static boolean shouldRegisterForPush(Context context) {
        ConfigurationProvider provider = ConfigurationProvider.getInstance((Context)context);
        return provider.isPushRegistrationEnabled() && !provider.isPushNotificationOptedOut();
    }
}

