package com.moengage.pushbase.push;

import android.app.Activity;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.TaskStackBuilder;
import android.text.TextUtils;
import com.moe.pushlibrary.MoEHelper;
import com.moe.pushlibrary.PayloadBuilder;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.ActionMapperConstants;
import com.moengage.core.ActionManagerBase;
import com.moengage.core.Logger;
import com.moengage.core.MoEDispatcher;
import com.moengage.push.PushManager;
import com.moengage.pushbase.PushActionMapperConstants;
import com.moengage.pushbase.fragments.LaterDialogFragment;
import java.util.Calendar;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * @author Umang Chamaria
 */
public class PushActionManager extends ActionManagerBase {

  public static boolean dialogShown = false;
  private static PushActionManager _INSTANCE;

  public static PushActionManager getInstance() {
    if (null == _INSTANCE) {
      _INSTANCE = new PushActionManager();
    }
    return _INSTANCE;
  }

  public void registerActionHandler(IActionHandler actionHandler) {
    this.actionHandlers = actionHandler;
  }

  private IActionHandler actionHandlers;

  Context context;

  private PushActionManager() {

  }

  public boolean onActionPerformed(Activity context, String tag, JSONObject actionObject) {
    this.context = context.getApplicationContext();
    try {
      switch (tag) {
        case PushActionMapperConstants.ACTION_NAVIGATE:
          handleActionNavigation(context, actionObject);
          break;
        case PushActionMapperConstants.ACTION_TRACK_ATTR:
          handleActionTrackEvent(context, actionObject);
          break;
        case PushActionMapperConstants.ACTION_SHARE:
          handleActionShare(context, actionObject);
          break;
        case PushActionMapperConstants.ACTION_CALL:
          handleActionCall(context, actionObject);
          break;
        case PushActionMapperConstants.ACTION_COPY:
          handleActionCopy(context, actionObject);
          break;
        case PushActionMapperConstants.ACTION_SET_ATTRIBUTE:
          handleActionSetAttribute(context, actionObject);
          break;
        case PushActionMapperConstants.ACTION_OPEN_IN_APP:
          //TODO handle open linked in-app
          handleActionOpenInApp(context, actionObject);
          break;
        case PushActionMapperConstants.ACTION_REMIND_EXACT:
          handleActionRemindExact(context, actionObject);
          break;
        case PushActionMapperConstants.ACTION_REMIND_INEXACT:
          handleActionRemindInExact(context, actionObject);
          break;
        default:
          // TODO: 05/02/16 handle custom action defined by clients
          if (actionHandlers != null) {
            actionHandlers.onActionPerformed(context, tag, actionObject);
          } else {
            Logger.e("Not a valid action" + tag);
          }
          return false;
      }
    } catch (Exception e) {
      Logger.f("PushActionManager : exception occurred while performing " +
          "notification action," + e.getMessage());
    }
    return true;
  }

  private void handleActionOpenInApp(Activity context, JSONObject actionObject)
      throws JSONException {
    if (actionObject.has("moe_inapp_cid")) {
      String campaignId = actionObject.getString("moe_inapp_cid");
      if (!TextUtils.isEmpty(campaignId)) {
        MoEDispatcher.getInstance(context).checkAndShowLinkedInApp(campaignId);
      }
    }
  }

  private void handleActionSetAttribute(Context context, JSONObject actionObject) {
    String value = null, userAttribute = null, dataType = null;
    int valueOf;
    try {
      if (actionObject.has(PushActionMapperConstants.KEY_SET)) {
        userAttribute = actionObject.getString(PushActionMapperConstants.KEY_SET);
      }
      if (actionObject.has(PushActionMapperConstants.KEY_VALUE_TYPE) && actionObject.has(
          PushActionMapperConstants.KEY_VALUE) && !TextUtils.isEmpty(userAttribute)) {
        // TODO: 13/04/16 this is not tested as it not implemented on the dashboard test once
        // there on dashboard.
        dataType = actionObject.getString(PushActionMapperConstants.KEY_VALUE_TYPE);
        switch (dataType) {
          case "int":
            MoEHelper.getInstance(context)
                .setUserAttribute(userAttribute,
                    actionObject.getInt(PushActionMapperConstants.KEY_VALUE));
            break;
          case "double":
            MoEHelper.getInstance(context)
                .setUserAttribute(userAttribute,
                    actionObject.getDouble(PushActionMapperConstants.KEY_VALUE));
            break;
          case "String":
            MoEHelper.getInstance(context)
                .setUserAttribute(userAttribute,
                    actionObject.getString(PushActionMapperConstants.KEY_VALUE));
            break;
          case "boolean":
            MoEHelper.getInstance(context)
                .setUserAttribute(userAttribute,
                    actionObject.getBoolean(PushActionMapperConstants.KEY_VALUE));
            break;
          case "long":
            MoEHelper.getInstance(context)
                .setUserAttribute(userAttribute,
                    actionObject.getLong(PushActionMapperConstants.KEY_VALUE));
            break;
        }
      } else {
        if (actionObject.has(PushActionMapperConstants.KEY_VALUE) && !TextUtils.isEmpty(
            userAttribute)) {
          JSONObject userAttrJSON = new JSONObject();
          userAttrJSON.put(userAttribute.trim(),
              actionObject.getString(PushActionMapperConstants.KEY_VALUE));
          MoEDispatcher.getInstance(context).setCustomUserAttribute(userAttrJSON);
        }
      }
    } catch (Exception e) {
      Logger.f("PushActionManager : handleActionSetAttribute ", e);
    }
  }

  private void handleActionTrackEvent(Context context, JSONObject actionObject) {
    Logger.v("PushActionManager$handleActionTrackEvent(): action_track");
    if (actionObject.has(PushActionMapperConstants.KEY_TRACK)) {
      String eventToTrack = null;
      String eventValue = null;
      try {
        eventToTrack = actionObject.getString(PushActionMapperConstants.KEY_TRACK);
        PayloadBuilder builder = new PayloadBuilder();
        if (actionObject.has(ActionMapperConstants.KEY_VALUE_OF)) {
          eventValue = actionObject.getString(ActionMapperConstants.KEY_VALUE_OF);
        }
        if (!TextUtils.isEmpty(eventValue)) {
          builder.putAttrString(ActionMapperConstants.KEY_VALUE_OF, eventValue);
        }
        MoEHelper.getInstance(context).trackEvent(eventToTrack, builder.build());
      } catch (Exception e) {
        Logger.f("PushActionManger : handleActionTrackEvent()", e);
      }
    }
  }

  private void handleActionRemindExact(Activity context, JSONObject actionObject) throws Exception {
    Logger.v("PushActionManager$handleActionRemindExact()");
    Intent intent = context.getIntent();
    if (null == intent) {
      Logger.v("PushActionManager$handleActionRemindExact() Intent is null");
      return;
    }
    Bundle extras = intent.getExtras();
    if (null == extras) {
      Logger.v("PushActionManager$handleActionRemindExact() Extras is null");
      return;
    }
    // Removing extras since they are not used again
    extras.remove(PushActionMapperConstants.KEY_ACTION_TAG);
    extras.remove(PushActionMapperConstants.KEY_ACTION_PAYLOAD);
    extras.putBoolean(PushActionMapperConstants.KEY_RENOTIFY, true);
    Intent laterIntent = new Intent(context, MoEPushWorker.class);
    laterIntent.putExtras(extras);
    laterIntent.setAction(MoEPushWorker.EXTRA_SERVICE_NOTIFY);
    final int _id = (int) System.currentTimeMillis();
    PendingIntent alarmPendingIntent =
        PendingIntent.getService(context, _id, laterIntent, PendingIntent.FLAG_UPDATE_CURRENT);
    int snoozeValue = getSnoozeVal(actionObject, PushActionMapperConstants.KEY_VALUE);
    if (snoozeValue > 0) {
      final Calendar c = Calendar.getInstance();
      c.add(Calendar.HOUR_OF_DAY, snoozeValue);
      long triggerAtMillis = c.getTimeInMillis();
      AlarmManager alarmManager = (AlarmManager) context.getSystemService(context.ALARM_SERVICE);
      alarmManager.set(AlarmManager.RTC_WAKEUP, triggerAtMillis, alarmPendingIntent);
      Logger.v("PushActionManager$handleActionRemindExact(): Reminder set at :" + c.getTime());
    }
  }

  private void handleActionRemindInExact(Activity context, JSONObject actionObject)
      throws Exception {
    Logger.v("PushActionManager$handleActionRemindInExact() : action_remind_inexact ");
    Intent intent = context.getIntent();
    if (null == intent) {
      Logger.v("PushActionManager$handleActionRemindInExact() Intent is null");
      return;
    }

    Bundle extras = intent.getExtras();
    if (null == extras) {
      Logger.v("PushActionManager$handleActionRemindInExact() Extras is null");
      return;
    }
    dialogShown = true;
    // Removing extras since they are not used again
    extras.remove(PushActionMapperConstants.KEY_ACTION_TAG);
    extras.remove(PushActionMapperConstants.KEY_ACTION_PAYLOAD);

    int snoozeTime = getSnoozeVal(actionObject, PushActionMapperConstants.ACTION_SNOOZE_TIME);
    int hourToday = getSnoozeVal(actionObject, PushActionMapperConstants.ACTION_SNOOZE_TODAY);
    int hourTomorrow = getSnoozeVal(actionObject, PushActionMapperConstants.ACTION_SNOOZE_TOMORROW);

    // Check to make sure hour-today is within today's time range
    hourToday =
        (hourToday + Calendar.getInstance().get(Calendar.HOUR_OF_DAY)) < 25 ? hourToday : -1;

    extras.putInt(PushActionMapperConstants.ACTION_SNOOZE_TIME, snoozeTime);
    extras.putInt(PushActionMapperConstants.ACTION_SNOOZE_TODAY, hourToday);
    extras.putInt(PushActionMapperConstants.ACTION_SNOOZE_TOMORROW, hourTomorrow);

    // Show LaterTimePicker Dialog
    LaterDialogFragment dialogFragment = new LaterDialogFragment();
    dialogFragment.setArguments(extras);
    dialogFragment.show(((FragmentActivity) context).getSupportFragmentManager(), "laterDialog");
  }

  /**
   * This is a callback for action button click when action type is custom action
   */
  public interface IActionHandler {

    boolean onActionPerformed(Context context, String tag, JSONObject actionObject);
  }

  private int getSnoozeVal(JSONObject actionObject, String snoozeKey) throws Exception {
    return actionObject.has(snoozeKey) ? Integer.parseInt(actionObject.getString(snoozeKey).trim())
        : -1;
  }

  public static boolean isDialogShown() {
    return dialogShown;
  }

  @Override protected void handleActionNavigation(Activity context, JSONObject actionObject)
      throws JSONException, ClassNotFoundException {
    Logger.v("PushActionManager$handleActionNavigation");
    String screenName = null;
    Uri uri = null;
    Bundle bundle = null;
    if (actionObject.has(ActionMapperConstants.KEY_SCREEN)) {
      screenName = actionObject.getString(ActionMapperConstants.KEY_SCREEN);
      JSONObject extras = null;
      if (actionObject.has(ActionMapperConstants.KEY_EXTRA)) {
        extras = actionObject.getJSONObject(ActionMapperConstants.KEY_EXTRA);
      }
      bundle = MoEHelperUtils.convertJSONObjecttoBundle(extras);
    } else if (actionObject.has(ActionMapperConstants.KEY_URI)) {
      Uri link = Uri.parse(actionObject.getString(ActionMapperConstants.KEY_URI));
      Uri.Builder builder = link.buildUpon();
      uri = builder.build();
    }
    if (!MoEPushCallBacks.getInstance().onPushNavigationAction(screenName, bundle, uri)) {
      if (!TextUtils.isEmpty(screenName)) {
        Intent intent = new Intent(context, Class.forName(screenName));
        if (bundle != null) {
          intent.putExtras(bundle);
        }
        if (!PushManager.getInstance().isBackStackBuilderOptedOut(context)) {
          TaskStackBuilder builder = TaskStackBuilder.create(context);
          // This activity is NOT part of this app's task, so create a new task
          // when navigating up, with a synthesized back stack.
          builder.addNextIntentWithParentStack(intent).startActivities();
        } else {
          context.startActivity(intent);
        }
      } else if (uri != null) {
        Intent redirectIntent = new Intent(Intent.ACTION_VIEW, uri);
        context.startActivity(redirectIntent);
      }
    }
  }
}
