package com.moengage.pushbase.push;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.push.PushManager;
import com.moengage.push.PushManager.PushHandler;
import com.moengage.pushbase.PushUtils;

/**
 * @author Umang Chamaria
 */

public class MoEPushWorkerTask extends SDKTask {
  private String workerTaskType;
  private Bundle extras;

  public MoEPushWorkerTask(Context context, @NonNull String workerTaskType,
      @Nullable Bundle extras) {
    super(context);
    this.workerTaskType = workerTaskType;
    this.extras = extras;
  }

  @Override public TaskResult execute() {
    try {
      Logger.v("MoEPushWorkerTask: executing task");
      if (TextUtils.isEmpty(workerTaskType)) return null;
      Logger.v("MoEPushWorkerTask: executing " + workerTaskType);
      switch (workerTaskType) {
        case PushManager.REQ_REFRESH:
          ConfigurationProvider.getInstance(mContext).setGCMToken("");
          registerForPush();
          break;
        case PushManager.REG_ON_APP_OPEN:
          handlePushRegistrationOnAppOpen();
          break;
        case PushManager.SHOW_NOTIFICATION:
          PushHandler pushHandler = PushManager.getInstance().getPushHandler();
          if (pushHandler != null) {
            pushHandler.handlePushPayload(mContext, extras);
          }
          break;
        case PushManager.REQ_REGISTRATION:
          registerForPush();
          break;
      }
      Logger.v("MoEPushWorkerTask: completed task");
    } catch (Exception e) {
      Logger.e("MoEPushWorkerTask: execute() ", e);
    }
    return null;
  }

  @Override public String getTaskTag() {
    return TAG_MOE_PUSH_WORKER_TASK;
  }

  @Override public boolean isSynchronous() {
    return false;
  }

  private void registerForPush() {
    if (!PushUtils.shouldRegisterForPush(mContext)) return;
    PushHandler pushHandler = PushManager.getInstance().getPushHandler();
    if (pushHandler != null) {
      String token = pushHandler.registerForPushToken(mContext);
      Logger.v("MoEPushWorkerTask registerForPush(): registerForPush " + token);
    }
  }

  private void handlePushRegistrationOnAppOpen() {
    if (PushUtils.shouldRegisterForPush(mContext)) {
      PushHandler pushHandler = PushManager.getInstance().getPushHandler();
      if (pushHandler != null) {
        pushHandler.getPushToken(mContext);
      }
    }
  }
}
