/* ************************************************************************
 *
 * MOENGAGE CONFIDENTIAL
 * __________________
 *
 *  [2014] - [2015] MoEngage Inc.
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of MoEngage Inc. The intellectual and technical concepts
 * contained herein are proprietary to MoEngage Incorporated
 * and its suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from MoEngage Incorporated.
 */
package com.moengage.pushbase.push;

import android.app.IntentService;
import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.content.WakefulBroadcastReceiver;
import android.text.TextUtils;
import com.moe.pushlibrary.MoEHelper;
import com.moe.pushlibrary.utils.MoEHelperConstants;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.MoEEventManager;
import com.moengage.push.PushManager;
import com.moengage.push.PushManager.PushHandler;
import com.moengage.pushbase.PushActionMapperConstants;
import com.moengage.pushbase.PushUtils;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * This class works as a Push Worker, it does task related to GCM token update
 * and notification display
 *
 * @author MoEngage (abhishek@moengage.com)
 * @version 1.0
 * @since 5.3
 */
public class MoEPushWorker extends IntentService {

  private final int NAVIGATION_DIRECTION_RIGHT = 1;
  private final int NAVIGATION_DIRECTION_LEFT = -1;
  public static final String NOTIFICATION_DISMISS = "DEAL_WITH_NOTI_AUTODISMISS";
  public static final String EXTRA_SERVICE_CAROUSEL = "DEAL_WITH_CAROUSEL";
  public static final String EXTRA_SERVICE_NOTIFY = "DEAL_WITH_NOTIFICATION";
  public static final String NOTIFICATION_CLEARED = "DEAL_WITH_NOTIFICATION_CLEARED";
  public static final String TRACK_NOTIFICATION_RECEIVED = "DEAL_WITH_NOTIFI_TRACKING";
  public static final String SHOW_NOTIFICATION = "SHOW_NOTIFICATION";
  public static final String PUSH_REG_FALLBACK = "PUSH_REG_FALLBACK";

  public MoEPushWorker() {
    super("RegistrationIntentService");
  }

  /**
   * This method is invoked on the worker thread with a request to process.
   * Only one Intent is processed at a time, but the processing happens on a
   * worker thread that runs independently from other application logic.
   * So, if this code takes a long time, it will hold up other requests to
   * the same IntentService, but it will not hold up anything else.
   * When all requests have been handled, the IntentService stops itself,
   * so you should not call {@link #stopSelf}.
   *
   * @param intent The value passed to {@link
   * Context#startService(Intent)}.
   */
  @Override protected void onHandleIntent(Intent intent) {
    try {
      //TODO add check before calling intent service
      if (null == intent || TextUtils.isEmpty(intent.getAction())) return;
      MoEHelperUtils.dumpIntentExtras(intent);
      Logger.v("MoEPushWorker#onHandleIntent");
      String intentAction = intent.getAction();
      switch (intentAction) {
        case PushManager.REQ_REGISTRATION:
          handlePushRegistration(intent);
          break;
        case PushManager.REQ_DELETE_TOKEN:
          handlePushTokenDeletion(intent);
          break;
        case EXTRA_SERVICE_CAROUSEL:
          handleCarousel(intent);
          break;
        case EXTRA_SERVICE_NOTIFY:
          handleNotification(intent);
          break;
        case NOTIFICATION_CLEARED:
          handleNotificationCleared(intent);
          break;
        case NOTIFICATION_DISMISS:
          handleNotificationDismiss(intent);
          break;
        case TRACK_NOTIFICATION_RECEIVED:
          handleNotificationReceived(intent);
          break;
        case SHOW_NOTIFICATION:
          handleShowNotification(intent);
          break;
        case PUSH_REG_FALLBACK:
          handlePushRegistrationFallback();
          break;
      }
    } catch (Exception e) {
      Logger.f("MoEPushWorker#onHandleIntent: Handle payload", e);
    }
  }

  private void handleShowNotification(Intent intent) {
    Logger.v("MoEPushWorker#onHandleIntent: handleShowNotification");
    PushManager.PushHandler pushHandler = PushManager.getInstance().getPushHandler();
    if (pushHandler != null) {
      pushHandler.handlePushPayload(getApplicationContext(), intent.getExtras());
      WakefulBroadcastReceiver.completeWakefulIntent(intent);
    }
  }

  private void handleNotificationReceived(Intent intent) {
    Logger.v("MoEPushWorker#onHandleIntent: handleNotificationReceived");
    Bundle extras = intent.getExtras();
    tryToShowNotification(extras);
    MoEHelper.getInstance(getApplicationContext()).syncInteractionDataNow();
  }

  private void handleNotificationDismiss(Intent intent) {
    Logger.v("MoEPushWorker#onHandleIntent: handleNotificationDismiss");
    Bundle extras = intent.getExtras();
    int notificationId = extras.getInt(NOTIFICATION_DISMISS);
    if (notificationId != 0) {
      NotificationManager manager =
          (NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE);
      manager.cancel(notificationId);
    }
  }

  private void handleNotificationCleared(Intent intent) throws JSONException {
    Logger.v("MoEPushWorker#onHandleIntent: handleNotificationCleared");
    Bundle extras = intent.getExtras();
    if (extras == null) return;
    JSONObject newJson = new JSONObject();
    newJson.put(MoEHelperConstants.GCM_EXTRA_CAMPAIGN_ID, MoEngageNotificationUtils.getCampaignIdIfAny(extras));
    MoEEventManager.getInstance(getApplicationContext()).trackEvent(MoEHelperConstants
        .EVENT_NOTIFICATION_CLEARED, newJson);
    MoEPushCallBacks.getInstance().onPushCleared(extras);
    MoEHelper.getInstance(getApplicationContext()).syncInteractionDataNow();
    //clear carousel images from internal storage
    MoEngageNotificationUtils.deleteImagesFromInternal(this,
        MoEngageNotificationUtils.getCampaignIdIfAny(extras));
  }

  private void handleNotification(Intent intent) {
    Logger.v("MoEPushWorker#onHandleIntent: handleNotification");
    Bundle extras = intent.getExtras();
    if (extras == null) {
      Logger.f("MoEPushWorker$handleNotification bundle is null");
      return;
    }
    tryToShowNotification(extras);
  }

  private void handleCarousel(Intent intent) {
    Logger.v("MoEPushWorker#onHandleIntent: handleCarousel");
    Bundle extras = intent.getExtras();
    if (extras.containsKey(PushActionMapperConstants.KEY_ACTION_TAG)) {
      String actionTag = extras.getString(PushActionMapperConstants.KEY_ACTION_TAG);
      try {
        if (!TextUtils.isEmpty(actionTag) && actionTag.equals(
            PushActionMapperConstants.IMG_ACTION_NEXT)) {
          recreateCarouselNotification(extras, NAVIGATION_DIRECTION_RIGHT);
        } else if (!TextUtils.isEmpty(actionTag) && actionTag.equals(
            PushActionMapperConstants.IMG_ACTION_PREV)) {
          recreateCarouselNotification(extras, NAVIGATION_DIRECTION_LEFT);
        }
      } catch (Exception e) {
        Logger.f("MoEWorker$handleCarouselNav Exception occurred," + e.getMessage());
      }
    }
  }

  private void handlePushTokenDeletion(Intent intent) {
    Logger.v("MoEPushWorker#onHandleIntent: GCM Token Deletion request");
    Bundle extras = intent.getExtras();
    String senderId = null;
    if (extras.containsKey("SENDER_ID")) {
      senderId = extras.getString("SENDER_ID");
    }
    PushManager.getInstance().getPushHandler().deleteToken(getApplicationContext(), senderId);
  }

  private void handlePushRegistration(Intent intent) {
    Logger.v("MoEPushWorker#onHandleIntent: Registration request");
    if (!PushUtils.shouldRegisterForPush(getApplicationContext())) return;
    ConfigurationProvider provider = ConfigurationProvider.getInstance(getApplicationContext());
    if (intent.hasExtra(MoEHelperConstants.EXTRA_REGISTRATION_ID)) {
      PushManager.getInstance()
          .refreshTokenInternal(getApplicationContext(),
              intent.getStringExtra(MoEHelperConstants.EXTRA_REGISTRATION_ID),
              PushManager.TOKEN_BY_MOE);
    } else {
      registerForPush();
    }
  }

  private void registerForPush() {
    String token =
        PushManager.getInstance().getPushHandler().registerForPushToken(getApplicationContext());
    Logger.v("MoEPushWorker#onHandleIntent: registerForPush " + token);
  }

  /**
   * Helper method to recreate Carousel notification
   *
   * @param extras extras received in payload
   * @param navDir navDir navigation direction
   */
  private void recreateCarouselNotification(Bundle extras, int navDir) {
    Logger.v("MoEPushWorker#onHandleIntent: recreateCarouselNotification");
    try {
      if (navDir == NAVIGATION_DIRECTION_RIGHT) {
        extras.putBoolean(PushActionMapperConstants.IMG_ACTION_NEXT, true);
      } else {
        extras.putBoolean(PushActionMapperConstants.IMG_ACTION_NEXT, false);
      }
      int idx = MoEngageNotificationUtils.getNextImageIndex(extras);
      Logger.v("MoEWorker$recreateCarouselNotification idx" + idx);
      extras.remove(PushActionMapperConstants.KEY_ACTION_TAG);
      extras.remove(PushActionMapperConstants.KEY_ACTION_PAYLOAD);
      extras.remove(PushActionMapperConstants.IMG_ACTION_NEXT);
      extras.remove(PushActionMapperConstants.IMG_ACTION_PREV);
      extras.putBoolean(PushActionMapperConstants.KEY_RENOTIFY, true);
      extras.putInt(PushActionMapperConstants.IMG_INDEX, idx);
      tryToShowNotification(extras);
    } catch (Exception e) {
      Logger.f("MoEWorker$recreateCarouselNotification Exception ocurred " + e);
    }
  }

  /**
   * Pass payload to {@link PushMessageListener} will try to show push notification
   *
   * @param extras push payload
   */
  private void tryToShowNotification(Bundle extras) {
    PushHandler pushHandler = PushManager.getInstance().getPushHandler();
    PushMessageListener pushMessageListener = (PushMessageListener)pushHandler.getMessageListener();
    pushMessageListener.onMessagereceived(getApplicationContext(), extras);
  }

  private void handlePushRegistrationFallback() {
    Logger.v("MoEPushWorker#onHandleIntent: handlePushRegistrationFallback");
    ConfigurationProvider provider = ConfigurationProvider.getInstance(getApplicationContext());
    if (PushUtils.shouldRegisterForPush(getApplicationContext()) && TextUtils.isEmpty(provider.getGCMToken())) {
        registerForPush();
    }
  }
}
