package com.moengage.pushbase.push;

import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.Nullable;

/**
 * @author Umang Chamaria
 */
public class MoEPushCallBacks {

  private OnMoEPushClickListener onMoEPushClickListener;
  private OnMoEPushReceiveListener onMoEPushReceiveListener;
  private OnMoEPushNavigationAction onMoEPushNavigationAction;
  private OnMoEPushClearedListener onMoEPushClearedListener;
  private static MoEPushCallBacks _INSTANCE;

  private MoEPushCallBacks() {
  }

  public static MoEPushCallBacks getInstance() {
    if (_INSTANCE == null) {
      _INSTANCE = new MoEPushCallBacks();
    }
    return _INSTANCE;
  }

  public void setOnMoEPushClickListener(OnMoEPushClickListener onMoEPushClickListener) {
    this.onMoEPushClickListener = onMoEPushClickListener;
  }

  public void setOnMoEPushReceiveListener(OnMoEPushReceiveListener onMoEPushReceiveListener) {
    this.onMoEPushReceiveListener = onMoEPushReceiveListener;
  }

  public  void setOnMoEPushNavigationAction(OnMoEPushNavigationAction onMoEPushNavigationAction){
    this.onMoEPushNavigationAction = onMoEPushNavigationAction;
  }

  public void setOnMoEPushClearedListener(OnMoEPushClearedListener onMoEPushClearedListener){
    this.onMoEPushClearedListener = onMoEPushClearedListener;
  }

  public void onPushReceived(Bundle bundle) {
    if (onMoEPushReceiveListener != null) {
      onMoEPushReceiveListener.onPushReceived(bundle);
    }
  }

  public void onPushClicked(Bundle bundle) {
    if (onMoEPushClickListener != null) {
      onMoEPushClickListener.onPushClick(bundle);
    }
  }

  public boolean onPushNavigationAction(String screenName, Bundle extras, Uri deepLinkUri){
    if (onMoEPushNavigationAction != null){
      return onMoEPushNavigationAction.onClick(screenName, extras, deepLinkUri);
    }
    return false;
  }

  public void onPushCleared(Bundle bundle){
    if (onMoEPushClearedListener != null){
      onMoEPushClearedListener.onPushCleared(bundle);
    }
  }

  public interface OnMoEPushClickListener {
    void onPushClick(Bundle bundle);
  }

  public interface OnMoEPushReceiveListener {
    void onPushReceived(Bundle data);
  }

  public interface OnMoEPushNavigationAction {
    boolean onClick(@Nullable String screenName, @Nullable Bundle extras,
        @Nullable Uri deepLinkUri);
  }

  public interface OnMoEPushClearedListener{
    void onPushCleared(Bundle bundle);
  }
}
