package com.moengage.pushbase.push;

import android.annotation.TargetApi;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.graphics.Color;
import android.os.Build.VERSION;
import android.os.Build.VERSION_CODES;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.moengage.core.Logger;
import com.moengage.pushbase.PushConstants;
import org.json.JSONObject;

/**
 * @author Umang Chamaria
 */
@TargetApi(VERSION_CODES.O) class MoENotificationChannel{

  private static MoENotificationChannel _INSTANCE = null;

  private MoENotificationChannel(){

  }

  public static MoENotificationChannel getInstance(){
    if (_INSTANCE == null){
      _INSTANCE = new MoENotificationChannel();
    }
    return _INSTANCE;
  }

  @Nullable private String createNotificationChannel(Context context, Bundle pushPayload){
    try{
      if (pushPayload == null) return null;
      if (pushPayload.containsKey(PushConstants.PUSH_PAYLOAD_ATTR_CREATE_NOTIFICATION_CHANNEL)){
        String notificationChannelString =
            pushPayload.getString(PushConstants.PUSH_PAYLOAD_ATTR_CREATE_NOTIFICATION_CHANNEL);
        if (!TextUtils.isEmpty(notificationChannelString)){
          JSONObject notificationChannelAttributes = new JSONObject(notificationChannelString);
          String name = null, channelId = null;
          int importance = -999;
          if (notificationChannelAttributes.has(PushConstants.NOTIFICATION_CHANNEL_ATTR_NAME)){
            name = notificationChannelAttributes.getString(
                PushConstants.NOTIFICATION_CHANNEL_ATTR_NAME);
          }
          if (notificationChannelAttributes.has(
              PushConstants.NOTIFICATION_CHANNEL_ATTR_CHANNEL_ID)){
            channelId = notificationChannelAttributes.getString(
                PushConstants.NOTIFICATION_CHANNEL_ATTR_CHANNEL_ID);
          }
          if (notificationChannelAttributes.has(
              PushConstants.NOTIFICATION_CHANNEL_ATTR_IMPORTANCE)){
            importance = notificationChannelAttributes.getInt(
                PushConstants.NOTIFICATION_CHANNEL_ATTR_IMPORTANCE);
          }
          if (TextUtils.isEmpty(name) || TextUtils.isEmpty(channelId) || importance == -999){
            Logger.e("Either name or channel id or importance is missing cannot create "
                + "notification channel");
            return null;
          }
          if (!isImportanceValid(importance)){
            Logger.e("MoENotificationChannel:createNotificationChannel : "
                + "importance not "
                + "valid cannot create notification channel");
            return null;
          }
          NotificationChannel channel = new NotificationChannel(channelId, name, importance);
          if (notificationChannelAttributes.has(
              PushConstants.NOTIFICATION_CHANNEL_ATTR_ENABLE_LIGHTS)){
            channel.enableLights(notificationChannelAttributes.getBoolean(
                PushConstants.NOTIFICATION_CHANNEL_ATTR_ENABLE_LIGHTS));
          }
          if (notificationChannelAttributes.has(
              PushConstants.NOTIFICATION_CHANNEL_ATTR_ENABLE_VIBRATION)){
            channel.enableVibration(notificationChannelAttributes.getBoolean(
                PushConstants.NOTIFICATION_CHANNEL_ATTR_ENABLE_VIBRATION));
          }
          if (notificationChannelAttributes.has(
              PushConstants.NOTIFICATION_CHANNEL_ATTR_BYPASS_DND)){
            channel.setBypassDnd(notificationChannelAttributes.getBoolean(
                PushConstants.NOTIFICATION_CHANNEL_ATTR_BYPASS_DND));
          }
          if (notificationChannelAttributes.has(
              PushConstants.NOTIFICATION_CHANNEL_ATTR_DESCRIPTION)){
            channel.setDescription(notificationChannelAttributes.getString(
                PushConstants.NOTIFICATION_CHANNEL_ATTR_DESCRIPTION));
          }
          if (notificationChannelAttributes.has(PushConstants.NOTIFICATION_CHANNEL_ATTR_GROUP)){
            channel.setGroup(notificationChannelAttributes.getString(
                PushConstants.NOTIFICATION_CHANNEL_ATTR_GROUP));
          }
          if (notificationChannelAttributes.has(
              PushConstants.NOTIFICATION_CHANNEL_ATTR_LIGHT_COLOR)){
            channel.setLightColor(Color.parseColor(notificationChannelAttributes.getString(
                PushConstants.NOTIFICATION_CHANNEL_ATTR_LIGHT_COLOR)));
          }
          if (notificationChannelAttributes.has(
              PushConstants.NOTIFICATION_CHANNEL_ATTR_VISIBILITY)){
            int visibility = notificationChannelAttributes.getInt(
                PushConstants.NOTIFICATION_CHANNEL_ATTR_VISIBILITY);
            if (isVisibilityValid(visibility)){
              channel.setLockscreenVisibility(visibility);
            }
          }
          if (notificationChannelAttributes.has(
              PushConstants.NOTIFICATION_CHANNEL_ATTR_SHOW_BADGE)){
            channel.setShowBadge(notificationChannelAttributes.getBoolean(
                PushConstants.NOTIFICATION_CHANNEL_ATTR_SHOW_BADGE));
          }
          if (notificationChannelAttributes.has(PushConstants.NOTIFICATION_CHANNEL_ATTR_SOUND)){
            // TODO: 21/08/17 add sound customization
          }
          if (notificationChannelAttributes.has(
              PushConstants.NOTIFICATION_CHANNEL_ATTR_VIBRATION_PATTERN)){
            // TODO: 21/08/17 add vibration pattern
          }
          NotificationManager manager =
              (NotificationManager) context.getSystemService(Context.NOTIFICATION_SERVICE);
          manager.createNotificationChannel(channel);
          return channel.getId();
        }
      }
    } catch(Exception e){
      Logger.f("MoEngageNotificationUtils: createNotificationChannel: ", e);
    }
    return null;
  }

  private boolean isImportanceValid(int importance){
    return importance == NotificationManager.IMPORTANCE_DEFAULT
        || importance == NotificationManager.IMPORTANCE_HIGH
        || importance == NotificationManager.IMPORTANCE_LOW
        || importance == NotificationManager.IMPORTANCE_MAX
        || importance == NotificationManager.IMPORTANCE_MIN
        || importance == NotificationManager.IMPORTANCE_NONE
        || importance == NotificationManager.IMPORTANCE_UNSPECIFIED;
  }

  private boolean isVisibilityValid(int visibility){
    return visibility == Notification.VISIBILITY_PRIVATE
        || visibility == Notification.VISIBILITY_PUBLIC
        || visibility == Notification.VISIBILITY_SECRET;
  }

  String getNotificationChannelId(Context context, Bundle pushPayload){
    if (pushPayload.containsKey(PushConstants.PUSH_PAYLOAD_ATTR_NOTIFICATION_CHANNEL_ID)){
      return pushPayload.getString(PushConstants.PUSH_PAYLOAD_ATTR_NOTIFICATION_CHANNEL_ID);
    }
/*    if (pushPayload.containsKey(PushConstants.PUSH_PAYLOAD_ATTR_CREATE_NOTIFICATION_CHANNEL)){
      return createNotificationChannel(context, pushPayload);
    }*/
    return null;
  }

  void createFallbackNotificationChanelIfRequired(Context context){
    if (VERSION.SDK_INT >= VERSION_CODES.O){
    if (!isChannelExists(context, PushConstants.NOTIFICATION_FALLBACK_CHANNEL_ID)){
      Logger.v("MoENotificationChannel: createFallbackNotificationChanelIfRequired() creating "
          + "default channel");
      NotificationManager manager =
          (NotificationManager) context.getSystemService(Context.NOTIFICATION_SERVICE);
      NotificationChannel channel =
          new NotificationChannel(PushConstants.NOTIFICATION_FALLBACK_CHANNEL_ID,
              PushConstants.NOTIFICATION_FALLBACK_CHANNEL_NAME,
              NotificationManager.IMPORTANCE_DEFAULT);
      manager.createNotificationChannel(channel);
    }
    }
  }

  boolean isChannelExists(Context context, String channelID){
    if (VERSION.SDK_INT < VERSION_CODES.O) return true;
    NotificationManager manager =
        (NotificationManager) context.getSystemService(Context.NOTIFICATION_SERVICE);
    return manager.getNotificationChannel(channelID) != null;
  }
}
