package com.moengage.pushbase.fragments;

import android.app.AlarmManager;
import android.app.Dialog;
import android.app.PendingIntent;
import android.app.TimePickerDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.text.format.DateFormat;
import android.view.ContextThemeWrapper;
import android.widget.TimePicker;
import com.moengage.core.Logger;
import com.moengage.pushbase.MoETimePickerDialog;
import com.moengage.pushbase.push.MoEPushWorker;
import java.util.Calendar;

/**
 * Dialog Fragment to show TimePickerDialog
 *
 * @author MoEngage (prashant@moengage.com)
 * @version 1.0
 */
public class TimePickerFragment extends DialogFragment
    implements TimePickerDialog.OnTimeSetListener {

  private final String YEAR = "year";
  private final String MONTH = "month";
  private final String DAY = "day";
  private Bundle extras;
  private static boolean timeDialogShown = false;

  @Override public Dialog onCreateDialog(Bundle savedInstanceState) {

    extras = getArguments();
    if (extras == null) {
      Logger.e("TimePickerFragment$onCreateDialog : Extras is null");
      dismiss();
    }
    timeDialogShown = true;

    // Use the current time as the default values for the picker
    final Calendar c = Calendar.getInstance();
    int hour = c.get(Calendar.HOUR_OF_DAY);
    int minute = c.get(Calendar.MINUTE);

    // Create a new instance of TimePickerDialog and return it
    MoETimePickerDialog timePickerDialog = new MoETimePickerDialog(
        new ContextThemeWrapper(getActivity(), android.R.style.Theme_Holo_Light), this, hour,
        minute, DateFormat.is24HourFormat(getActivity()));
    timePickerDialog.setMin(hour, minute);
    return timePickerDialog;
  }

  public void onTimeSet(TimePicker view, int hourOfDay, int minute) {
    // Do something with the time chosen by the user

    int year = extras.getInt(YEAR);
    int month = extras.getInt(MONTH);
    int day = extras.getInt(DAY);

    extras.remove(YEAR);
    extras.remove(MONTH);
    extras.remove(DAY);

    final Calendar c = Calendar.getInstance();
    c.set(year, month, day, hourOfDay, minute, 0);
    long triggerAtMillis = c.getTimeInMillis();

    Intent laterIntent = new Intent(getActivity(), MoEPushWorker.class);
    laterIntent.setAction(MoEPushWorker.EXTRA_SERVICE_NOTIFY);
    laterIntent.putExtras(extras);
    final int _id = (int) System.currentTimeMillis();
    final PendingIntent alarmPendingIntent =
        PendingIntent.getService(getActivity(), _id, laterIntent,
            PendingIntent.FLAG_UPDATE_CURRENT);

    AlarmManager alarmManager =
        (AlarmManager) getActivity().getSystemService(getActivity().ALARM_SERVICE);
    alarmManager.set(AlarmManager.RTC_WAKEUP, triggerAtMillis, alarmPendingIntent);
    Logger.v("TimePickerFragment : Reminder set at :" + c.getTime());
  }

  @Override public void onDismiss(DialogInterface dialogInterface) {
    super.onDismiss(dialogInterface);
    if (getActivity() != null) {
      getActivity().finish();
    }
    Logger.v("TimePickerFragment$onDismiss: PushTracker:Completed");
    timeDialogShown = false;
  }

  public static boolean isTimeDialogShown() {
    return timeDialogShown;
  }
}