package com.moengage.pushbase.fragments;

import android.app.AlarmManager;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.PendingIntent;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.view.ContextThemeWrapper;
import com.moengage.core.Logger;
import com.moengage.pushbase.PushActionMapperConstants;
import com.moengage.pushbase.push.MoEPushWorker;
import com.moengage.pushbase.push.PushActionManager;
import java.util.Calendar;

/**
 * DialogFragment to show dialog with options for Remind Later
 *
 * @author MoEngage (prashant@moengage.com)
 * @version 1.0
 */
public class LaterDialogFragment extends DialogFragment {

  @Override public Dialog onCreateDialog(Bundle savedInstanceState) {
    final Bundle extras = getArguments();
    if (extras == null) {
      dismiss();
      Logger.v("LaterDialogFragment$onCreateDialog : Extras is null");
    }

    int snoozeTime = getAndRemoveSnoozeExtra(extras, PushActionMapperConstants.ACTION_SNOOZE_TIME);
    int hourToday = getAndRemoveSnoozeExtra(extras, PushActionMapperConstants.ACTION_SNOOZE_TODAY);
    int hourTomorrow =
        getAndRemoveSnoozeExtra(extras, PushActionMapperConstants.ACTION_SNOOZE_TOMORROW);

    extras.putBoolean(PushActionMapperConstants.KEY_RENOTIFY, true);

    Intent laterIntent = new Intent(getActivity(), MoEPushWorker.class);
    laterIntent.setAction(MoEPushWorker.EXTRA_SERVICE_NOTIFY);
    laterIntent.putExtras(extras);
    final int _id = (int) System.currentTimeMillis();
    final PendingIntent alarmPendingIntent =
        PendingIntent.getService(getActivity(), _id, laterIntent,
            PendingIntent.FLAG_UPDATE_CURRENT);

    String snoozeOption = "Remind in " + snoozeTime + " hour";

    int displayTime = hourToday + Calendar.getInstance().get(Calendar.HOUR_OF_DAY);
    String suffix = "AM";
    if (hourToday != -1 && displayTime > 11) {
      suffix = "PM";
    }
    displayTime = displayTime > 12 ? displayTime - 12 : displayTime;
    int displayMinutes = Calendar.getInstance().get(Calendar.MINUTE);
    String todayOption = null;
    if (displayMinutes < 10) {
      todayOption = "Today (" + displayTime + ":0" + displayMinutes + suffix + ")";
    } else {
      todayOption = "Today (" + displayTime + ":" + displayMinutes + suffix + ")";
    }

    suffix = "AM";
    if (hourTomorrow != -1 && hourTomorrow > 11) {
      suffix = "PM";
    }
    displayTime = hourTomorrow;
    displayTime = displayTime > 12 ? displayTime - 12 : displayTime;
    String tomorrowOption = "Tomorrow (" + displayTime + suffix + ")";

    long triggerAtMillisSnoozeTime = -1;
    long triggerAtMillisHourToday = -1;
    long triggerAtMillisHourTomorrow = -1;

    if (snoozeTime != -1) {
      final Calendar c = Calendar.getInstance();
      c.add(Calendar.HOUR_OF_DAY, snoozeTime);
      triggerAtMillisSnoozeTime = c.getTimeInMillis();
    }

    if (hourToday != -1) {
      final Calendar c = Calendar.getInstance();
      c.add(Calendar.MINUTE, (hourToday * 60));
      triggerAtMillisHourToday = c.getTimeInMillis();
    }

    if (hourTomorrow != -1) {
      final Calendar c = Calendar.getInstance();
      c.add(Calendar.DAY_OF_MONTH, 1);
      c.set(Calendar.HOUR_OF_DAY, hourTomorrow);
      c.set(Calendar.MINUTE, 0);
      triggerAtMillisHourTomorrow = c.getTimeInMillis();
    }

    String dateTimeOption = "Pick a date and time";
    CharSequence[] options;
    final long[] snoozeArray;

    if (snoozeTime != -1 && hourToday != -1 && hourTomorrow != -1) {
      //All the options are provided
      options = new CharSequence[] { snoozeOption, todayOption, tomorrowOption, dateTimeOption };
      snoozeArray = new long[] {
          triggerAtMillisSnoozeTime, triggerAtMillisHourToday, triggerAtMillisHourTomorrow, -1
      };
    } else if (snoozeTime == -1 && hourToday != -1 && hourTomorrow != -1) {
      // Only today's and tomorrow's option is available
      options = new CharSequence[] { todayOption, tomorrowOption, dateTimeOption };
      snoozeArray = new long[] { triggerAtMillisHourToday, triggerAtMillisHourTomorrow, -1 };
    } else if (snoozeTime != -1 && hourToday == -1 && hourTomorrow != -1) {
      // Only snooze and tomorrow's option is available
      options = new CharSequence[] { snoozeOption, tomorrowOption, dateTimeOption };
      snoozeArray = new long[] { triggerAtMillisSnoozeTime, triggerAtMillisHourTomorrow, -1 };
    } else if (snoozeTime != -1 && hourToday != -1 && hourTomorrow == -1) {
      // Only snooze and today's option is available
      options = new CharSequence[] { snoozeOption, todayOption, dateTimeOption };
      snoozeArray = new long[] { triggerAtMillisSnoozeTime, triggerAtMillisHourToday, -1 };
    } else if (snoozeTime != -1 && hourToday == -1 && hourTomorrow == -1) {
      // Only snooze is available
      options = new CharSequence[] { snoozeOption, dateTimeOption };
      snoozeArray = new long[] { triggerAtMillisSnoozeTime, -1 };
    } else if (snoozeTime == -1 && hourToday != -1 && hourTomorrow == -1) {
      // Only today's option is available
      options = new CharSequence[] { todayOption, dateTimeOption };
      snoozeArray = new long[] { triggerAtMillisHourToday, -1 };
    } else if (snoozeTime == -1 && hourToday == -1 && hourTomorrow != -1) {
      // Only tomorrow's option is available
      options = new CharSequence[] { tomorrowOption, dateTimeOption };
      snoozeArray = new long[] { triggerAtMillisHourTomorrow, -1 };
    } else {
      // No option available. Show default snooze of 1 hour along with date and time picker
      final Calendar c = Calendar.getInstance();
      c.add(Calendar.HOUR_OF_DAY, 1);
      triggerAtMillisSnoozeTime = c.getTimeInMillis();
      snoozeOption = "Remind in an hour";
      options = new CharSequence[] { snoozeOption, dateTimeOption };
      snoozeArray = new long[] { triggerAtMillisSnoozeTime, -1 };
    }

    // Use the Builder class for convenient dialog construction
    AlertDialog.Builder builder = new AlertDialog.Builder(
        new ContextThemeWrapper(getActivity(), android.R.style.Theme_Holo_Light_Dialog));

    builder.setTitle("Later").setItems(options, new DialogInterface.OnClickListener() {
      public void onClick(DialogInterface dialog, int which) {
        // The 'which' argument contains the index position
        // of the selected item
        long triggerAtMillis = snoozeArray[which];
        if (triggerAtMillis != -1) {
          AlarmManager alarmManager =
              (AlarmManager) getActivity().getSystemService(getActivity().ALARM_SERVICE);
          alarmManager.set(AlarmManager.RTC_WAKEUP, triggerAtMillis, alarmPendingIntent);
          final Calendar c = Calendar.getInstance();
          c.setTimeInMillis(triggerAtMillis);
          Logger.v("LaterDialogFragment : Reminder set at :" + c.getTime());
        } else {
          DialogFragment newFragment = new DatePickerFragment();
          newFragment.setArguments(extras);
          newFragment.show(getActivity().getSupportFragmentManager(), "datePicker");
        }
      }
    });
    // Create the AlertDialog object and return it
    return builder.create();
  }

  @Override public void onDismiss(DialogInterface dialogInterface) {
    super.onDismiss(dialogInterface);
    if (!DatePickerFragment.isDateDialogShown()) {
      if (getActivity() != null) {
        getActivity().finish();
      }
      Logger.v("LaterDialogFragment$onDismiss : PushTracker:Completed");
    }
    PushActionManager.dialogShown = false;
  }

  private int getAndRemoveSnoozeExtra(Bundle extras, String key) {
    int snoozeVal = extras.getInt(key);
    extras.remove(key);
    return snoozeVal;
  }
}
