package com.moengage.pushbase.fragments;

import android.app.DatePickerDialog;
import android.app.Dialog;
import android.content.DialogInterface;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.view.ContextThemeWrapper;
import android.widget.DatePicker;
import com.moengage.core.Logger;
import java.util.Calendar;

/**
 * DialogFragment to show DatePicker Dialog
 *
 * @author MoEngage (prashant@moengage.com)
 * @version 1.0
 */
public class DatePickerFragment extends DialogFragment
    implements DatePickerDialog.OnDateSetListener {

  private final String YEAR = "year";
  private final String MONTH = "month";
  private final String DAY = "day";
  private Bundle extras;
  private static boolean dateDialogShown = false;

  @Override public Dialog onCreateDialog(Bundle savedInstanceState) {

    extras = getArguments();
    if (extras == null) {
      dismiss();
      Logger.v("DatePickerFragment$onCreateDialog : Extras is null");
    }
    dateDialogShown = true;
    // Use the current date as the default date in the picker
    final Calendar c = Calendar.getInstance();
    int year = c.get(Calendar.YEAR);
    int month = c.get(Calendar.MONTH);
    int day = c.get(Calendar.DAY_OF_MONTH);

    // Create a new instance of DatePickerDialog and return it
    DatePickerDialog dialog = new DatePickerDialog(
        new ContextThemeWrapper(getActivity(), android.R.style.Theme_Holo_Light), this, year, month,
        day);
    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.HONEYCOMB) {
      dialog.getDatePicker().setMinDate(System.currentTimeMillis() - 1000);
    }
    return dialog;
  }

  public void onDateSet(DatePicker view, int year, int month, int day) {

    extras.putInt(YEAR, year);
    extras.putInt(MONTH, month);
    extras.putInt(DAY, day);

    DialogFragment newFragment = new TimePickerFragment();
    newFragment.setArguments(extras);
    newFragment.show(getActivity().getSupportFragmentManager(), "timePicker");
  }

  @Override public void onDismiss(DialogInterface dialogInterface) {
    super.onDismiss(dialogInterface);
    if (!TimePickerFragment.isTimeDialogShown()) {
      if (getActivity() != null) {
        getActivity().finish();
      }
      Logger.v("DatePickerFragment$onDismiss: PushTracker:Completed");
    }
    dateDialogShown = false;
  }

  public static boolean isDateDialogShown() {
    return dateDialogShown;
  }
}