package com.moengage.pushbase.activities;

import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import com.moengage.core.Logger;
import com.moengage.push.PushManager;
import com.moengage.push.PushManager.PushHandler;
import com.moengage.pushbase.PushActionMapperConstants;
import com.moengage.pushbase.push.MoEPushCallBacks;
import com.moengage.pushbase.push.PushActionManager;
import com.moengage.pushbase.push.PushMessageListener;
import org.json.JSONObject;

/**
 * @author MoEngage (prashant@moengage.com)
 * @version 1.0
 * @since 6.0.00
 * Activity to handle Later/Snooze action in Notification
 */
public class SnoozeTracker extends FragmentActivity {

  @Override
  protected void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
     Logger.v("SnoozeTracker:Reached");
    Intent intent = getIntent();
    if (null == intent) return;

    Bundle extras = intent.getExtras();
    if (null == extras) {
      return;
    }
    //In case the notification has actions and the action button is clicked it is not dismissed
    PushHandler pushHandler = PushManager.getInstance().getPushHandler();
    PushMessageListener pushMessageListener = (PushMessageListener)pushHandler.getMessageListener();
    //dismiss notification forcefully
    pushMessageListener.dismissNotificationAfterClick(getApplicationContext(), extras);
    //log click impressions
    pushMessageListener.logNotificationClicked(getApplicationContext(), getIntent());
    //callback for push click
    MoEPushCallBacks.getInstance().onPushClicked(extras);

    if (extras.containsKey(PushActionMapperConstants.KEY_ACTION_TAG)) {
       Logger.v("SnoozeTracker: Redirecting to ActionMappper");
      String actionTag = extras.getString(PushActionMapperConstants.KEY_ACTION_TAG);
      String actionPayload = extras.getString(PushActionMapperConstants.KEY_ACTION_PAYLOAD);
      JSONObject actionObject = null;
      try {
        actionObject = new JSONObject(actionPayload);
        PushActionManager.getInstance().onActionPerformed(this, actionTag, actionObject);
      } catch (Exception e) {
         Logger.f("SnoozeTracker: error converting string to JSON," + e.getMessage());
      }
    }
    if (!PushActionManager.isDialogShown()) {
      finish();
       Logger.v("SnoozeTracker:Completed");
    }
  }
}
