/* ************************************************************************
 *
 * MOENGAGE CONFIDENTIAL
 * __________________
 *
 *  [2014] - [2015] MoEngage Inc.
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of MoEngage Inc. The intellectual and technical concepts
 * contained herein are proprietary to MoEngage Incorporated
 * and its suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from MoEngage Incorporated.
 */
package com.moengage.pushbase.activities;

import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.text.TextUtils;
import com.moe.pushlibrary.MoEHelper;
import com.moe.pushlibrary.utils.MoEHelperConstants;
import com.moengage.core.Logger;
import com.moengage.core.MoEDispatcher;
import com.moengage.push.PushManager;
import com.moengage.push.PushManager.PushHandler;
import com.moengage.pushbase.PushActionMapperConstants;
import com.moengage.pushbase.PushConstants;
import com.moengage.pushbase.push.MoEPushCallBacks;
import com.moengage.pushbase.push.MoEngageNotificationUtils;
import com.moengage.pushbase.push.PushActionManager;
import com.moengage.pushbase.push.PushMessageListener;
import org.json.JSONObject;

import static com.moe.pushlibrary.utils.MoEHelperConstants.NOTIFICATION_RECEIVED_MOE;

/**
 * @author MoEngage (abhishek@moengage.com)
 * @version 1.0
 * @since 5.0.7
 */
public class PushTracker extends FragmentActivity{

  @Override protected void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
     Logger.v("PushTracker:Reached ");
    //tracking notification clicked
    Intent intent = getIntent();
    if( null == intent )return;

    Bundle extras = intent.getExtras();
    if (null == extras) {
      return;
    }
    boolean syncNow = false;
    if(intent.hasExtra(MoEHelperConstants.GCM_EXTRA_WEB_URL)) {
      syncNow = true;
    }
    //IN case the notification has actions and the action button is clicked it is not dismissed
    //PushMessageListener listener = PushManager.getInstance().getPushHandler();
    PushHandler pushHandler = PushManager.getInstance().getPushHandler();
    PushMessageListener pushMessageListener = (PushMessageListener)pushHandler.getMessageListener();
    //dismiss notification forcefully
    pushMessageListener.dismissNotificationAfterClick(getApplicationContext(), extras);
    //log click impressions
    pushMessageListener.logNotificationClicked(getApplicationContext(), getIntent());
    //clear carousel images from internal storage if any
    MoEngageNotificationUtils.deleteImagesFromInternal(this, MoEngageNotificationUtils.getCampaignIdIfAny(extras));
    //callback for push click
    MoEPushCallBacks.getInstance().onPushClicked(extras);
    //test in-app campaign
    if (extras.containsKey("moe_inapp_cid")) {
      String campaignId = extras.getString("moe_inapp_cid");
      if (!TextUtils.isEmpty(campaignId)) {
        MoEDispatcher.getInstance(getApplicationContext()).checkAndShowLinkedInApp(campaignId);
      }
    }
    if( extras.containsKey(PushActionMapperConstants.KEY_ACTION_TAG)){
       Logger.v("PushTracker: Redirecting to ActionMapper");
      String actionTag = extras.getString(PushActionMapperConstants.KEY_ACTION_TAG);
      String actionPayload = extras.getString(PushActionMapperConstants.KEY_ACTION_PAYLOAD);
      JSONObject actionObject = null;
      try {
        actionObject = new JSONObject(actionPayload);
        PushActionManager.getInstance().onActionPerformed(this, actionTag, actionObject);
      } catch (Exception e) {
         Logger.f("PushTracker: error converting string to JSON," + e.getMessage());
      }
    }else{
      //remove extras so that it is not tracked twice
      extras.remove(NOTIFICATION_RECEIVED_MOE);
      extras.remove(MoEHelperConstants.GCM_EXTRA_CAMPAIGN_ID);
      if (extras.containsKey(PushConstants.ATTR_CAMPAIGN_ATTRIBUTES)){
        extras.remove(PushConstants.ATTR_CAMPAIGN_ATTRIBUTES);
      }
      //notification click callback required for handling redirection
      pushMessageListener.onHandleRedirection(this, extras);
    }

    if(syncNow){
      MoEHelper.getInstance(getApplicationContext()).syncInteractionDataNow();
    }

    finish();
     Logger.v("PushTracker:Completed");
  }
}
