package com.moengage.pushbase;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.core.executor.TaskProcessor;
import com.moengage.push.PushManager;
import com.moengage.pushbase.push.MoEPushWorker;
import com.moengage.pushbase.push.MoEPushWorkerTask;

/**
 * @author Umang Chamaria
 */

public final class PushUtils {

  private PushUtils(){

  }

  public static void scheduleDeviceRegistrationCall(Context context) {
    if (context == null) {
      Logger.e("PushUtils:Context is null device cannot register for push");
      return;
    }
    if (!shouldRegisterForPush(context)) return;
    Logger.v("PushUtils :: scheduleDeviceRegistrationCall: ");
    if (ConfigurationProvider.getInstance(context).isDeviceRegistered()) return;
    if (MoEUtils.isRegistrationScheduled(context)) return;
    int backOff = MoEUtils.getCurrentExponentialCounter(context);
    if (backOff >= 512) {
      MoEUtils.saveCurrentExponentialCounter(context, 1);
      Logger.e(
          "PushUtils:registration failed miserably so skipping it for now");
      MoEUtils.setRegistrationScheduled(context, false);
      return;
    }
    MoEUtils.saveCurrentExponentialCounter(context, backOff * 2);
    schedulePushRegistration(context, backOff, PushManager.REQ_REGISTRATION);
    MoEUtils.setRegistrationScheduled(context, true);
  }

  public static void schedulePushRegistration(Context context, int backOff, String action) {
    Intent registrationIntent = new Intent(context, MoEPushWorker.class);
    registrationIntent.setAction(action);
    PendingIntent pendingOps =
        PendingIntent.getService(context, 0, registrationIntent, PendingIntent.FLAG_CANCEL_CURRENT);
    AlarmManager alarmManager = (AlarmManager) context.getSystemService(Context.ALARM_SERVICE);
    alarmManager.set(AlarmManager.RTC_WAKEUP, backOff * 1000, pendingOps);
  }

  public static void offLoadTaskToWorker(@NonNull Context context, @NonNull String action) {
    try {
      if (context == null) {
        Logger.e("PushUtils :Context is null cannot call MoEPushWorker");
        return;
      }
      TaskProcessor.getInstance()
          .addTask(new MoEPushWorkerTask(context, action, null));
    } catch (Exception e) {
      Logger.f("PushUtils: offLoadTaskToWorker() ", e);
    }
  }

  public static boolean shouldRegisterForPush(Context context){
    ConfigurationProvider provider = ConfigurationProvider.getInstance(context);
    return provider.isPushRegistrationEnabled() && !provider.isPushNotificationOptedOut();
  }
}
