package com.moengage.pushbase;

/**
 * @author Umang Chamaria
 */

public interface PushConstants {

  String PUSH_PAYLOAD_EXTRA = "update_geo_fences";
  String ATTR_PUSH_PROVIDER = "push_server";
  String ATTR_CAMPAIGN_ATTRIBUTES = "moe_cid_attr";

  String CAROUSEL_ANIMATION_LEFT_TO_RIGHT = "left_to_right";
  String CAROUSEL_ANIMATION_RIGHT_TO_LEFT = "right_to_left";

  /**
   * Associated with the GCM Payload. The URL to open for a
   */
  String MOE_WEB_URL = "moe_webUrl";

  String OPT_OUT_OF_MOE_EXTRAS = "optOutOfExtras";

  /**
   * Key to enable MoEngage logs via push notification
   */
  String ENABLE_DEBUG_LOGS = "moe_enable_logs";
  /**
   * Key to expire notification. This is used for SDK version 7713 and above.
   */
  String MOE_NOTIFICATION_EXPIRY = "inbox_expiry";
  //notification channel constants

  String PUSH_PAYLOAD_ATTR_CREATE_NOTIFICATION_CHANNEL = "moe_create_channel";

  String PUSH_PAYLOAD_ATTR_NOTIFICATION_CHANNEL_ID = "moe_channel_id";

  String NOTIFICATION_CHANNEL_ATTR_CHANNEL_ID  = "channel_id";

  String NOTIFICATION_CHANNEL_ATTR_NAME = "name";

  String NOTIFICATION_CHANNEL_ATTR_IMPORTANCE = "importance";

  String NOTIFICATION_CHANNEL_ATTR_ENABLE_LIGHTS = "enable_light";

  String NOTIFICATION_CHANNEL_ATTR_ENABLE_VIBRATION = "enable_vibration";

  String NOTIFICATION_CHANNEL_ATTR_BYPASS_DND = "bypass_dnd";

  String NOTIFICATION_CHANNEL_ATTR_DESCRIPTION = "description";

  String NOTIFICATION_CHANNEL_ATTR_GROUP = "group";

  String NOTIFICATION_CHANNEL_ATTR_LIGHT_COLOR = "light_color";

  String NOTIFICATION_CHANNEL_ATTR_VISIBILITY = "visibility";

  String NOTIFICATION_CHANNEL_ATTR_SHOW_BADGE = "show_badge";

  String NOTIFICATION_CHANNEL_ATTR_SOUND = "sound";

  String NOTIFICATION_CHANNEL_ATTR_AUDIO_ATTRIBUTES = "audio";

  String NOTIFICATION_CHANNEL_ATTR_VIBRATION_PATTERN = "vibration_pattern";

  // fallback channel constants
  String NOTIFICATION_FALLBACK_CHANNEL_ID = "moe_default_channel";

  String NOTIFICATION_FALLBACK_CHANNEL_NAME = "General";

}
