/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.pushamp.internal.repository.remote;

import androidx.annotation.Nullable;
import com.moengage.core.Logger;
import com.moengage.core.rest.Response;
import com.moengage.core.utils.ApiUtility;
import com.moengage.pushamp.internal.repository.models.PushAmpSyncResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class ResponseParser {
    private static final String TAG = "PushAmp_2.1.02_ResponseParser";
    private static String RESPONSE_ATTR_MESSAGE_INFO = "messagesInfo";
    private static String RESPONSE_ATTR_ON_APP_OPEN = "on_app_open";
    private static String RESPONSE_ATTR_RESPONSE_DATA = "data";

    ResponseParser() {
    }

    PushAmpSyncResponse parseSyncResponse(@Nullable Response response) {
        try {
            if (!ApiUtility.isSuccessfulResponse((Response)response)) {
                Logger.v((String)"PushAmp_2.1.02_ResponseParser parseSyncResponse() : Sync Failed.");
                if (response != null) {
                    Logger.e((String)("PushAmp_2.1.02_ResponseParser parseSyncResponse() : Error Message: " + response.errorMessage));
                }
                return new PushAmpSyncResponse(false);
            }
            if (response.responseBody == null) {
                Logger.v((String)"PushAmp_2.1.02_ResponseParser parseSyncResponse() :  No response campaigns to show.");
                return new PushAmpSyncResponse(true);
            }
            JSONObject responseJson = new JSONObject(response.responseBody);
            boolean isAppOpen = responseJson.optBoolean(RESPONSE_ATTR_ON_APP_OPEN, false);
            if (!responseJson.has(RESPONSE_ATTR_MESSAGE_INFO)) {
                return new PushAmpSyncResponse(true);
            }
            JSONArray payloadArray = responseJson.getJSONArray(RESPONSE_ATTR_MESSAGE_INFO);
            ArrayList<Map<String, String>> payloadList = new ArrayList<Map<String, String>>();
            for (int i = 0; i < payloadArray.length(); ++i) {
                JSONObject jsonPayload = payloadArray.getJSONObject(i);
                Map<String, String> payloadMap = this.jsonPayloadToMap(jsonPayload, isAppOpen);
                if (payloadMap == null) continue;
                payloadList.add(payloadMap);
            }
            return new PushAmpSyncResponse(true, payloadList);
        }
        catch (Exception e) {
            Logger.e((String)"PushAmp_2.1.02_ResponseParser parseSyncResponse() : Exception ", (Throwable)e);
            return new PushAmpSyncResponse(false);
        }
    }

    @Nullable
    private Map<String, String> jsonPayloadToMap(JSONObject payloadJson, boolean isAppOpen) {
        try {
            if (!payloadJson.has(RESPONSE_ATTR_RESPONSE_DATA)) {
                return null;
            }
            Map<String, String> payloadMap = this.jsonToMap(payloadJson = payloadJson.getJSONObject(RESPONSE_ATTR_RESPONSE_DATA));
            if (payloadMap == null) {
                return null;
            }
            this.addPushSource(payloadMap);
            this.addSyncSource(payloadMap, isAppOpen);
            return payloadMap;
        }
        catch (JSONException e) {
            Logger.e((String)"PushAmp_2.1.02_ResponseParser jsonPayloadToMap() : Exception ", (Throwable)e);
            return null;
        }
    }

    private Map<String, String> jsonToMap(JSONObject payloadJson) throws JSONException {
        HashMap<String, String> map = new HashMap<String, String>(payloadJson.length());
        Iterator iterator = payloadJson.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            String value = payloadJson.getString(key);
            map.put(key, value);
        }
        return map;
    }

    private void addPushSource(Map<String, String> payloadMap) {
        payloadMap.put("moe_push_source", "remote_inbox");
    }

    private void addSyncSource(Map<String, String> payloadMap, boolean isAppOpen) {
        payloadMap.put("from_appOpen", Boolean.toString(isAppOpen));
    }
}

