/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.pushamp.internal.repository;

import androidx.annotation.WorkerThread;
import com.moengage.core.MoEUtils;
import com.moengage.core.RemoteConfig;
import com.moengage.core.model.BaseRequest;
import com.moengage.pushamp.internal.repository.local.LocalRepository;
import com.moengage.pushamp.internal.repository.models.PushAmpSyncRequest;
import com.moengage.pushamp.internal.repository.models.PushAmpSyncResponse;
import com.moengage.pushamp.internal.repository.remote.RemoteRepository;
import org.json.JSONException;

public class PushAmpRepository {
    private LocalRepository localRepository;
    private RemoteRepository remoteRepository;

    public PushAmpRepository(LocalRepository localRepository, RemoteRepository remoteRepository) {
        this.localRepository = localRepository;
        this.remoteRepository = remoteRepository;
    }

    @WorkerThread
    public PushAmpSyncResponse fetchCampaignsFromServer(PushAmpSyncRequest request) {
        PushAmpSyncResponse pushAmpSyncResponse = this.remoteRepository.fetchCampaignsFromServer(request);
        if (pushAmpSyncResponse.isSuccessful) {
            this.localRepository.setLastSyncTime(MoEUtils.currentMillis());
        }
        return pushAmpSyncResponse;
    }

    public long getMinimumSyncDelay() {
        return this.localRepository.getMinimumSyncDelay();
    }

    public long getLastSyncTime() {
        return this.localRepository.getLastSyncTime();
    }

    public BaseRequest getBaseRequest() throws JSONException {
        return this.localRepository.getBaseRequest();
    }

    public RemoteConfig getRemoteConfig() {
        return this.localRepository.getRemoteConfig();
    }

    public boolean isPushNotificationOptedOut() {
        return this.localRepository.isPushNotificationOptedOut();
    }
}

