/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.pushamp.internal;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.core.RemoteConfig;
import com.moengage.core.executor.ITask;
import com.moengage.core.executor.TaskManager;
import com.moengage.core.model.MoEJobParameters;
import com.moengage.pushamp.internal.PushAmpAlarmReceiver;
import com.moengage.pushamp.internal.PushAmpSyncJob;
import com.moengage.pushamp.internal.repository.PushAmpRepository;
import com.moengage.pushamp.internal.repository.models.PushAmpSyncRequest;
import com.moengage.pushamp.internal.repository.models.PushAmpSyncResponse;
import com.moengage.pushamp.internal.repository.remote.PushAmpServerSyncTask;
import com.moengage.pushbase.MoEPushHelper;
import java.util.List;
import java.util.Map;

public class PushAmpController {
    private static final String TAG = "PushAmp_2.1.02_PushAmpController";
    public final PushAmpRepository repository;
    public boolean hasSynced = false;

    PushAmpController(PushAmpRepository repository) {
        this.repository = repository;
    }

    public void showPush(Context context, @Nullable List<Map<String, String>> payloadList) {
        Logger.v((String)"PushAmp_2.1.02_PushAmpController showPush() : Push Amp synced. Will try to show messages.");
        if (payloadList == null) {
            Logger.v((String)"PushAmp_2.1.02_PushAmpController showPush(): No push messages to be shown");
            return;
        }
        for (Map<String, String> payload : payloadList) {
            MoEPushHelper.getInstance().handlePushPayload(context, payload);
        }
    }

    void scheduleServerSync(Context context) {
        Logger.v((String)"PushAmp_2.1.02_PushAmpController scheduleServerSync() : Will schedule server sync.");
        if (!this.shouldSync()) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.scheduleSyncJob(context, this.repository.getMinimumSyncDelay());
        } else {
            this.scheduleSyncAlarm(context, this.repository.getMinimumSyncDelay());
        }
    }

    private void scheduleSyncAlarm(Context context, long minimumDelayDuration) {
        Logger.v((String)"PushAmp_2.1.02_PushAmpController scheduleSyncAlarm() : Scheduling sync alarm");
        Intent alarmIntent = new Intent(context, PushAmpAlarmReceiver.class);
        alarmIntent.setAction("ACTION_SYNC_MESSAGES");
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)20001, (Intent)alarmIntent, (int)0x8000000);
        AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
        if (alarmManager != null) {
            alarmManager.set(0, MoEUtils.currentMillis() + minimumDelayDuration, pendingIntent);
        }
    }

    @SuppressLint(value={"MissingPermission"})
    @TargetApi(value=21)
    private void scheduleSyncJob(Context context, long minimumDelayDuration) {
        JobScheduler jobScheduler;
        Logger.v((String)"PushAmp_2.1.02_PushAmpController scheduleSyncJob() : scheduling sync job");
        ComponentName serviceComponent = new ComponentName(context, PushAmpSyncJob.class);
        JobInfo.Builder builder = new JobInfo.Builder(20002, serviceComponent);
        builder.setOverrideDeadline(MoEUtils.currentMillis() + minimumDelayDuration + 3600000L);
        builder.setMinimumLatency(minimumDelayDuration);
        builder.setRequiredNetworkType(1);
        if (MoEHelperUtils.hasPermission((Context)context, (String)"android.permission.RECEIVE_BOOT_COMPLETED")) {
            builder.setPersisted(true);
        }
        if ((jobScheduler = (JobScheduler)context.getSystemService("jobscheduler")) != null) {
            jobScheduler.schedule(builder.build());
        }
    }

    private void fetchCampaignsFromServer(Context context, boolean fromAppOpen, MoEJobParameters jobParameters) {
        TaskManager.getInstance().startTask((ITask)new PushAmpServerSyncTask(context, fromAppOpen, jobParameters));
    }

    @WorkerThread
    public void fetchAndShowCampaigns(Context context, PushAmpSyncRequest request) {
        PushAmpSyncResponse pushAmpSyncResponse = this.repository.fetchCampaignsFromServer(request);
        this.hasSynced = pushAmpSyncResponse.isSuccessful;
        if (pushAmpSyncResponse.isSuccessful && pushAmpSyncResponse.campaignList != null) {
            this.showPush(context, pushAmpSyncResponse.campaignList);
        }
    }

    void syncOnAppForeground(Context context) {
        Logger.v((String)"PushAmp_2.1.02_PushAmpController syncOnAppForeground() : App came to foreground. Will try to fetch push-amp messages if required.");
        if (this.hasSynced && this.repository.getLastSyncTime() + 900000L > MoEUtils.currentMillis()) {
            Logger.d((String)"PushAmp_2.1.02_PushAmpController syncOnAppForeground() : Push Amp API had synced recently, will not sync again.");
            return;
        }
        Logger.v((String)"PushAmp_2.1.02_PushAmpController syncOnAppForeground() : Fetching campaigns from Push-Amp.");
        this.fetchCampaignsFromServer(context, true, null);
    }

    void backgroundSyncAndSchedule(Context context, @Nullable MoEJobParameters jobParameters) {
        this.fetchCampaignsFromServer(context, false, jobParameters);
        this.scheduleServerSync(context);
    }

    public boolean shouldSync() {
        if (this.repository.isPushNotificationOptedOut()) {
            Logger.i((String)"PushAmp_2.1.02_PushAmpController shouldSync() : Push notifications are opted out, disabling push-amp.");
            return false;
        }
        RemoteConfig remoteConfig = this.repository.getRemoteConfig();
        if (!remoteConfig.isAppEnabled) {
            Logger.i((String)"PushAmp_2.1.02_PushAmpController shouldSync() : App is disabled, disabling push-amp.");
            return false;
        }
        if (!remoteConfig.isPushAmpEnabled) {
            Logger.i((String)"PushAmp_2.1.02_PushAmpController shouldSync() : Push amp is disabled.");
            return false;
        }
        return true;
    }
}

