/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.pushamp.internal.repository.remote;

import android.content.Context;
import androidx.annotation.Nullable;
import com.moengage.core.Logger;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.core.model.MoEJobParameters;
import com.moengage.pushamp.internal.InjectionUtils;
import com.moengage.pushamp.internal.PushAmpConstants;
import com.moengage.pushamp.internal.PushAmpController;
import com.moengage.pushamp.internal.repository.models.PushAmpSyncRequest;

/**
 * Runs on a worker thread for server sync.
 *
 * @author Umang Chamaria
 * Date: 10/04/19
 */
public class PushAmpServerSyncTask extends SDKTask {
  private static final String TAG = PushAmpConstants.MODULE_TAG + "PushAmpServerSyncTask";
  private boolean fromAppOpen;
  @Nullable private MoEJobParameters jobParameters;

  public PushAmpServerSyncTask(Context context, boolean fromAppOpen,
      @Nullable MoEJobParameters parameters) {
    super(context);
    this.fromAppOpen = fromAppOpen;
    this.jobParameters = parameters;
  }

  @Override public TaskResult execute() {
    try {
      Logger.v(TAG + " execute() : Executing task");
      PushAmpController controller = InjectionUtils.getInstance()
          .getController(context);
      if (!controller.shouldSync()) return taskResult;
      PushAmpSyncRequest request =
          new PushAmpSyncRequest(controller.repository.getBaseRequest(), controller.repository.getLastSyncTime(), fromAppOpen);
      controller.fetchAndShowCampaigns(context, request);
      if (jobParameters != null) {
        jobParameters.jobCompleteListener.jobComplete(jobParameters);
      }
      Logger.v(TAG + " execute() : Task Complete");
    } catch (Exception e) {
      Logger.e(TAG + " execute() : Exception: ", e);
    }
    return taskResult;
  }

  @Override public String getTaskTag() {
    return TAG_PUSH_AMP_SERVER_SYNC_TASK;
  }

  @Override public boolean isSynchronous() {
    return true;
  }

}
