/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.pushamp.internal.repository.remote;

import android.net.Uri;
import android.os.Build;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.moengage.core.Logger;
import com.moengage.core.MoEConstants;
import com.moengage.core.rest.RequestBuilder;
import com.moengage.core.rest.RequestBuilder.RequestType;
import com.moengage.core.rest.Response;
import com.moengage.core.rest.RestClient;
import com.moengage.core.utils.JsonBuilder;
import com.moengage.core.RestUtils;
import com.moengage.pushamp.internal.PushAmpConstants;
import com.moengage.pushamp.internal.repository.models.PushAmpSyncRequest;
import org.json.JSONObject;

/**
 * API Manager for Push-Amp Module. All network requests can be found here.
 *
 * @author Umang Chamaria
 * Date: 10/04/19
 */
class ApiManager {
  private static final String TAG = PushAmpConstants.MODULE_TAG + "ApiManager";

  @Nullable @WorkerThread Response fetchCampaignsFromServer(PushAmpSyncRequest request) {
    try {
      Uri.Builder uriBuilder = RestUtils.getBaseUriBuilder()
          .appendEncodedPath(PATH_PARAM_FETCH_CAMPAIGNS);
      RequestBuilder requestBuilder =
          RestUtils.getBaseRequestBuilder(uriBuilder.build(), RequestType.POST,
              request.appId);
      JsonBuilder requestParams = request.defaultParams;
      requestParams.putBoolean(PARAM_IS_APP_OPEN, request.isFromAppOpen)
          .putString(MoEConstants.GENERIC_PARAM_V2_KEY_MODEL, Build.MODEL)
          .putString(MoEConstants.PARAM_LAST_UPDATED, Long.toString(request.lastSyncTime));
      JSONObject jsonBody = new JSONObject();
      jsonBody.put(MoEConstants.REQUEST_ATTR_QUERY_PARAMS, requestParams.build());
      requestBuilder.addBody(jsonBody);
      return new RestClient(requestBuilder.build()).executeRequest();
    } catch (Exception e) {
      Logger.e(TAG + " fetchCampaignsFromServer() : Exception ", e);
    }
    return null;
  }

  private static final String PARAM_IS_APP_OPEN = "on_app_open";

  private static final String PATH_PARAM_FETCH_CAMPAIGNS = "v1/getAndroidInboxMessages";
}
