/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.pushamp.internal.repository.local;

import android.content.Context;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.model.BaseRequest;
import com.moengage.core.RemoteConfig;
import com.moengage.core.RestUtils;
import org.json.JSONException;

/**
 * Providing locally stored data - Shared Preference and Database.
 *
 * @author Umang Chamaria
 * Date: 10/04/19
 */
public class LocalRepository {

  private Context context;

  public LocalRepository(Context context){
    this.context = context;
  }

  /**
   * Save last time push amp API synced successfully.
   * @param lastSyncTime time at which sync completed.
   */
  public void setLastSyncTime(long lastSyncTime){
    ConfigurationProvider.getInstance(context).setLastPushAmpSyncTime(lastSyncTime);
  }

  /**
   * Returns last time push amp API synced successfully
   * @return sync time in milliseconds.
   */
  public long getLastSyncTime(){
    return ConfigurationProvider.getInstance(context).getLastPushAmpSyncTime();
  }

  /**
   * Returns minimum time delay after which push amp API should sync in background.
   * @return sync delay in milliseconds.
   */
  public long getMinimumSyncDelay() {
    return RemoteConfig.getConfig().pushAmpSyncDelay;
  }

  public BaseRequest getBaseRequest() throws JSONException {
    return RestUtils.getBaseRequest(context);
  }

  public RemoteConfig getRemoteConfig(){
    return RemoteConfig.getConfig();
  }

  public boolean isPushNotificationOptedOut(){
    return ConfigurationProvider.getInstance(context).isPushNotificationOptedOut();
  }
}
