/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.pushamp.internal.repository;

import androidx.annotation.WorkerThread;
import com.moengage.core.MoEUtils;
import com.moengage.core.RemoteConfig;
import com.moengage.core.model.BaseRequest;
import com.moengage.pushamp.internal.repository.local.LocalRepository;
import com.moengage.pushamp.internal.repository.models.PushAmpSyncRequest;
import com.moengage.pushamp.internal.repository.models.PushAmpSyncResponse;
import com.moengage.pushamp.internal.repository.remote.RemoteRepository;
import org.json.JSONException;

/**
 * Data provider for push amplification module, Remote/Local data.
 *
 * @author Umang Chamaria
 * Date: 10/04/19
 */
public class PushAmpRepository {

  private LocalRepository localRepository;
  private RemoteRepository remoteRepository;

  public PushAmpRepository(LocalRepository localRepository, RemoteRepository remoteRepository) {
    this.localRepository = localRepository;
    this.remoteRepository = remoteRepository;
  }

  @WorkerThread
  public PushAmpSyncResponse fetchCampaignsFromServer(PushAmpSyncRequest request) {
    PushAmpSyncResponse pushAmpSyncResponse =
        remoteRepository.fetchCampaignsFromServer(request);
    if (pushAmpSyncResponse.isSuccessful) {
      localRepository.setLastSyncTime(MoEUtils.currentMillis());
    }
    return pushAmpSyncResponse;
  }

  public long getMinimumSyncDelay(){
    return localRepository.getMinimumSyncDelay();
  }

  public long getLastSyncTime(){
    return localRepository.getLastSyncTime();
  }

  public BaseRequest getBaseRequest() throws JSONException {
    return localRepository.getBaseRequest();
  }

  public RemoteConfig getRemoteConfig(){
    return localRepository.getRemoteConfig();
  }

  public boolean isPushNotificationOptedOut(){
    return localRepository.isPushNotificationOptedOut();
  }

}
