/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.utils;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonBuilder {
    private JSONObject jsonObject;

    public JsonBuilder() {
        this(null);
    }

    public JsonBuilder(JSONObject json) {
        this.jsonObject = json == null ? new JSONObject() : json;
    }

    public JsonBuilder putString(String key, String value) throws JSONException {
        this.jsonObject.put(key, (Object)value);
        return this;
    }

    public JsonBuilder putInt(String key, int value) throws JSONException {
        this.jsonObject.put(key, value);
        return this;
    }

    public JsonBuilder putDouble(String key, double value) throws JSONException {
        this.jsonObject.put(key, value);
        return this;
    }

    public JsonBuilder putLong(String key, long value) throws JSONException {
        this.jsonObject.put(key, value);
        return this;
    }

    public JsonBuilder putBoolean(String key, boolean value) throws JSONException {
        this.jsonObject.put(key, value);
        return this;
    }

    public JsonBuilder putJsonArray(String key, JSONArray value) throws JSONException {
        this.jsonObject.put(key, (Object)value);
        return this;
    }

    public JsonBuilder putJsonObject(String key, JSONObject value) throws JSONException {
        this.jsonObject.put(key, (Object)value);
        return this;
    }

    public JSONObject build() {
        return this.jsonObject;
    }
}

