/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.rest;

import androidx.annotation.Nullable;
import com.moengage.core.Logger;
import com.moengage.core.MoEConstants;
import com.moengage.core.MoEUtils;
import com.moengage.core.RemoteConfig;
import com.moengage.core.RestUtils;
import com.moengage.core.rest.Request;
import com.moengage.core.rest.RequestBuilder;
import com.moengage.core.rest.Response;
import com.moengage.core.security.AESHandler;
import com.moengage.core.security.SecretKeyType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONObject;

public class RestClient {
    private static final String ENCODING_CHARSET_UTF8 = "UTF-8";
    private static final String CHARACTER_SET = "Accept-Charset";
    private static final String CONTENT_TYPE = "Content-type";
    private String TAG = "";
    private Request request;

    public RestClient(Request request) {
        this.request = request;
        this.TAG = "Core_RestClient " + request.uri.getEncodedPath() + " " + (Object)((Object)request.requestType);
    }

    @Nullable
    public Response executeRequest() {
        return this.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response execute() {
        HttpURLConnection urlConnection = null;
        Response response = null;
        try {
            JSONObject requestBody;
            if (!RemoteConfig.getConfig().isAppEnabled && this.request.uri.getEncodedPath() != null && !this.request.uri.getEncodedPath().contains("v3/sdkconfig/android/")) {
                Logger.v(this.TAG + " execute() : Account blocked will not make api call.");
                Response response2 = null;
                return response2;
            }
            if (this.request.requestType == RequestBuilder.RequestType.POST && this.request.shouldEncrypt) {
                Logger.v(this.TAG + " execute() : Request Body: " + this.request.requestBody);
                requestBody = this.encodeRequestBody(this.request.requestBody);
                if (requestBody == null) {
                    Response response3 = new Response(MoEConstants.ENCRYPTION_FAIL, MoEConstants.ENCRYPTION_FAIL_MESSAGE);
                    return response3;
                }
            } else {
                requestBody = this.request.requestBody;
            }
            String urlString = this.request.uri.toString();
            URL url = new URL(urlString);
            Logger.v(this.TAG + " execute(): Request url: " + urlString);
            urlConnection = "https".equals(this.request.uri.getScheme()) ? (HttpsURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection();
            this.addHeaders(urlConnection, this.request.headersMap);
            this.setContentType(urlConnection, this.request.contentType);
            this.setRequestType(urlConnection, this.request.requestType);
            this.addConnectionTimeOut(urlConnection, this.request.timeOut);
            if (requestBody != null && requestBody.length() > 0) {
                this.addBody(urlConnection, requestBody);
            }
            response = this.getResponse(urlConnection);
        }
        catch (Exception e) {
            Logger.e(this.TAG + " execute() : Exception: ", e);
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
        return response;
    }

    private void addConnectionTimeOut(HttpURLConnection urlConnection, int timeOut) {
        urlConnection.setConnectTimeout(timeOut * 1000);
        urlConnection.setReadTimeout(timeOut * 1000);
    }

    private void setContentType(HttpURLConnection urlConnection, String contentType) {
        urlConnection.setRequestProperty(CONTENT_TYPE, contentType);
    }

    private void setRequestType(HttpURLConnection urlConnection, RequestBuilder.RequestType requestType) throws ProtocolException {
        urlConnection.setRequestMethod(requestType.toString());
    }

    private void addBody(HttpURLConnection urlConnection, JSONObject requestBody) throws IOException {
        urlConnection.setDoOutput(true);
        urlConnection.setRequestProperty(CHARACTER_SET, ENCODING_CHARSET_UTF8);
        urlConnection.setRequestProperty(CONTENT_TYPE, "application/json");
        OutputStream output = urlConnection.getOutputStream();
        if (requestBody != null) {
            Logger.v(this.TAG + " addBody(): Request Body: " + requestBody.toString());
            output.write(requestBody.toString().getBytes(StandardCharsets.UTF_8));
        }
        output.close();
    }

    private void addHeaders(HttpURLConnection urlConnection, Map<String, String> headers) {
        Set<Map.Entry<String, String>> headerMap = headers.entrySet();
        for (Map.Entry<String, String> header : headerMap) {
            Logger.v(this.TAG + " addHeaders(): " + header.getKey() + " : " + header.getValue());
            urlConnection.addRequestProperty(header.getKey(), header.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String convertStreamToString(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return null;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
            }
        }
        finally {
            inputStream.close();
        }
        return stringBuilder.toString();
    }

    private JSONObject encodeRequestBody(JSONObject requestBody) {
        try {
            String encodedRequestBody = AESHandler.encrypt(this.request.encryptionKey, requestBody.toString());
            if (encodedRequestBody != null) {
                JSONObject encodedJsonObject = new JSONObject();
                encodedJsonObject.put("data", (Object)encodedRequestBody);
                return encodedJsonObject;
            }
        }
        catch (Exception ex) {
            Logger.e(this.TAG + " encodeRequestBody(): Exception: ", ex);
        }
        return null;
    }

    private Response getResponse(HttpURLConnection urlConnection) throws Exception {
        String responseBody;
        int responseCode = urlConnection.getResponseCode();
        String encryptionKeyType = urlConnection.getHeaderField("MOE-PAYLOAD-ENC-KEY-TYPE");
        Logger.v(this.TAG + "  getResponse() : encryptionKeyType: " + encryptionKeyType);
        if (responseCode == 200) {
            responseBody = this.convertStreamToString(urlConnection.getInputStream());
            Logger.v(this.TAG + " getResponse() : Response: API Success: response code : " + responseCode + " response body : " + responseBody);
        } else {
            responseBody = this.convertStreamToString(urlConnection.getErrorStream());
            Logger.e(this.TAG + " getResponse() : Response: API Failed: response code :" + responseCode + " reason : " + responseBody);
        }
        if (!MoEUtils.isEmptyString(encryptionKeyType)) {
            JSONObject responseJSON = new JSONObject(responseBody);
            String encryptedResponse = responseJSON.getString("data");
            responseBody = AESHandler.decrypt(RestUtils.getEncryptionSecretKey(SecretKeyType.valueOf(encryptionKeyType.toUpperCase())), encryptedResponse);
            Logger.v(this.TAG + " response code :" + responseCode + " decrypted response body : " + responseBody);
        }
        return new Response(responseCode, responseBody);
    }
}

