/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.rest;

import android.net.Uri;
import androidx.annotation.NonNull;
import com.moengage.core.MoEUtils;
import com.moengage.core.rest.Request;
import com.moengage.core.rest.exceptions.InvalidRequestException;
import com.moengage.core.rest.exceptions.UTF8EncodingException;
import java.security.InvalidKeyException;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class RequestBuilder {
    private RequestType requestType;
    private Map<String, String> headersMap;
    private JSONObject jsonBody;
    private String contentType;
    private Uri uri;
    private int connectionTimeout;
    private String encryptionKey;
    private boolean shouldEncrypt;

    public RequestBuilder(Uri uri, RequestType requestType) {
        this.uri = uri;
        this.requestType = requestType;
        this.headersMap = new HashMap<String, String>();
        this.contentType = "application/json";
        this.connectionTimeout = 10;
    }

    public RequestBuilder addHeader(String headerKey, String headerValue) {
        this.headersMap.put(headerKey, headerValue);
        return this;
    }

    public RequestBuilder addHeaders(Map<String, String> headersMap) {
        this.headersMap.putAll(headersMap);
        return this;
    }

    public RequestBuilder addBody(JSONObject jsonBody) {
        this.jsonBody = jsonBody;
        return this;
    }

    public RequestBuilder setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public RequestBuilder setConnectionTimeOut(int connectionTimeOut) {
        this.connectionTimeout = connectionTimeOut;
        return this;
    }

    public RequestBuilder enableEncryption(@NonNull String encryptionKey) {
        this.encryptionKey = encryptionKey;
        this.shouldEncrypt = true;
        return this;
    }

    public Request build() throws UTF8EncodingException, InvalidRequestException, InvalidKeyException {
        if (this.requestType == RequestType.GET && this.jsonBody != null) {
            throw new InvalidRequestException("GET request cannot have a body.");
        }
        if (this.shouldEncrypt && MoEUtils.isEmptyString(this.encryptionKey)) {
            throw new InvalidKeyException("Encryption key cannot be null.");
        }
        return new Request(this.uri, this.requestType, this.headersMap, this.jsonBody, this.contentType, this.connectionTimeout, this.encryptionKey, this.shouldEncrypt);
    }

    public static enum RequestType {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

