/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.remoteconfig;

import android.content.Context;
import androidx.annotation.Nullable;
import com.moengage.core.Logger;
import com.moengage.core.MoEDAO;
import com.moengage.core.MoEUtils;
import com.moengage.core.RemoteConfig;
import com.moengage.core.remoteconfig.RemoteConfigResponseParser;
import com.moengage.core.rest.Response;

class RemoteConfigResponseHandler {
    private static final String TAG = "Core_RemoteConfigResponseHandler";
    private RemoteConfigResponseParser responseParser = new RemoteConfigResponseParser();

    RemoteConfigResponseHandler() {
    }

    boolean handleConfigApiResponse(Context context, @Nullable Response response) {
        try {
            if (response == null) {
                Logger.e("Core_RemoteConfigResponseHandler handleConfigApiResponse() : response object is null.");
                return false;
            }
            if (response.responseCode != 200) {
                Logger.e("Core_RemoteConfigResponseHandler handleConfigApiResponse() : Network Request failed, error: " + response.errorMessage);
                return false;
            }
            if (MoEUtils.isEmptyString(response.responseBody)) {
                return false;
            }
            RemoteConfig remoteConfig = this.responseParser.parseConfigApiResponse(response);
            if (remoteConfig != null) {
                MoEDAO.getInstance(context).addOrUpdateRemoteConfiguration(response.responseBody);
                RemoteConfig.setRemoteConfig(remoteConfig);
            }
            MoEDAO.getInstance(context).updateConfigApiSyncTime(MoEUtils.currentMillis());
            return true;
        }
        catch (Exception e) {
            Logger.e("Core_RemoteConfigResponseHandler handleConfigApiResponse() : ");
            return false;
        }
    }
}

