/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.model;

import androidx.annotation.Nullable;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.core.model.TrafficSource;
import com.moengage.core.utils.JsonBuilder;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class UserSession {
    private static final String TAG = "Core_UserSession";
    public final String sessionId;
    public final String startTime;
    @Nullable
    public final TrafficSource trafficSource;
    public long lastInteractionTime;
    public final boolean isBackgroundInitiated;
    private static final String SESSION_ID = "session_id";
    private static final String START_TIME = "start_time";
    public static final String LAST_INTERACTION_TIME = "last_interaction_time";
    public static final String SOURCE_ARRAY = "source_array";
    public static final String INITIATED_IN_BACKGROUND = "background_initiated";

    public UserSession(String sessionId, String startTime, @Nullable TrafficSource trafficSource, long lastInteractionTime, boolean isBackgroundInitiated) {
        this.sessionId = sessionId;
        this.startTime = startTime;
        this.trafficSource = trafficSource;
        this.lastInteractionTime = lastInteractionTime;
        this.isBackgroundInitiated = isBackgroundInitiated;
    }

    @Nullable
    public static JSONObject toJson(UserSession userSession) {
        try {
            JsonBuilder builder = new JsonBuilder();
            builder.putString(SESSION_ID, userSession.sessionId).putString(START_TIME, userSession.startTime).putLong(LAST_INTERACTION_TIME, userSession.lastInteractionTime).putInt(INITIATED_IN_BACKGROUND, userSession.isBackgroundInitiated ? 1 : 0);
            JSONArray sourceArray = new JSONArray();
            JSONObject sourceJson = TrafficSource.toJson(userSession.trafficSource);
            if (MoEUtils.hasKeys(sourceJson)) {
                sourceArray.put((Object)sourceJson);
            }
            if (sourceArray.length() > 0) {
                builder.putJsonArray(SOURCE_ARRAY, sourceArray);
            }
            return builder.build();
        }
        catch (Exception e) {
            Logger.e("Core_UserSession toJson() : Exception: ", e);
            return null;
        }
    }

    @Nullable
    public static UserSession fromJsonString(String jsonString) {
        try {
            if (MoEUtils.isNullOrEmpty(jsonString)) {
                return null;
            }
            JSONObject sessionJson = new JSONObject(jsonString);
            return new UserSession(sessionJson.getString(SESSION_ID), sessionJson.getString(START_TIME), UserSession.getTrafficSource(sessionJson), sessionJson.getLong(LAST_INTERACTION_TIME), sessionJson.getInt(INITIATED_IN_BACKGROUND) == 1);
        }
        catch (Exception e) {
            Logger.e("Core_UserSession fromJsonString() : Exception: ", e);
            return null;
        }
    }

    private static TrafficSource getTrafficSource(JSONObject sessionJson) throws JSONException {
        if (sessionJson.has(SOURCE_ARRAY)) {
            return TrafficSource.fromJson(sessionJson.getJSONArray(SOURCE_ARRAY).getJSONObject(0));
        }
        return null;
    }

    public String toString() {
        return "{sessionId : '" + this.sessionId + '\'' + ", startTime : '" + this.startTime + '\'' + ", trafficSource : " + this.trafficSource + ", lastInteractionTime : " + this.lastInteractionTime + ", isBackgroundInitiated : " + this.isBackgroundInitiated + '}';
    }
}

